/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TamperProtectionSettings
extends ConfigObject {
    public static final Integer BLOCK = 0;
    public static final Integer LOG_ONLY = 1;
    public static final Integer BLOCK_WITHOUT_LOG = 2;
    private static final long serialVersionUID = 1L;
    private Boolean lockEnabled;
    private Boolean enabled;
    private Boolean lockAction;
    private Integer action;
    private Boolean lockDisplayNotificationMessage;
    private Boolean displayNotificationMessage;

    public TamperProtectionSettings() {
        this(true);
    }

    public TamperProtectionSettings(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "TamperProtectionSettings";
    }

    public Boolean getDefLockEnabled() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockEnabled() {
        return this.lockEnabled;
    }

    public void setOptLockEnabled(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockEnabled = value;
    }

    public Boolean getDefEnabled() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnabled() {
        return this.enabled;
    }

    public void setOptEnabled(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enabled = value;
    }

    public Boolean getDefLockAction() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockAction() {
        return this.lockAction;
    }

    public void setOptLockAction(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockAction = value;
    }

    public Integer getDefAction() {
        return BLOCK_WITHOUT_LOG;
    }

    public Integer getOptAction() {
        return this.action;
    }

    public String getOptActionValue() throws ValidationException {
        if (this.action == null) {
            return null;
        }
        String s = null;
        switch (this.action) {
            case 0: {
                s = "BLOCK";
                break;
            }
            case 1: {
                s = "LOG_ONLY";
                break;
            }
            case 2: {
                s = "BLOCK_WITHOUT_LOG";
                break;
            }
            default: {
                throw new ValidationException("TamperProtectionSettings/Action: invalid attribute value:" + this.action + "!");
            }
        }
        return s;
    }

    public void setOptAction(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.action = value;
    }

    public void setOptActionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.action = null;
            return;
        }
        if ("BLOCK".equals(value)) {
            this.action = BLOCK;
        } else if ("LOG_ONLY".equals(value)) {
            this.action = LOG_ONLY;
        } else if ("BLOCK_WITHOUT_LOG".equals(value)) {
            this.action = BLOCK_WITHOUT_LOG;
        } else {
            throw new ValidationException("TamperProtectionSettings/Action: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefLockDisplayNotificationMessage() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockDisplayNotificationMessage() {
        return this.lockDisplayNotificationMessage;
    }

    public void setOptLockDisplayNotificationMessage(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockDisplayNotificationMessage = value;
    }

    public Boolean getDefDisplayNotificationMessage() {
        return Boolean.FALSE;
    }

    public Boolean getOptDisplayNotificationMessage() {
        return this.displayNotificationMessage;
    }

    public void setOptDisplayNotificationMessage(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.displayNotificationMessage = value;
    }

    @Override
    public int getObjectType() {
        return 773;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("LockEnabled");
            if (value != null) {
                this.lockEnabled = "1".equals(value);
            }
            if ((value = attris.getValue("Enabled")) != null) {
                this.enabled = "1".equals(value);
            }
            if ((value = attris.getValue("LockAction")) != null) {
                this.lockAction = "1".equals(value);
            }
            if ((value = attris.getValue("Action")) != null) {
                this.setOptActionValue(value);
            }
            if ((value = attris.getValue("LockDisplayNotificationMessage")) != null) {
                this.lockDisplayNotificationMessage = "1".equals(value);
            }
            if ((value = attris.getValue("DisplayNotificationMessage")) != null) {
                this.displayNotificationMessage = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"TamperProtectionSettings".equals(element.getNodeName())) {
            throw new ValidationException("TamperProtectionSettings: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "LockEnabled");
        if (value != null) {
            this.lockEnabled = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Enabled")) != null) {
            this.enabled = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockAction")) != null) {
            this.lockAction = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Action")) != null) {
            this.setOptActionValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockDisplayNotificationMessage")) != null) {
            this.lockDisplayNotificationMessage = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "DisplayNotificationMessage")) != null) {
            this.displayNotificationMessage = "1".equals(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("TamperProtectionSettings/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("TamperProtectionSettings/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("TamperProtectionSettings");
        if (this.lockEnabled != null) {
            element.setAttribute("LockEnabled", this.lockEnabled != false ? "1" : "0");
        }
        if (this.enabled != null) {
            element.setAttribute("Enabled", this.enabled != false ? "1" : "0");
        }
        if (this.lockAction != null) {
            element.setAttribute("LockAction", this.lockAction != false ? "1" : "0");
        }
        if (this.action != null) {
            element.setAttribute("Action", this.getOptActionValue());
        }
        if (this.lockDisplayNotificationMessage != null) {
            element.setAttribute("LockDisplayNotificationMessage", this.lockDisplayNotificationMessage != false ? "1" : "0");
        }
        if (this.displayNotificationMessage != null) {
            element.setAttribute("DisplayNotificationMessage", this.displayNotificationMessage != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<TamperProtectionSettings ");
            if (this.lockEnabled != null) {
                strAttrs.append("LockEnabled=").append(this.lockEnabled != false ? "\"1\" " : "\"0\" ");
            }
            if (this.enabled != null) {
                strAttrs.append("Enabled=").append(this.enabled != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lockAction != null) {
                strAttrs.append("LockAction=").append(this.lockAction != false ? "\"1\" " : "\"0\" ");
            }
            if (this.action != null) {
                strAttrs.append("Action=\"").append(this.getOptActionValue()).append("\" ");
            }
            if (this.lockDisplayNotificationMessage != null) {
                strAttrs.append("LockDisplayNotificationMessage=").append(this.lockDisplayNotificationMessage != false ? "\"1\" " : "\"0\" ");
            }
            if (this.displayNotificationMessage != null) {
                strAttrs.append("DisplayNotificationMessage=").append(this.displayNotificationMessage != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</TamperProtectionSettings>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

