/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SyslogServer
extends ConfigObject {
    public static final Integer UDP = 0;
    public static final Integer TCP = 1;
    public static final Integer TLS = 2;
    public static final Integer CR = 0;
    public static final Integer LF = 1;
    public static final Integer NULL = 2;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private String serverAddress;
    private Integer protocol;
    private Integer port;
    private Integer facilityNumber;
    private Integer lineSeparator;

    public SyslogServer() {
        this(true);
    }

    public SyslogServer(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "SyslogServer";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.serverAddress = value;
    }

    public Integer getDefProtocol() {
        return UDP;
    }

    public Integer getOptProtocol() {
        return this.protocol;
    }

    public String getOptProtocolValue() throws ValidationException {
        if (this.protocol == null) {
            return null;
        }
        String s = null;
        switch (this.protocol) {
            case 0: {
                s = "UDP";
                break;
            }
            case 1: {
                s = "TCP";
                break;
            }
            case 2: {
                s = "TLS";
                break;
            }
            default: {
                throw new ValidationException("SyslogServer/Protocol: invalid attribute value:" + this.protocol + "!");
            }
        }
        return s;
    }

    public void setOptProtocol(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.protocol = value;
    }

    public void setOptProtocolValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.protocol = null;
            return;
        }
        if ("UDP".equals(value)) {
            this.protocol = UDP;
        } else if ("TCP".equals(value)) {
            this.protocol = TCP;
        } else if ("TLS".equals(value)) {
            this.protocol = TLS;
        } else {
            throw new ValidationException("SyslogServer/Protocol: invalid attribute value:" + value + "!");
        }
    }

    public Integer getDefPort() {
        return 514;
    }

    public Integer getOptPort() {
        return this.port;
    }

    public void setOptPort(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.port = value;
    }

    public Integer getDefFacilityNumber() {
        return 6;
    }

    public Integer getOptFacilityNumber() {
        return this.facilityNumber;
    }

    public void setOptFacilityNumber(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.facilityNumber = value;
    }

    public Integer getDefLineSeparator() {
        return CR;
    }

    public Integer getOptLineSeparator() {
        return this.lineSeparator;
    }

    public String getOptLineSeparatorValue() throws ValidationException {
        if (this.lineSeparator == null) {
            return null;
        }
        String s = null;
        switch (this.lineSeparator) {
            case 0: {
                s = "CR";
                break;
            }
            case 1: {
                s = "LF";
                break;
            }
            case 2: {
                s = "NULL";
                break;
            }
            default: {
                throw new ValidationException("SyslogServer/LineSeparator: invalid attribute value:" + this.lineSeparator + "!");
            }
        }
        return s;
    }

    public void setOptLineSeparator(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lineSeparator = value;
    }

    public void setOptLineSeparatorValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.lineSeparator = null;
            return;
        }
        if ("CR".equals(value)) {
            this.lineSeparator = CR;
        } else if ("LF".equals(value)) {
            this.lineSeparator = LF;
        } else if ("NULL".equals(value)) {
            this.lineSeparator = NULL;
        } else {
            throw new ValidationException("SyslogServer/LineSeparator: invalid attribute value:" + value + "!");
        }
    }

    @Override
    public int getObjectType() {
        return 76;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.serverAddress == null) {
            throw new ValidationException("SyslogServer/ServerAddress: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("ServerAddress")) == null) {
                throw new ValidationException("SyslogServer/ServerAddress: attribute is required!");
            }
            this.serverAddress = value;
            value = attris.getValue("Protocol");
            if (value != null) {
                this.setOptProtocolValue(value);
            }
            if ((value = attris.getValue("Port")) != null) {
                try {
                    this.port = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("SyslogServer/Port: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("SyslogServer/Port: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("FacilityNumber")) != null) {
                try {
                    this.facilityNumber = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("SyslogServer/FacilityNumber: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("SyslogServer/FacilityNumber: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("LineSeparator")) != null) {
                this.setOptLineSeparatorValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"SyslogServer".equals(element.getNodeName())) {
            throw new ValidationException("SyslogServer: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ServerAddress")) == null) {
            throw new ValidationException("SyslogServer/ServerAddress: attribute is required!");
        }
        this.serverAddress = value;
        value = XMLHelper.getAttribute(element, "Protocol");
        if (value != null) {
            this.setOptProtocolValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Port")) != null) {
            try {
                this.port = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("SyslogServer/Port: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "FacilityNumber")) != null) {
            try {
                this.facilityNumber = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("SyslogServer/FacilityNumber: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "LineSeparator")) != null) {
            this.setOptLineSeparatorValue(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("SyslogServer/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("SyslogServer/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("SyslogServer");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.serverAddress != null) {
            element.setAttribute("ServerAddress", this.serverAddress);
        }
        if (this.protocol != null) {
            element.setAttribute("Protocol", this.getOptProtocolValue());
        }
        if (this.port != null) {
            element.setAttribute("Port", this.port.toString());
        }
        if (this.facilityNumber != null) {
            element.setAttribute("FacilityNumber", this.facilityNumber.toString());
        }
        if (this.lineSeparator != null) {
            element.setAttribute("LineSeparator", this.getOptLineSeparatorValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SyslogServer ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.serverAddress != null) {
                strAttrs.append("ServerAddress=\"").append(AbstractSchema.checkXMLContent(this.serverAddress)).append("\" ");
            }
            if (this.protocol != null) {
                strAttrs.append("Protocol=\"").append(this.getOptProtocolValue()).append("\" ");
            }
            if (this.port != null) {
                strAttrs.append("Port=\"").append(this.port.toString()).append("\" ");
            }
            if (this.facilityNumber != null) {
                strAttrs.append("FacilityNumber=\"").append(this.facilityNumber.toString()).append("\" ");
            }
            if (this.lineSeparator != null) {
                strAttrs.append("LineSeparator=\"").append(this.getOptLineSeparatorValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SyslogServer>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

