/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SwitchEnforcementRule
extends ConfigObject {
    public static final Integer PASSED = 0;
    public static final Integer FAILED = 1;
    public static final Integer UNAVAILABLE = 2;
    public static final Integer OPEN_PORT = 0;
    public static final Integer CLOSE_PORT = 1;
    public static final Integer ASSIGN_VLAN = 2;
    private static final long serialVersionUID = 1L;
    private Integer checkEap;
    private Integer checkHi;
    private Integer checkProfile;
    private Integer action;
    private String vlanGuid;
    private Integer vlanId;
    private String vlanIdComment;

    public SwitchEnforcementRule() {
        this(true);
    }

    public SwitchEnforcementRule(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "SwitchEnforcementRule";
    }

    public Integer getOptCheckEap() {
        return this.checkEap;
    }

    public String getOptCheckEapValue() throws ValidationException {
        if (this.checkEap == null) {
            return null;
        }
        String s = null;
        switch (this.checkEap) {
            case 0: {
                s = "PASSED";
                break;
            }
            case 1: {
                s = "FAILED";
                break;
            }
            case 2: {
                s = "UNAVAILABLE";
                break;
            }
            default: {
                throw new ValidationException("SwitchEnforcementRule/CheckEap: invalid attribute value:" + this.checkEap + "!");
            }
        }
        return s;
    }

    public void setOptCheckEap(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.checkEap = value;
    }

    public void setOptCheckEapValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.checkEap = null;
            return;
        }
        if ("PASSED".equals(value)) {
            this.checkEap = PASSED;
        } else if ("FAILED".equals(value)) {
            this.checkEap = FAILED;
        } else if ("UNAVAILABLE".equals(value)) {
            this.checkEap = UNAVAILABLE;
        } else {
            throw new ValidationException("SwitchEnforcementRule/CheckEap: invalid attribute value:" + value + "!");
        }
    }

    public Integer getOptCheckHi() {
        return this.checkHi;
    }

    public String getOptCheckHiValue() throws ValidationException {
        if (this.checkHi == null) {
            return null;
        }
        String s = null;
        switch (this.checkHi) {
            case 0: {
                s = "PASSED";
                break;
            }
            case 1: {
                s = "FAILED";
                break;
            }
            case 2: {
                s = "UNAVAILABLE";
                break;
            }
            default: {
                throw new ValidationException("SwitchEnforcementRule/CheckHi: invalid attribute value:" + this.checkHi + "!");
            }
        }
        return s;
    }

    public void setOptCheckHi(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.checkHi = value;
    }

    public void setOptCheckHiValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.checkHi = null;
            return;
        }
        if ("PASSED".equals(value)) {
            this.checkHi = PASSED;
        } else if ("FAILED".equals(value)) {
            this.checkHi = FAILED;
        } else if ("UNAVAILABLE".equals(value)) {
            this.checkHi = UNAVAILABLE;
        } else {
            throw new ValidationException("SwitchEnforcementRule/CheckHi: invalid attribute value:" + value + "!");
        }
    }

    public Integer getOptCheckProfile() {
        return this.checkProfile;
    }

    public String getOptCheckProfileValue() throws ValidationException {
        if (this.checkProfile == null) {
            return null;
        }
        String s = null;
        switch (this.checkProfile) {
            case 0: {
                s = "PASSED";
                break;
            }
            case 1: {
                s = "FAILED";
                break;
            }
            case 2: {
                s = "UNAVAILABLE";
                break;
            }
            default: {
                throw new ValidationException("SwitchEnforcementRule/CheckProfile: invalid attribute value:" + this.checkProfile + "!");
            }
        }
        return s;
    }

    public void setOptCheckProfile(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.checkProfile = value;
    }

    public void setOptCheckProfileValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.checkProfile = null;
            return;
        }
        if ("PASSED".equals(value)) {
            this.checkProfile = PASSED;
        } else if ("FAILED".equals(value)) {
            this.checkProfile = FAILED;
        } else if ("UNAVAILABLE".equals(value)) {
            this.checkProfile = UNAVAILABLE;
        } else {
            throw new ValidationException("SwitchEnforcementRule/CheckProfile: invalid attribute value:" + value + "!");
        }
    }

    public Integer getAction() {
        return this.action;
    }

    public String getActionValue() throws ValidationException {
        if (this.action == null) {
            return null;
        }
        String s = null;
        switch (this.action) {
            case 0: {
                s = "OPEN_PORT";
                break;
            }
            case 1: {
                s = "CLOSE_PORT";
                break;
            }
            case 2: {
                s = "ASSIGN_VLAN";
                break;
            }
            default: {
                throw new ValidationException("SwitchEnforcementRule/Action: invalid attribute value:" + this.action + "!");
            }
        }
        return s;
    }

    public void setAction(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.action = value;
    }

    public void setActionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("OPEN_PORT".equals(value)) {
            this.action = OPEN_PORT;
        } else if ("CLOSE_PORT".equals(value)) {
            this.action = CLOSE_PORT;
        } else if ("ASSIGN_VLAN".equals(value)) {
            this.action = ASSIGN_VLAN;
        } else {
            throw new ValidationException("SwitchEnforcementRule/Action: invalid attribute value:" + value + "!");
        }
    }

    public String getOptVlanGuid() {
        return this.vlanGuid;
    }

    public void setOptVlanGuid(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.vlanGuid = value;
    }

    public Integer getOptVlanId() {
        return this.vlanId;
    }

    public void setOptVlanId(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.vlanId = value;
    }

    public String getOptVlanIdComment() {
        return this.vlanIdComment;
    }

    public void setOptVlanIdComment(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.vlanIdComment = value;
    }

    @Override
    public int getObjectType() {
        return 569;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.action == null) {
            throw new ValidationException("SwitchEnforcementRule/Action: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("CheckEap");
            if (value != null) {
                this.setOptCheckEapValue(value);
            }
            if ((value = attris.getValue("CheckHi")) != null) {
                this.setOptCheckHiValue(value);
            }
            if ((value = attris.getValue("CheckProfile")) != null) {
                this.setOptCheckProfileValue(value);
            }
            if ((value = attris.getValue("Action")) == null) {
                throw new ValidationException("SwitchEnforcementRule/Action: attribute is required!");
            }
            this.setActionValue(value);
            value = attris.getValue("VlanGuid");
            if (value != null) {
                this.vlanGuid = value;
            }
            if ((value = attris.getValue("VlanId")) != null) {
                try {
                    this.vlanId = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("SwitchEnforcementRule/VlanId: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("SwitchEnforcementRule/VlanId: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("VlanIdComment")) != null) {
                this.vlanIdComment = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"SwitchEnforcementRule".equals(element.getNodeName())) {
            throw new ValidationException("SwitchEnforcementRule: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "CheckEap");
        if (value != null) {
            this.setOptCheckEapValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "CheckHi")) != null) {
            this.setOptCheckHiValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "CheckProfile")) != null) {
            this.setOptCheckProfileValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Action")) == null) {
            throw new ValidationException("SwitchEnforcementRule/Action: attribute is required!");
        }
        this.setActionValue(value);
        value = XMLHelper.getAttribute(element, "VlanGuid");
        if (value != null) {
            this.vlanGuid = value;
        }
        if ((value = XMLHelper.getAttribute(element, "VlanId")) != null) {
            try {
                this.vlanId = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("SwitchEnforcementRule/VlanId: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "VlanIdComment")) != null) {
            this.vlanIdComment = value;
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("SwitchEnforcementRule/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("SwitchEnforcementRule/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("SwitchEnforcementRule");
        if (this.checkEap != null) {
            element.setAttribute("CheckEap", this.getOptCheckEapValue());
        }
        if (this.checkHi != null) {
            element.setAttribute("CheckHi", this.getOptCheckHiValue());
        }
        if (this.checkProfile != null) {
            element.setAttribute("CheckProfile", this.getOptCheckProfileValue());
        }
        if (this.action != null) {
            element.setAttribute("Action", this.getActionValue());
        }
        if (this.vlanGuid != null) {
            element.setAttribute("VlanGuid", this.vlanGuid);
        }
        if (this.vlanId != null) {
            element.setAttribute("VlanId", this.vlanId.toString());
        }
        if (this.vlanIdComment != null) {
            element.setAttribute("VlanIdComment", this.vlanIdComment);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SwitchEnforcementRule ");
            if (this.checkEap != null) {
                strAttrs.append("CheckEap=\"").append(this.getOptCheckEapValue()).append("\" ");
            }
            if (this.checkHi != null) {
                strAttrs.append("CheckHi=\"").append(this.getOptCheckHiValue()).append("\" ");
            }
            if (this.checkProfile != null) {
                strAttrs.append("CheckProfile=\"").append(this.getOptCheckProfileValue()).append("\" ");
            }
            if (this.action != null) {
                strAttrs.append("Action=\"").append(this.getActionValue()).append("\" ");
            }
            if (this.vlanGuid != null) {
                strAttrs.append("VlanGuid=\"").append(AbstractSchema.checkXMLContent(this.vlanGuid)).append("\" ");
            }
            if (this.vlanId != null) {
                strAttrs.append("VlanId=\"").append(this.vlanId.toString()).append("\" ");
            }
            if (this.vlanIdComment != null) {
                strAttrs.append("VlanIdComment=\"").append(AbstractSchema.checkXMLContent(this.vlanIdComment)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SwitchEnforcementRule>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

