/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.Vlan;
import com.sygate.scm.util.Utility;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SwitchCharacteristic
extends ConfigObject {
    public static final Integer OTHERS = 0;
    public static final Integer SW_3COM = 1;
    public static final Integer SW_ALCATEL = 2;
    public static final Integer SW_ALCATEL_6200 = 3;
    public static final Integer SW_CISCO_CATALYST = 4;
    public static final Integer SW_DELL = 5;
    public static final Integer SW_ENTERASYS = 6;
    public static final Integer SW_EXTERME = 7;
    public static final Integer SW_FOUNDRY = 8;
    public static final Integer SW_HP = 9;
    public static final Integer SW_NORTEL = 10;
    public static final Integer SW_CISCO_AIRONET = 11;
    public static final Integer SW_ARUBA = 12;
    public static final Integer SW_AIRESPACE_WIRELESS = 13;
    public static final Integer SW_NORTEL_AP = 14;
    public static final Integer SW_ENTERASYS_AP = 15;
    public static final Integer SW_HUAWEI = 16;
    public static final Integer SW_HUAWEI_JAN2009 = 17;
    public static final Integer SW_ALLIED_TELESIS = 18;
    private static final long serialVersionUID = 1L;
    private Integer model;
    private String sharedSecret;
    private Integer reauthTimeout;
    private Boolean supportDynamicVlan;
    private Boolean forwardNonEapAttribute;

    public SwitchCharacteristic() {
        this(true);
    }

    public SwitchCharacteristic(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(3, new ChildGroup(1, 1));
        this.children.put(541, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "SwitchCharacteristic";
    }

    public Integer getDefModel() {
        return OTHERS;
    }

    public Integer getOptModel() {
        return this.model;
    }

    public String getOptModelValue() throws ValidationException {
        if (this.model == null) {
            return null;
        }
        String s = null;
        switch (this.model) {
            case 0: {
                s = "OTHERS";
                break;
            }
            case 1: {
                s = "SW_3COM";
                break;
            }
            case 2: {
                s = "SW_ALCATEL";
                break;
            }
            case 3: {
                s = "SW_ALCATEL_6200";
                break;
            }
            case 4: {
                s = "SW_CISCO_CATALYST";
                break;
            }
            case 5: {
                s = "SW_DELL";
                break;
            }
            case 6: {
                s = "SW_ENTERASYS";
                break;
            }
            case 7: {
                s = "SW_EXTERME";
                break;
            }
            case 8: {
                s = "SW_FOUNDRY";
                break;
            }
            case 9: {
                s = "SW_HP";
                break;
            }
            case 10: {
                s = "SW_NORTEL";
                break;
            }
            case 11: {
                s = "SW_CISCO_AIRONET";
                break;
            }
            case 12: {
                s = "SW_ARUBA";
                break;
            }
            case 13: {
                s = "SW_AIRESPACE_WIRELESS";
                break;
            }
            case 14: {
                s = "SW_NORTEL_AP";
                break;
            }
            case 15: {
                s = "SW_ENTERASYS_AP";
                break;
            }
            case 16: {
                s = "SW_HUAWEI";
                break;
            }
            case 17: {
                s = "SW_HUAWEI_JAN2009";
                break;
            }
            case 18: {
                s = "SW_ALLIED_TELESIS";
                break;
            }
            default: {
                throw new ValidationException("SwitchCharacteristic/Model: invalid attribute value:" + this.model + "!");
            }
        }
        return s;
    }

    public void setOptModel(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.model = value;
    }

    public void setOptModelValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.model = null;
            return;
        }
        if ("OTHERS".equals(value)) {
            this.model = OTHERS;
        } else if ("SW_3COM".equals(value)) {
            this.model = SW_3COM;
        } else if ("SW_ALCATEL".equals(value)) {
            this.model = SW_ALCATEL;
        } else if ("SW_ALCATEL_6200".equals(value)) {
            this.model = SW_ALCATEL_6200;
        } else if ("SW_CISCO_CATALYST".equals(value)) {
            this.model = SW_CISCO_CATALYST;
        } else if ("SW_DELL".equals(value)) {
            this.model = SW_DELL;
        } else if ("SW_ENTERASYS".equals(value)) {
            this.model = SW_ENTERASYS;
        } else if ("SW_EXTERME".equals(value)) {
            this.model = SW_EXTERME;
        } else if ("SW_FOUNDRY".equals(value)) {
            this.model = SW_FOUNDRY;
        } else if ("SW_HP".equals(value)) {
            this.model = SW_HP;
        } else if ("SW_NORTEL".equals(value)) {
            this.model = SW_NORTEL;
        } else if ("SW_CISCO_AIRONET".equals(value)) {
            this.model = SW_CISCO_AIRONET;
        } else if ("SW_ARUBA".equals(value)) {
            this.model = SW_ARUBA;
        } else if ("SW_AIRESPACE_WIRELESS".equals(value)) {
            this.model = SW_AIRESPACE_WIRELESS;
        } else if ("SW_NORTEL_AP".equals(value)) {
            this.model = SW_NORTEL_AP;
        } else if ("SW_ENTERASYS_AP".equals(value)) {
            this.model = SW_ENTERASYS_AP;
        } else if ("SW_HUAWEI".equals(value)) {
            this.model = SW_HUAWEI;
        } else if ("SW_HUAWEI_JAN2009".equals(value)) {
            this.model = SW_HUAWEI_JAN2009;
        } else if ("SW_ALLIED_TELESIS".equals(value)) {
            this.model = SW_ALLIED_TELESIS;
        } else {
            throw new ValidationException("SwitchCharacteristic/Model: invalid attribute value:" + value + "!");
        }
    }

    public String getSharedSecret() {
        try {
            return Utility.decrypt(this.sharedSecret);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setSharedSecret(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        try {
            this.sharedSecret = Utility.encrypt(value);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Integer getDefReauthTimeout() {
        return 30;
    }

    public Integer getOptReauthTimeout() {
        return this.reauthTimeout;
    }

    public void setOptReauthTimeout(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.reauthTimeout = value;
    }

    public Boolean getDefSupportDynamicVlan() {
        return Boolean.TRUE;
    }

    public Boolean getOptSupportDynamicVlan() {
        return this.supportDynamicVlan;
    }

    public void setOptSupportDynamicVlan(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.supportDynamicVlan = value;
    }

    public Boolean getDefForwardNonEapAttribute() {
        return Boolean.TRUE;
    }

    public Boolean getOptForwardNonEapAttribute() {
        return this.forwardNonEapAttribute;
    }

    public void setOptForwardNonEapAttribute(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.forwardNonEapAttribute = value;
    }

    public ObjReference getObjReference() {
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        if (childGroup.size() > 0) {
            return (ObjReference)childGroup.get(0);
        }
        return null;
    }

    public void setObjReference(ObjReference value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ObjReference obj = this.getObjReference();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public void addVlan(Vlan value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addVlan(int index, Vlan value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<Vlan> getVlan() {
        Vector<Vlan> v = new Vector<Vlan>();
        for (Transportable child : (ChildGroup)this.children.get(541)) {
            v.add((Vlan)child);
        }
        return v;
    }

    public int getVlanCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(541);
        return childGroup.size();
    }

    public Vlan getVlan(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(541);
        return (Vlan)childGroup.get(index);
    }

    public void setVlan(int index, Vlan value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeVlan(Vlan value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 540;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.sharedSecret == null) {
            throw new ValidationException("SwitchCharacteristic/SharedSecret: attribute is required!");
        }
        if (this.getObjReference() == null) {
            throw new ValidationException("SwitchCharacteristic/ObjReference: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof ObjReference) {
            try {
                this.setObjReference((ObjReference)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof Vlan) {
            try {
                this.addVlan((Vlan)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Model");
            if (value != null) {
                this.setOptModelValue(value);
            }
            if ((value = attris.getValue("SharedSecret")) == null) {
                throw new ValidationException("SwitchCharacteristic/SharedSecret: attribute is required!");
            }
            this.sharedSecret = value;
            value = attris.getValue("ReauthTimeout");
            if (value != null) {
                try {
                    this.reauthTimeout = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("SwitchCharacteristic/ReauthTimeout: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("SwitchCharacteristic/ReauthTimeout: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("SupportDynamicVlan")) != null) {
                this.supportDynamicVlan = "1".equals(value);
            }
            if ((value = attris.getValue("ForwardNonEapAttribute")) != null) {
                this.forwardNonEapAttribute = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        if (this.getObjReference() != null) {
            this.getObjReference().setReadonly();
        }
        int objCnt = this.getVlanCount();
        for (i = 0; i < objCnt; ++i) {
            this.getVlan(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(3)).size();
        }
        catch (Throwable t) {
            throw new SAXException("SwitchCharacteristic: can't import element == ObjReference!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"SwitchCharacteristic".equals(element.getNodeName())) {
            throw new ValidationException("SwitchCharacteristic: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Model");
        if (value != null) {
            this.setOptModelValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "SharedSecret")) == null) {
            throw new ValidationException("SwitchCharacteristic/SharedSecret: attribute is required!");
        }
        this.sharedSecret = value;
        value = XMLHelper.getAttribute(element, "ReauthTimeout");
        if (value != null) {
            try {
                this.reauthTimeout = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("SwitchCharacteristic/ReauthTimeout: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "SupportDynamicVlan")) != null) {
            this.supportDynamicVlan = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ForwardNonEapAttribute")) != null) {
            this.forwardNonEapAttribute = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "ObjReference")).size() != 1) {
            throw new ValidationException("SwitchCharacteristic/ObjReference: element is require!");
        }
        ObjReference objReferenceObj = new ObjReference();
        objReferenceObj.importFromElement(v.get(0));
        this.setObjReference(objReferenceObj);
        v = XMLHelper.getChildElementByName(element, "Vlan");
        for (int i = 0; i < v.size(); ++i) {
            Vlan vlanObj = new Vlan();
            vlanObj.importFromElement(v.get(i));
            this.addVlan(vlanObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("SwitchCharacteristic/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("SwitchCharacteristic/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("SwitchCharacteristic");
        if (this.model != null) {
            element.setAttribute("Model", this.getOptModelValue());
        }
        if (this.sharedSecret != null) {
            element.setAttribute("SharedSecret", this.sharedSecret);
        }
        if (this.reauthTimeout != null) {
            element.setAttribute("ReauthTimeout", this.reauthTimeout.toString());
        }
        if (this.supportDynamicVlan != null) {
            element.setAttribute("SupportDynamicVlan", this.supportDynamicVlan != false ? "1" : "0");
        }
        if (this.forwardNonEapAttribute != null) {
            element.setAttribute("ForwardNonEapAttribute", this.forwardNonEapAttribute != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SwitchCharacteristic ");
            if (this.model != null) {
                strAttrs.append("Model=\"").append(this.getOptModelValue()).append("\" ");
            }
            if (this.sharedSecret != null) {
                strAttrs.append("SharedSecret=\"").append(AbstractSchema.checkXMLContent(this.sharedSecret)).append("\" ");
            }
            if (this.reauthTimeout != null) {
                strAttrs.append("ReauthTimeout=\"").append(this.reauthTimeout.toString()).append("\" ");
            }
            if (this.supportDynamicVlan != null) {
                strAttrs.append("SupportDynamicVlan=").append(this.supportDynamicVlan != false ? "\"1\" " : "\"0\" ");
            }
            if (this.forwardNonEapAttribute != null) {
                strAttrs.append("ForwardNonEapAttribute=").append(this.forwardNonEapAttribute != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SwitchCharacteristic>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

