/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.ObjReference;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SuspendedItem
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Long deletedTime;
    private String whoDeletedIt;
    private String originalGroupId;

    public SuspendedItem() {
        this(true);
    }

    public SuspendedItem(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(142, new ChildGroup(0, 1));
        this.children.put(3, new ChildGroup(1, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "SuspendedItem";
    }

    public Long getDeletedTime() {
        return this.deletedTime;
    }

    public void setDeletedTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.deletedTime = value;
    }

    public String getOptWhoDeletedIt() {
        return this.whoDeletedIt;
    }

    public void setOptWhoDeletedIt(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.whoDeletedIt = value;
    }

    public String getOptOriginalGroupId() {
        return this.originalGroupId;
    }

    public void setOptOriginalGroupId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.originalGroupId = value;
    }

    public SuspendedItem getOptSuspendedItem() {
        ChildGroup childGroup = (ChildGroup)this.children.get(142);
        if (childGroup.size() > 0) {
            return (SuspendedItem)childGroup.get(0);
        }
        return null;
    }

    public void setOptSuspendedItem(SuspendedItem value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            SuspendedItem obj = this.getOptSuspendedItem();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public ObjReference getObjReference() {
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        if (childGroup.size() > 0) {
            return (ObjReference)childGroup.get(0);
        }
        return null;
    }

    public void setObjReference(ObjReference value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ObjReference obj = this.getObjReference();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 142;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.deletedTime == null) {
            throw new ValidationException("SuspendedItem/DeletedTime: attribute is required!");
        }
        if (this.getObjReference() == null) {
            throw new ValidationException("SuspendedItem/ObjReference: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof SuspendedItem) {
            try {
                this.setOptSuspendedItem((SuspendedItem)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof ObjReference) {
            try {
                this.setObjReference((ObjReference)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("DeletedTime");
            if (value == null) {
                throw new ValidationException("SuspendedItem/DeletedTime: attribute is required!");
            }
            try {
                this.deletedTime = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("SuspendedItem/DeletedTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("SuspendedItem/DeletedTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("WhoDeletedIt");
            if (value != null) {
                this.whoDeletedIt = value;
            }
            if ((value = attris.getValue("OriginalGroupId")) != null) {
                this.originalGroupId = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptSuspendedItem() != null) {
            this.getOptSuspendedItem().setReadonly();
        }
        if (this.getObjReference() != null) {
            this.getObjReference().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(3)).size();
        }
        catch (Throwable t) {
            throw new SAXException("SuspendedItem: can't import element == ObjReference!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"SuspendedItem".equals(element.getNodeName())) {
            throw new ValidationException("SuspendedItem: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "DeletedTime");
        if (value == null) {
            throw new ValidationException("SuspendedItem/DeletedTime: attribute is required!");
        }
        try {
            this.deletedTime = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("SuspendedItem/DeletedTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("SuspendedItem/DeletedTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "WhoDeletedIt");
        if (value != null) {
            this.whoDeletedIt = value;
        }
        if ((value = XMLHelper.getAttribute(element, "OriginalGroupId")) != null) {
            this.originalGroupId = value;
        }
        if ((v = XMLHelper.getChildElementByName(element, "SuspendedItem")).size() > 0) {
            SuspendedItem suspendedItemObj = new SuspendedItem();
            suspendedItemObj.importFromElement(v.get(0));
            this.setOptSuspendedItem(suspendedItemObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "ObjReference")).size() != 1) {
            throw new ValidationException("SuspendedItem/ObjReference: element is require!");
        }
        ObjReference objReferenceObj = new ObjReference();
        objReferenceObj.importFromElement(v.get(0));
        this.setObjReference(objReferenceObj);
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("SuspendedItem/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("SuspendedItem/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("SuspendedItem");
        if (this.deletedTime != null) {
            element.setAttribute("DeletedTime", this.deletedTime.toString());
        }
        if (this.whoDeletedIt != null) {
            element.setAttribute("WhoDeletedIt", this.whoDeletedIt);
        }
        if (this.originalGroupId != null) {
            element.setAttribute("OriginalGroupId", this.originalGroupId);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SuspendedItem ");
            if (this.deletedTime != null) {
                strAttrs.append("DeletedTime=\"").append(this.deletedTime.toString()).append("\" ");
            }
            if (this.whoDeletedIt != null) {
                strAttrs.append("WhoDeletedIt=\"").append(AbstractSchema.checkXMLContent(this.whoDeletedIt)).append("\" ");
            }
            if (this.originalGroupId != null) {
                strAttrs.append("OriginalGroupId=\"").append(AbstractSchema.checkXMLContent(this.originalGroupId)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SuspendedItem>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

