/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StorageMigration
extends ConfigObject {
    public static final Integer SKIP_OFFLINE_FILES = 0;
    public static final Integer SKIP_SPARSE_FILES = 1;
    public static final Integer SKIP_REPARSE_POINT = 2;
    public static final Integer SCAN_RESIDENT_PORTIONS = 3;
    public static final Integer SCAN_ALL_FORCE_DEMIGRATION = 4;
    public static final Integer SCAN_ALL_NO_DEMIGRATION = 5;
    public static final Integer SCAN_RECENT_NO_DEMIGRATION = 6;
    public static final Integer ACCESSED = 0;
    public static final Integer MODIFIED = 1;
    public static final Integer CREATED = 2;
    private static final long serialVersionUID = 1L;
    private Integer storageMigrationOption;
    private Boolean openFileUsingBackupSemantics;
    private Integer accessType;
    private Integer accessDays;

    public StorageMigration() {
        this(true);
    }

    public StorageMigration(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "StorageMigration";
    }

    public Integer getDefStorageMigrationOption() {
        return SKIP_SPARSE_FILES;
    }

    public Integer getOptStorageMigrationOption() {
        return this.storageMigrationOption;
    }

    public String getOptStorageMigrationOptionValue() throws ValidationException {
        if (this.storageMigrationOption == null) {
            return null;
        }
        String s = null;
        switch (this.storageMigrationOption) {
            case 0: {
                s = "SKIP_OFFLINE_FILES";
                break;
            }
            case 1: {
                s = "SKIP_SPARSE_FILES";
                break;
            }
            case 2: {
                s = "SKIP_REPARSE_POINT";
                break;
            }
            case 3: {
                s = "SCAN_RESIDENT_PORTIONS";
                break;
            }
            case 4: {
                s = "SCAN_ALL_FORCE_DEMIGRATION";
                break;
            }
            case 5: {
                s = "SCAN_ALL_NO_DEMIGRATION";
                break;
            }
            case 6: {
                s = "SCAN_RECENT_NO_DEMIGRATION";
                break;
            }
            default: {
                throw new ValidationException("StorageMigration/StorageMigrationOption: invalid attribute value:" + this.storageMigrationOption + "!");
            }
        }
        return s;
    }

    public void setOptStorageMigrationOption(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.storageMigrationOption = value;
    }

    public void setOptStorageMigrationOptionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.storageMigrationOption = null;
            return;
        }
        if ("SKIP_OFFLINE_FILES".equals(value)) {
            this.storageMigrationOption = SKIP_OFFLINE_FILES;
        } else if ("SKIP_SPARSE_FILES".equals(value)) {
            this.storageMigrationOption = SKIP_SPARSE_FILES;
        } else if ("SKIP_REPARSE_POINT".equals(value)) {
            this.storageMigrationOption = SKIP_REPARSE_POINT;
        } else if ("SCAN_RESIDENT_PORTIONS".equals(value)) {
            this.storageMigrationOption = SCAN_RESIDENT_PORTIONS;
        } else if ("SCAN_ALL_FORCE_DEMIGRATION".equals(value)) {
            this.storageMigrationOption = SCAN_ALL_FORCE_DEMIGRATION;
        } else if ("SCAN_ALL_NO_DEMIGRATION".equals(value)) {
            this.storageMigrationOption = SCAN_ALL_NO_DEMIGRATION;
        } else if ("SCAN_RECENT_NO_DEMIGRATION".equals(value)) {
            this.storageMigrationOption = SCAN_RECENT_NO_DEMIGRATION;
        } else {
            throw new ValidationException("StorageMigration/StorageMigrationOption: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefOpenFileUsingBackupSemantics() {
        return Boolean.FALSE;
    }

    public Boolean getOptOpenFileUsingBackupSemantics() {
        return this.openFileUsingBackupSemantics;
    }

    public void setOptOpenFileUsingBackupSemantics(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.openFileUsingBackupSemantics = value;
    }

    public Integer getDefAccessType() {
        return ACCESSED;
    }

    public Integer getOptAccessType() {
        return this.accessType;
    }

    public String getOptAccessTypeValue() throws ValidationException {
        if (this.accessType == null) {
            return null;
        }
        String s = null;
        switch (this.accessType) {
            case 0: {
                s = "ACCESSED";
                break;
            }
            case 1: {
                s = "MODIFIED";
                break;
            }
            case 2: {
                s = "CREATED";
                break;
            }
            default: {
                throw new ValidationException("StorageMigration/AccessType: invalid attribute value:" + this.accessType + "!");
            }
        }
        return s;
    }

    public void setOptAccessType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.accessType = value;
    }

    public void setOptAccessTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.accessType = null;
            return;
        }
        if ("ACCESSED".equals(value)) {
            this.accessType = ACCESSED;
        } else if ("MODIFIED".equals(value)) {
            this.accessType = MODIFIED;
        } else if ("CREATED".equals(value)) {
            this.accessType = CREATED;
        } else {
            throw new ValidationException("StorageMigration/AccessType: invalid attribute value:" + value + "!");
        }
    }

    public Integer getDefAccessDays() {
        return 30;
    }

    public Integer getOptAccessDays() {
        return this.accessDays;
    }

    public void setOptAccessDays(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.accessDays = value;
    }

    @Override
    public int getObjectType() {
        return 672;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("StorageMigrationOption");
            if (value != null) {
                this.setOptStorageMigrationOptionValue(value);
            }
            if ((value = attris.getValue("OpenFileUsingBackupSemantics")) != null) {
                this.openFileUsingBackupSemantics = "1".equals(value);
            }
            if ((value = attris.getValue("AccessType")) != null) {
                this.setOptAccessTypeValue(value);
            }
            if ((value = attris.getValue("AccessDays")) != null) {
                try {
                    this.accessDays = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("StorageMigration/AccessDays: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("StorageMigration/AccessDays: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"StorageMigration".equals(element.getNodeName())) {
            throw new ValidationException("StorageMigration: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "StorageMigrationOption");
        if (value != null) {
            this.setOptStorageMigrationOptionValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "OpenFileUsingBackupSemantics")) != null) {
            this.openFileUsingBackupSemantics = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AccessType")) != null) {
            this.setOptAccessTypeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AccessDays")) != null) {
            try {
                this.accessDays = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("StorageMigration/AccessDays: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("StorageMigration/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("StorageMigration/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("StorageMigration");
        if (this.storageMigrationOption != null) {
            element.setAttribute("StorageMigrationOption", this.getOptStorageMigrationOptionValue());
        }
        if (this.openFileUsingBackupSemantics != null) {
            element.setAttribute("OpenFileUsingBackupSemantics", this.openFileUsingBackupSemantics != false ? "1" : "0");
        }
        if (this.accessType != null) {
            element.setAttribute("AccessType", this.getOptAccessTypeValue());
        }
        if (this.accessDays != null) {
            element.setAttribute("AccessDays", this.accessDays.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<StorageMigration ");
            if (this.storageMigrationOption != null) {
                strAttrs.append("StorageMigrationOption=\"").append(this.getOptStorageMigrationOptionValue()).append("\" ");
            }
            if (this.openFileUsingBackupSemantics != null) {
                strAttrs.append("OpenFileUsingBackupSemantics=").append(this.openFileUsingBackupSemantics != false ? "\"1\" " : "\"0\" ");
            }
            if (this.accessType != null) {
                strAttrs.append("AccessType=\"").append(this.getOptAccessTypeValue()).append("\" ");
            }
            if (this.accessDays != null) {
                strAttrs.append("AccessDays=\"").append(this.accessDays.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</StorageMigration>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

