/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.VersionInformation;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SpcRegisterData
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private String sepmLocalSiteID;
    private String productInstanceID;
    private String tenantName;
    private String spcCertificate;
    private String spcServiceBaseURL;
    private Boolean sysAdminRegistered;
    private Boolean shouldEncode;

    public SpcRegisterData() {
        this(true);
    }

    public SpcRegisterData(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(799, new ChildGroup(1, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "SpcRegisterData";
    }

    public String getsepmLocalSiteID() {
        return this.sepmLocalSiteID;
    }

    public void setsepmLocalSiteID(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.sepmLocalSiteID = value;
    }

    public String getProductInstanceID() {
        return this.productInstanceID;
    }

    public void setProductInstanceID(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.productInstanceID = value;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.tenantName = value;
    }

    public String getSpcCertificate() {
        return this.spcCertificate;
    }

    public void setSpcCertificate(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.spcCertificate = value;
    }

    public String getSpcServiceBaseURL() {
        return this.spcServiceBaseURL;
    }

    public void setSpcServiceBaseURL(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.spcServiceBaseURL = value;
    }

    public Boolean getSysAdminRegistered() {
        return this.sysAdminRegistered;
    }

    public void setSysAdminRegistered(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.sysAdminRegistered = value;
    }

    public Boolean getOptshouldEncode() {
        return this.shouldEncode;
    }

    public void setOptshouldEncode(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.shouldEncode = value;
    }

    public VersionInformation getVersionInformation() {
        ChildGroup childGroup = (ChildGroup)this.children.get(799);
        if (childGroup.size() > 0) {
            return (VersionInformation)childGroup.get(0);
        }
        return null;
    }

    public void setVersionInformation(VersionInformation value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            VersionInformation obj = this.getVersionInformation();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 798;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.sepmLocalSiteID == null) {
            throw new ValidationException("SpcRegisterData/sepmLocalSiteID: attribute is required!");
        }
        if (this.productInstanceID == null) {
            throw new ValidationException("SpcRegisterData/ProductInstanceID: attribute is required!");
        }
        if (this.tenantName == null) {
            throw new ValidationException("SpcRegisterData/TenantName: attribute is required!");
        }
        if (this.spcCertificate == null) {
            throw new ValidationException("SpcRegisterData/SpcCertificate: attribute is required!");
        }
        if (this.spcServiceBaseURL == null) {
            throw new ValidationException("SpcRegisterData/SpcServiceBaseURL: attribute is required!");
        }
        if (this.sysAdminRegistered == null) {
            throw new ValidationException("SpcRegisterData/SysAdminRegistered: attribute is required!");
        }
        if (this.getVersionInformation() == null) {
            throw new ValidationException("SpcRegisterData/VersionInformation: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof VersionInformation) {
            try {
                this.setVersionInformation((VersionInformation)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("sepmLocalSiteID");
            if (value == null) {
                throw new ValidationException("SpcRegisterData/sepmLocalSiteID: attribute is required!");
            }
            this.sepmLocalSiteID = value;
            value = attris.getValue("ProductInstanceID");
            if (value == null) {
                throw new ValidationException("SpcRegisterData/ProductInstanceID: attribute is required!");
            }
            this.productInstanceID = value;
            value = attris.getValue("TenantName");
            if (value == null) {
                throw new ValidationException("SpcRegisterData/TenantName: attribute is required!");
            }
            this.tenantName = value;
            value = attris.getValue("SpcCertificate");
            if (value == null) {
                throw new ValidationException("SpcRegisterData/SpcCertificate: attribute is required!");
            }
            this.spcCertificate = value;
            value = attris.getValue("SpcServiceBaseURL");
            if (value == null) {
                throw new ValidationException("SpcRegisterData/SpcServiceBaseURL: attribute is required!");
            }
            this.spcServiceBaseURL = value;
            value = attris.getValue("SysAdminRegistered");
            if (value == null) {
                throw new ValidationException("SpcRegisterData/SysAdminRegistered: attribute is required!");
            }
            this.sysAdminRegistered = "1".equals(value);
            value = attris.getValue("shouldEncode");
            if (value != null) {
                this.shouldEncode = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getVersionInformation() != null) {
            this.getVersionInformation().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(799)).size();
        }
        catch (Throwable t) {
            throw new SAXException("SpcRegisterData: can't import element == VersionInformation!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"SpcRegisterData".equals(element.getNodeName())) {
            throw new ValidationException("SpcRegisterData: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "sepmLocalSiteID");
        if (value == null) {
            throw new ValidationException("SpcRegisterData/sepmLocalSiteID: attribute is required!");
        }
        this.sepmLocalSiteID = value;
        value = XMLHelper.getAttribute(element, "ProductInstanceID");
        if (value == null) {
            throw new ValidationException("SpcRegisterData/ProductInstanceID: attribute is required!");
        }
        this.productInstanceID = value;
        value = XMLHelper.getAttribute(element, "TenantName");
        if (value == null) {
            throw new ValidationException("SpcRegisterData/TenantName: attribute is required!");
        }
        this.tenantName = value;
        value = XMLHelper.getAttribute(element, "SpcCertificate");
        if (value == null) {
            throw new ValidationException("SpcRegisterData/SpcCertificate: attribute is required!");
        }
        this.spcCertificate = value;
        value = XMLHelper.getAttribute(element, "SpcServiceBaseURL");
        if (value == null) {
            throw new ValidationException("SpcRegisterData/SpcServiceBaseURL: attribute is required!");
        }
        this.spcServiceBaseURL = value;
        value = XMLHelper.getAttribute(element, "SysAdminRegistered");
        if (value == null) {
            throw new ValidationException("SpcRegisterData/SysAdminRegistered: attribute is required!");
        }
        this.sysAdminRegistered = "1".equals(value);
        value = XMLHelper.getAttribute(element, "shouldEncode");
        if (value != null) {
            this.shouldEncode = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "VersionInformation")).size() != 1) {
            throw new ValidationException("SpcRegisterData/VersionInformation: element is require!");
        }
        VersionInformation versionInformationObj = new VersionInformation();
        versionInformationObj.importFromElement(v.get(0));
        this.setVersionInformation(versionInformationObj);
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("SpcRegisterData/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("SpcRegisterData/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("SpcRegisterData");
        if (this.sepmLocalSiteID != null) {
            element.setAttribute("sepmLocalSiteID", this.sepmLocalSiteID);
        }
        if (this.productInstanceID != null) {
            element.setAttribute("ProductInstanceID", this.productInstanceID);
        }
        if (this.tenantName != null) {
            element.setAttribute("TenantName", this.tenantName);
        }
        if (this.spcCertificate != null) {
            element.setAttribute("SpcCertificate", this.spcCertificate);
        }
        if (this.spcServiceBaseURL != null) {
            element.setAttribute("SpcServiceBaseURL", this.spcServiceBaseURL);
        }
        if (this.sysAdminRegistered != null) {
            element.setAttribute("SysAdminRegistered", this.sysAdminRegistered != false ? "1" : "0");
        }
        if (this.shouldEncode != null) {
            element.setAttribute("shouldEncode", this.shouldEncode != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SpcRegisterData ");
            if (this.sepmLocalSiteID != null) {
                strAttrs.append("sepmLocalSiteID=\"").append(AbstractSchema.checkXMLContent(this.sepmLocalSiteID)).append("\" ");
            }
            if (this.productInstanceID != null) {
                strAttrs.append("ProductInstanceID=\"").append(AbstractSchema.checkXMLContent(this.productInstanceID)).append("\" ");
            }
            if (this.tenantName != null) {
                strAttrs.append("TenantName=\"").append(AbstractSchema.checkXMLContent(this.tenantName)).append("\" ");
            }
            if (this.spcCertificate != null) {
                strAttrs.append("SpcCertificate=\"").append(AbstractSchema.checkXMLContent(this.spcCertificate)).append("\" ");
            }
            if (this.spcServiceBaseURL != null) {
                strAttrs.append("SpcServiceBaseURL=\"").append(AbstractSchema.checkXMLContent(this.spcServiceBaseURL)).append("\" ");
            }
            if (this.sysAdminRegistered != null) {
                strAttrs.append("SysAdminRegistered=").append(this.sysAdminRegistered != false ? "\"1\" " : "\"0\" ");
            }
            if (this.shouldEncode != null) {
                strAttrs.append("shouldEncode=").append(this.shouldEncode != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SpcRegisterData>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

