/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.FeedDefinitionList;
import com.sygate.scm.common.configobject.schema.ResultCacheConfig;
import com.sygate.scm.common.configobject.schema.StatelessFeedDefinitionList;
import com.sygate.scm.common.configobject.schema.WebServiceConfiguration;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SpcGlobalConfig
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private String sPCObjects;

    public SpcGlobalConfig() {
        this(true);
    }

    public SpcGlobalConfig(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(791, new ChildGroup(1, 1));
        this.children.put(792, new ChildGroup(0, 1));
        this.children.put(800, new ChildGroup(0, 1));
        this.children.put(790, new ChildGroup(1, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "SpcGlobalConfig";
    }

    public String getOptSPCObjects() {
        return this.sPCObjects;
    }

    public void setOptSPCObjects(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.sPCObjects = value;
    }

    public ResultCacheConfig getResultCacheConfig() {
        ChildGroup childGroup = (ChildGroup)this.children.get(791);
        if (childGroup.size() > 0) {
            return (ResultCacheConfig)childGroup.get(0);
        }
        return null;
    }

    public void setResultCacheConfig(ResultCacheConfig value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ResultCacheConfig obj = this.getResultCacheConfig();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public FeedDefinitionList getOptFeedDefinitionList() {
        ChildGroup childGroup = (ChildGroup)this.children.get(792);
        if (childGroup.size() > 0) {
            return (FeedDefinitionList)childGroup.get(0);
        }
        return null;
    }

    public void setOptFeedDefinitionList(FeedDefinitionList value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            FeedDefinitionList obj = this.getOptFeedDefinitionList();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public StatelessFeedDefinitionList getOptStatelessFeedDefinitionList() {
        ChildGroup childGroup = (ChildGroup)this.children.get(800);
        if (childGroup.size() > 0) {
            return (StatelessFeedDefinitionList)childGroup.get(0);
        }
        return null;
    }

    public void setOptStatelessFeedDefinitionList(StatelessFeedDefinitionList value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            StatelessFeedDefinitionList obj = this.getOptStatelessFeedDefinitionList();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public WebServiceConfiguration getWebServiceConfiguration() {
        ChildGroup childGroup = (ChildGroup)this.children.get(790);
        if (childGroup.size() > 0) {
            return (WebServiceConfiguration)childGroup.get(0);
        }
        return null;
    }

    public void setWebServiceConfiguration(WebServiceConfiguration value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            WebServiceConfiguration obj = this.getWebServiceConfiguration();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 789;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.getResultCacheConfig() == null) {
            throw new ValidationException("SpcGlobalConfig/ResultCacheConfig: attribute is required!");
        }
        if (this.getWebServiceConfiguration() == null) {
            throw new ValidationException("SpcGlobalConfig/WebServiceConfiguration: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof ResultCacheConfig) {
            try {
                this.setResultCacheConfig((ResultCacheConfig)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof FeedDefinitionList) {
            try {
                this.setOptFeedDefinitionList((FeedDefinitionList)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof StatelessFeedDefinitionList) {
            try {
                this.setOptStatelessFeedDefinitionList((StatelessFeedDefinitionList)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof WebServiceConfiguration) {
            try {
                this.setWebServiceConfiguration((WebServiceConfiguration)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("SPCObjects");
            if (value != null) {
                this.sPCObjects = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getResultCacheConfig() != null) {
            this.getResultCacheConfig().setReadonly();
        }
        if (this.getOptFeedDefinitionList() != null) {
            this.getOptFeedDefinitionList().setReadonly();
        }
        if (this.getOptStatelessFeedDefinitionList() != null) {
            this.getOptStatelessFeedDefinitionList().setReadonly();
        }
        if (this.getWebServiceConfiguration() != null) {
            this.getWebServiceConfiguration().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(791)).size();
        }
        catch (Throwable t) {
            throw new SAXException("SpcGlobalConfig: can't import element == ResultCacheConfig!");
        }
        try {
            ((ChildGroup)this.children.get(790)).size();
        }
        catch (Throwable t) {
            throw new SAXException("SpcGlobalConfig: can't import element == WebServiceConfiguration!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"SpcGlobalConfig".equals(element.getNodeName())) {
            throw new ValidationException("SpcGlobalConfig: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "SPCObjects");
        if (value != null) {
            this.sPCObjects = value;
        }
        if ((v = XMLHelper.getChildElementByName(element, "ResultCacheConfig")).size() != 1) {
            throw new ValidationException("SpcGlobalConfig/ResultCacheConfig: element is require!");
        }
        ResultCacheConfig resultCacheConfigObj = new ResultCacheConfig();
        resultCacheConfigObj.importFromElement(v.get(0));
        this.setResultCacheConfig(resultCacheConfigObj);
        v = XMLHelper.getChildElementByName(element, "FeedDefinitionList");
        if (v.size() > 0) {
            FeedDefinitionList feedDefinitionListObj = new FeedDefinitionList();
            feedDefinitionListObj.importFromElement(v.get(0));
            this.setOptFeedDefinitionList(feedDefinitionListObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "StatelessFeedDefinitionList")).size() > 0) {
            StatelessFeedDefinitionList statelessFeedDefinitionListObj = new StatelessFeedDefinitionList();
            statelessFeedDefinitionListObj.importFromElement(v.get(0));
            this.setOptStatelessFeedDefinitionList(statelessFeedDefinitionListObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "WebServiceConfiguration")).size() != 1) {
            throw new ValidationException("SpcGlobalConfig/WebServiceConfiguration: element is require!");
        }
        WebServiceConfiguration webServiceConfigurationObj = new WebServiceConfiguration();
        webServiceConfigurationObj.importFromElement(v.get(0));
        this.setWebServiceConfiguration(webServiceConfigurationObj);
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("SpcGlobalConfig/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("SpcGlobalConfig/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("SpcGlobalConfig");
        if (this.sPCObjects != null) {
            element.setAttribute("SPCObjects", this.sPCObjects);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SpcGlobalConfig ");
            if (this.sPCObjects != null) {
                strAttrs.append("SPCObjects=\"").append(AbstractSchema.checkXMLContent(this.sPCObjects)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SpcGlobalConfig>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

