/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.CommunicationOption;
import com.sygate.scm.common.configobject.schema.InstallationOption;
import com.sygate.scm.common.configobject.schema.PackageInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SoftwarePackage
extends TopLevelObject
implements NamedObject {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String description;
    private String refId;
    private Long creationTime;
    private Boolean suspended;

    public SoftwarePackage() {
        this(true);
    }

    public SoftwarePackage(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(176, new ChildGroup(1, 1));
        this.children.put(179, new ChildGroup(0, 1));
        this.children.put(180, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "SoftwarePackage";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.id = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.name = value;
    }

    @Override
    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.description = value;
    }

    @Override
    public String getOptRefId() {
        return this.refId;
    }

    public void setOptRefId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.refId = value;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.creationTime = value;
    }

    public Boolean getDefSuspended() {
        return Boolean.FALSE;
    }

    public Boolean getOptSuspended() {
        return this.suspended;
    }

    public void setOptSuspended(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.suspended = value;
    }

    public PackageInfo getPackageInfo() {
        ChildGroup childGroup = (ChildGroup)this.children.get(176);
        if (childGroup.size() > 0) {
            return (PackageInfo)childGroup.get(0);
        }
        return null;
    }

    public void setPackageInfo(PackageInfo value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            PackageInfo obj = this.getPackageInfo();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public InstallationOption getOptInstallationOption() {
        ChildGroup childGroup = (ChildGroup)this.children.get(179);
        if (childGroup.size() > 0) {
            return (InstallationOption)childGroup.get(0);
        }
        return null;
    }

    public void setOptInstallationOption(InstallationOption value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            InstallationOption obj = this.getOptInstallationOption();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public CommunicationOption getOptCommunicationOption() {
        ChildGroup childGroup = (ChildGroup)this.children.get(180);
        if (childGroup.size() > 0) {
            return (CommunicationOption)childGroup.get(0);
        }
        return null;
    }

    public void setOptCommunicationOption(CommunicationOption value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            CommunicationOption obj = this.getOptCommunicationOption();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 175;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.id == null) {
            throw new ValidationException("SoftwarePackage/Id: attribute is required!");
        }
        if (this.name == null) {
            throw new ValidationException("SoftwarePackage/Name: attribute is required!");
        }
        if (this.creationTime == null) {
            throw new ValidationException("SoftwarePackage/CreationTime: attribute is required!");
        }
        if (this.getPackageInfo() == null) {
            throw new ValidationException("SoftwarePackage/PackageInfo: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof PackageInfo) {
            try {
                this.setPackageInfo((PackageInfo)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof InstallationOption) {
            try {
                this.setOptInstallationOption((InstallationOption)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof CommunicationOption) {
            try {
                this.setOptCommunicationOption((CommunicationOption)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Id");
            if (value == null) {
                throw new ValidationException("SoftwarePackage/Id: attribute is required!");
            }
            this.id = value;
            value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("SoftwarePackage/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Description");
            if (value != null) {
                this.description = value;
            }
            if ((value = attris.getValue("RefId")) != null) {
                this.refId = value;
            }
            if ((value = attris.getValue("CreationTime")) == null) {
                throw new ValidationException("SoftwarePackage/CreationTime: attribute is required!");
            }
            try {
                this.creationTime = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("SoftwarePackage/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("SoftwarePackage/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("Suspended");
            if (value != null) {
                this.suspended = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getPackageInfo() != null) {
            this.getPackageInfo().setReadonly();
        }
        if (this.getOptInstallationOption() != null) {
            this.getOptInstallationOption().setReadonly();
        }
        if (this.getOptCommunicationOption() != null) {
            this.getOptCommunicationOption().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(176)).size();
        }
        catch (Throwable t) {
            throw new SAXException("SoftwarePackage: can't import element == PackageInfo!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"SoftwarePackage".equals(element.getNodeName())) {
            throw new ValidationException("SoftwarePackage: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Id");
        if (value == null) {
            throw new ValidationException("SoftwarePackage/Id: attribute is required!");
        }
        this.id = value;
        value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("SoftwarePackage/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Description");
        if (value != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RefId")) != null) {
            this.refId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "CreationTime")) == null) {
            throw new ValidationException("SoftwarePackage/CreationTime: attribute is required!");
        }
        try {
            this.creationTime = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("SoftwarePackage/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("SoftwarePackage/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "Suspended");
        if (value != null) {
            this.suspended = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "PackageInfo")).size() != 1) {
            throw new ValidationException("SoftwarePackage/PackageInfo: element is require!");
        }
        PackageInfo packageInfoObj = new PackageInfo();
        packageInfoObj.importFromElement(v.get(0));
        this.setPackageInfo(packageInfoObj);
        v = XMLHelper.getChildElementByName(element, "InstallationOption");
        if (v.size() > 0) {
            InstallationOption installationOptionObj = new InstallationOption();
            installationOptionObj.importFromElement(v.get(0));
            this.setOptInstallationOption(installationOptionObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "CommunicationOption")).size() > 0) {
            CommunicationOption communicationOptionObj = new CommunicationOption();
            communicationOptionObj.importFromElement(v.get(0));
            this.setOptCommunicationOption(communicationOptionObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("SoftwarePackage/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("SoftwarePackage/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("SoftwarePackage");
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.refId != null) {
            element.setAttribute("RefId", this.refId);
        }
        if (this.creationTime != null) {
            element.setAttribute("CreationTime", this.creationTime.toString());
        }
        if (this.suspended != null) {
            element.setAttribute("Suspended", this.suspended != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SoftwarePackage ");
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.refId != null) {
                strAttrs.append("RefId=\"").append(AbstractSchema.checkXMLContent(this.refId)).append("\" ");
            }
            if (this.creationTime != null) {
                strAttrs.append("CreationTime=\"").append(this.creationTime.toString()).append("\" ");
            }
            if (this.suspended != null) {
                strAttrs.append("Suspended=").append(this.suspended != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SoftwarePackage>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

