/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.AutoUpgradeContentOption;
import com.sygate.scm.common.configobject.schema.DeploymentNotification;
import com.sygate.scm.common.configobject.schema.DeploymentSchedule;
import com.sygate.scm.common.configobject.schema.DeploymentSnooze;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.PackageSource;
import com.sygate.scm.common.configobject.schema.SecurityFixContentInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SoftwareDeploymentEntity
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Boolean forceDeployment;
    private Boolean autoUpgradeToEnglish;
    private Long creationTime;

    public SoftwareDeploymentEntity() {
        this(true);
    }

    public SoftwareDeploymentEntity(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(3, new ChildGroup(1, Integer.MAX_VALUE));
        this.children.put(233, new ChildGroup(1, 1));
        this.children.put(736, new ChildGroup(0, 1));
        this.children.put(234, new ChildGroup(0, 1));
        this.children.put(235, new ChildGroup(0, 1));
        this.children.put(237, new ChildGroup(0, 1));
        this.children.put(238, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "SoftwareDeploymentEntity";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public Boolean getDefForceDeployment() {
        return Boolean.FALSE;
    }

    public Boolean getOptForceDeployment() {
        return this.forceDeployment;
    }

    public void setOptForceDeployment(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.forceDeployment = value;
    }

    public Boolean getDefAutoUpgradeToEnglish() {
        return Boolean.FALSE;
    }

    public Boolean getOptAutoUpgradeToEnglish() {
        return this.autoUpgradeToEnglish;
    }

    public void setOptAutoUpgradeToEnglish(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.autoUpgradeToEnglish = value;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.creationTime = value;
    }

    public void addObjReference(ObjReference value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addObjReference(int index, ObjReference value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<ObjReference> getObjReference() {
        Vector<ObjReference> v = new Vector<ObjReference>();
        for (Transportable child : (ChildGroup)this.children.get(3)) {
            v.add((ObjReference)child);
        }
        return v;
    }

    public int getObjReferenceCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        return childGroup.size();
    }

    public ObjReference getObjReference(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        return (ObjReference)childGroup.get(index);
    }

    public ObjReference getObjReferenceByType(String type) {
        if (type == null) {
            return null;
        }
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        for (int i = 0; i < childGroup.size(); ++i) {
            ObjReference reference = (ObjReference)childGroup.get(i);
            if (!type.equals(reference.getTargetType())) continue;
            return reference;
        }
        return null;
    }

    public ObjReference getObjReferenceByTypeAndName(String type, String name) {
        if (type == null || name == null) {
            return null;
        }
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        for (int i = 0; i < childGroup.size(); ++i) {
            ObjReference reference = (ObjReference)childGroup.get(i);
            if (!type.equals(reference.getTargetType()) || !name.equals(reference.getName())) continue;
            return reference;
        }
        return null;
    }

    public void setObjReference(int index, ObjReference value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeObjReference(ObjReference value) {
        this.removeChild(value);
    }

    public PackageSource getPackageSource() {
        ChildGroup childGroup = (ChildGroup)this.children.get(233);
        if (childGroup.size() > 0) {
            return (PackageSource)childGroup.get(0);
        }
        return null;
    }

    public void setPackageSource(PackageSource value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            PackageSource obj = this.getPackageSource();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public SecurityFixContentInfo getOptSecurityFixContentInfo() {
        ChildGroup childGroup = (ChildGroup)this.children.get(736);
        if (childGroup.size() > 0) {
            return (SecurityFixContentInfo)childGroup.get(0);
        }
        return null;
    }

    public void setOptSecurityFixContentInfo(SecurityFixContentInfo value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            SecurityFixContentInfo obj = this.getOptSecurityFixContentInfo();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public DeploymentSchedule getOptDeploymentSchedule() {
        ChildGroup childGroup = (ChildGroup)this.children.get(234);
        if (childGroup.size() > 0) {
            return (DeploymentSchedule)childGroup.get(0);
        }
        return null;
    }

    public void setOptDeploymentSchedule(DeploymentSchedule value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            DeploymentSchedule obj = this.getOptDeploymentSchedule();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public DeploymentNotification getOptDeploymentNotification() {
        ChildGroup childGroup = (ChildGroup)this.children.get(235);
        if (childGroup.size() > 0) {
            return (DeploymentNotification)childGroup.get(0);
        }
        return null;
    }

    public void setOptDeploymentNotification(DeploymentNotification value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            DeploymentNotification obj = this.getOptDeploymentNotification();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public DeploymentSnooze getOptDeploymentSnooze() {
        ChildGroup childGroup = (ChildGroup)this.children.get(237);
        if (childGroup.size() > 0) {
            return (DeploymentSnooze)childGroup.get(0);
        }
        return null;
    }

    public void setOptDeploymentSnooze(DeploymentSnooze value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            DeploymentSnooze obj = this.getOptDeploymentSnooze();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public AutoUpgradeContentOption getOptAutoUpgradeContentOption() {
        ChildGroup childGroup = (ChildGroup)this.children.get(238);
        if (childGroup.size() > 0) {
            return (AutoUpgradeContentOption)childGroup.get(0);
        }
        return null;
    }

    public void setOptAutoUpgradeContentOption(AutoUpgradeContentOption value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            AutoUpgradeContentOption obj = this.getOptAutoUpgradeContentOption();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 232;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.creationTime == null) {
            throw new ValidationException("SoftwareDeploymentEntity/CreationTime: attribute is required!");
        }
        if (this.getObjReferenceCount() < 1) {
            throw new ValidationException("SoftwareDeploymentEntity/ObjReference: attribute is required!");
        }
        if (this.getPackageSource() == null) {
            throw new ValidationException("SoftwareDeploymentEntity/PackageSource: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof ObjReference) {
            try {
                this.addObjReference((ObjReference)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof PackageSource) {
            try {
                this.setPackageSource((PackageSource)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof SecurityFixContentInfo) {
            try {
                this.setOptSecurityFixContentInfo((SecurityFixContentInfo)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof DeploymentSchedule) {
            try {
                this.setOptDeploymentSchedule((DeploymentSchedule)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof DeploymentNotification) {
            try {
                this.setOptDeploymentNotification((DeploymentNotification)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof DeploymentSnooze) {
            try {
                this.setOptDeploymentSnooze((DeploymentSnooze)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof AutoUpgradeContentOption) {
            try {
                this.setOptAutoUpgradeContentOption((AutoUpgradeContentOption)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("ForceDeployment")) != null) {
                this.forceDeployment = "1".equals(value);
            }
            if ((value = attris.getValue("AutoUpgradeToEnglish")) != null) {
                this.autoUpgradeToEnglish = "1".equals(value);
            }
            if ((value = attris.getValue("CreationTime")) == null) {
                throw new ValidationException("SoftwareDeploymentEntity/CreationTime: attribute is required!");
            }
            try {
                this.creationTime = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("SoftwareDeploymentEntity/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("SoftwareDeploymentEntity/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getObjReferenceCount();
        for (i = 0; i < objCnt; ++i) {
            this.getObjReference(i).setReadonly();
        }
        if (this.getPackageSource() != null) {
            this.getPackageSource().setReadonly();
        }
        if (this.getOptSecurityFixContentInfo() != null) {
            this.getOptSecurityFixContentInfo().setReadonly();
        }
        if (this.getOptDeploymentSchedule() != null) {
            this.getOptDeploymentSchedule().setReadonly();
        }
        if (this.getOptDeploymentNotification() != null) {
            this.getOptDeploymentNotification().setReadonly();
        }
        if (this.getOptDeploymentSnooze() != null) {
            this.getOptDeploymentSnooze().setReadonly();
        }
        if (this.getOptAutoUpgradeContentOption() != null) {
            this.getOptAutoUpgradeContentOption().setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(3)).size();
        }
        catch (Throwable t) {
            throw new SAXException("SoftwareDeploymentEntity: can't import element == ObjReference!");
        }
        try {
            ((ChildGroup)this.children.get(233)).size();
        }
        catch (Throwable t) {
            throw new SAXException("SoftwareDeploymentEntity: can't import element == PackageSource!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"SoftwareDeploymentEntity".equals(element.getNodeName())) {
            throw new ValidationException("SoftwareDeploymentEntity: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ForceDeployment")) != null) {
            this.forceDeployment = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AutoUpgradeToEnglish")) != null) {
            this.autoUpgradeToEnglish = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "CreationTime")) == null) {
            throw new ValidationException("SoftwareDeploymentEntity/CreationTime: attribute is required!");
        }
        try {
            this.creationTime = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("SoftwareDeploymentEntity/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("SoftwareDeploymentEntity/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "ObjReference");
        if (v.size() < 1) {
            throw new ValidationException("SoftwareDeploymentEntity/ObjReference: element is require!");
        }
        for (int i = 0; i < v.size(); ++i) {
            ObjReference objReferenceObj = new ObjReference();
            objReferenceObj.importFromElement(v.get(i));
            this.addObjReference(objReferenceObj);
        }
        v = XMLHelper.getChildElementByName(element, "PackageSource");
        if (v.size() != 1) {
            throw new ValidationException("SoftwareDeploymentEntity/PackageSource: element is require!");
        }
        PackageSource packageSourceObj = new PackageSource();
        packageSourceObj.importFromElement(v.get(0));
        this.setPackageSource(packageSourceObj);
        v = XMLHelper.getChildElementByName(element, "SecurityFixContentInfo");
        if (v.size() > 0) {
            SecurityFixContentInfo securityFixContentInfoObj = new SecurityFixContentInfo();
            securityFixContentInfoObj.importFromElement(v.get(0));
            this.setOptSecurityFixContentInfo(securityFixContentInfoObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "DeploymentSchedule")).size() > 0) {
            DeploymentSchedule deploymentScheduleObj = new DeploymentSchedule();
            deploymentScheduleObj.importFromElement(v.get(0));
            this.setOptDeploymentSchedule(deploymentScheduleObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "DeploymentNotification")).size() > 0) {
            DeploymentNotification deploymentNotificationObj = new DeploymentNotification();
            deploymentNotificationObj.importFromElement(v.get(0));
            this.setOptDeploymentNotification(deploymentNotificationObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "DeploymentSnooze")).size() > 0) {
            DeploymentSnooze deploymentSnoozeObj = new DeploymentSnooze();
            deploymentSnoozeObj.importFromElement(v.get(0));
            this.setOptDeploymentSnooze(deploymentSnoozeObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "AutoUpgradeContentOption")).size() > 0) {
            AutoUpgradeContentOption autoUpgradeContentOptionObj = new AutoUpgradeContentOption();
            autoUpgradeContentOptionObj.importFromElement(v.get(0));
            this.setOptAutoUpgradeContentOption(autoUpgradeContentOptionObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("SoftwareDeploymentEntity/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("SoftwareDeploymentEntity/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("SoftwareDeploymentEntity");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.forceDeployment != null) {
            element.setAttribute("ForceDeployment", this.forceDeployment != false ? "1" : "0");
        }
        if (this.autoUpgradeToEnglish != null) {
            element.setAttribute("AutoUpgradeToEnglish", this.autoUpgradeToEnglish != false ? "1" : "0");
        }
        if (this.creationTime != null) {
            element.setAttribute("CreationTime", this.creationTime.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SoftwareDeploymentEntity ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.forceDeployment != null) {
                strAttrs.append("ForceDeployment=").append(this.forceDeployment != false ? "\"1\" " : "\"0\" ");
            }
            if (this.autoUpgradeToEnglish != null) {
                strAttrs.append("AutoUpgradeToEnglish=").append(this.autoUpgradeToEnglish != false ? "\"1\" " : "\"0\" ");
            }
            if (this.creationTime != null) {
                strAttrs.append("CreationTime=\"").append(this.creationTime.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SoftwareDeploymentEntity>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

