/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SoTime
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Boolean include;
    private String startDate;
    private String startDayOfWeek;
    private String startTime;
    private Integer timeLast;

    public SoTime() {
        this(true);
    }

    public SoTime(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "SoTime";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public Boolean getInclude() {
        return this.include;
    }

    public void setInclude(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.include = value;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.startDate = value;
    }

    public String getOptStartDayOfWeek() {
        return this.startDayOfWeek;
    }

    public void setOptStartDayOfWeek(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.startDayOfWeek = value;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.startTime = value;
    }

    public Integer getTimeLast() {
        return this.timeLast;
    }

    public void setTimeLast(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.timeLast = value;
    }

    @Override
    public int getObjectType() {
        return 307;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.include == null) {
            throw new ValidationException("SoTime/Include: attribute is required!");
        }
        if (this.startDate == null) {
            throw new ValidationException("SoTime/StartDate: attribute is required!");
        }
        if (this.startTime == null) {
            throw new ValidationException("SoTime/StartTime: attribute is required!");
        }
        if (this.timeLast == null) {
            throw new ValidationException("SoTime/TimeLast: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("Include")) == null) {
                throw new ValidationException("SoTime/Include: attribute is required!");
            }
            this.include = "1".equals(value);
            value = attris.getValue("StartDate");
            if (value == null) {
                throw new ValidationException("SoTime/StartDate: attribute is required!");
            }
            this.startDate = value;
            value = attris.getValue("StartDayOfWeek");
            if (value != null) {
                this.startDayOfWeek = value;
            }
            if ((value = attris.getValue("StartTime")) == null) {
                throw new ValidationException("SoTime/StartTime: attribute is required!");
            }
            this.startTime = value;
            value = attris.getValue("TimeLast");
            if (value == null) {
                throw new ValidationException("SoTime/TimeLast: attribute is required!");
            }
            try {
                this.timeLast = Integer.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("SoTime/TimeLast: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("SoTime/TimeLast: invalid attribute value:" + value + "! " + e.getMessage());
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"SoTime".equals(element.getNodeName())) {
            throw new ValidationException("SoTime: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Include")) == null) {
            throw new ValidationException("SoTime/Include: attribute is required!");
        }
        this.include = "1".equals(value);
        value = XMLHelper.getAttribute(element, "StartDate");
        if (value == null) {
            throw new ValidationException("SoTime/StartDate: attribute is required!");
        }
        this.startDate = value;
        value = XMLHelper.getAttribute(element, "StartDayOfWeek");
        if (value != null) {
            this.startDayOfWeek = value;
        }
        if ((value = XMLHelper.getAttribute(element, "StartTime")) == null) {
            throw new ValidationException("SoTime/StartTime: attribute is required!");
        }
        this.startTime = value;
        value = XMLHelper.getAttribute(element, "TimeLast");
        if (value == null) {
            throw new ValidationException("SoTime/TimeLast: attribute is required!");
        }
        try {
            this.timeLast = Integer.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("SoTime/TimeLast: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("SoTime/TimeLast: invalid attribute value:" + value + "! " + e.getMessage());
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("SoTime/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("SoTime/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("SoTime");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.include != null) {
            element.setAttribute("Include", this.include != false ? "1" : "0");
        }
        if (this.startDate != null) {
            element.setAttribute("StartDate", this.startDate);
        }
        if (this.startDayOfWeek != null) {
            element.setAttribute("StartDayOfWeek", this.startDayOfWeek);
        }
        if (this.startTime != null) {
            element.setAttribute("StartTime", this.startTime);
        }
        if (this.timeLast != null) {
            element.setAttribute("TimeLast", this.timeLast.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SoTime ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.include != null) {
                strAttrs.append("Include=").append(this.include != false ? "\"1\" " : "\"0\" ");
            }
            if (this.startDate != null) {
                strAttrs.append("StartDate=\"").append(AbstractSchema.checkXMLContent(this.startDate)).append("\" ");
            }
            if (this.startDayOfWeek != null) {
                strAttrs.append("StartDayOfWeek=\"").append(AbstractSchema.checkXMLContent(this.startDayOfWeek)).append("\" ");
            }
            if (this.startTime != null) {
                strAttrs.append("StartTime=\"").append(AbstractSchema.checkXMLContent(this.startTime)).append("\" ");
            }
            if (this.timeLast != null) {
                strAttrs.append("TimeLast=\"").append(this.timeLast.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SoTime>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

