/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.util.Utility;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SharedInsightCache
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Boolean enabled;
    private Boolean enabledvSIC;
    private Boolean selectedvSIC;
    private Boolean requireSSL;
    private String hostName;
    private Integer port;
    private String username;
    private String password;

    public SharedInsightCache() {
        this(true);
    }

    public SharedInsightCache(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "SharedInsightCache";
    }

    public Boolean getDefEnabled() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnabled() {
        return this.enabled;
    }

    public void setOptEnabled(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enabled = value;
    }

    public Boolean getDefEnabledvSIC() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnabledvSIC() {
        return this.enabledvSIC;
    }

    public void setOptEnabledvSIC(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enabledvSIC = value;
    }

    public Boolean getDefSelectedvSIC() {
        return Boolean.FALSE;
    }

    public Boolean getOptSelectedvSIC() {
        return this.selectedvSIC;
    }

    public void setOptSelectedvSIC(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.selectedvSIC = value;
    }

    public Boolean getDefRequireSSL() {
        return Boolean.FALSE;
    }

    public Boolean getOptRequireSSL() {
        return this.requireSSL;
    }

    public void setOptRequireSSL(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.requireSSL = value;
    }

    public String getDefHostName() {
        return "";
    }

    public String getOptHostName() {
        return this.hostName;
    }

    public void setOptHostName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.hostName = value;
    }

    public Integer getDefPort() {
        return 9005;
    }

    public Integer getOptPort() {
        return this.port;
    }

    public void setOptPort(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.port = value;
    }

    public String getOptUsername() {
        return this.username;
    }

    public void setOptUsername(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.username = value;
    }

    public String getOptPassword() {
        try {
            return Utility.decrypt(this.password);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setOptPassword(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        try {
            this.password = Utility.encrypt(value);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getObjectType() {
        return 667;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enabled");
            if (value != null) {
                this.enabled = "1".equals(value);
            }
            if ((value = attris.getValue("EnabledvSIC")) != null) {
                this.enabledvSIC = "1".equals(value);
            }
            if ((value = attris.getValue("SelectedvSIC")) != null) {
                this.selectedvSIC = "1".equals(value);
            }
            if ((value = attris.getValue("RequireSSL")) != null) {
                this.requireSSL = "1".equals(value);
            }
            if ((value = attris.getValue("HostName")) != null) {
                this.hostName = value;
            }
            if ((value = attris.getValue("Port")) != null) {
                try {
                    this.port = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("SharedInsightCache/Port: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("SharedInsightCache/Port: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("Username")) != null) {
                this.username = value;
            }
            if ((value = attris.getValue("Password")) != null) {
                this.password = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"SharedInsightCache".equals(element.getNodeName())) {
            throw new ValidationException("SharedInsightCache: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enabled");
        if (value != null) {
            this.enabled = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "EnabledvSIC")) != null) {
            this.enabledvSIC = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "SelectedvSIC")) != null) {
            this.selectedvSIC = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "RequireSSL")) != null) {
            this.requireSSL = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "HostName")) != null) {
            this.hostName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Port")) != null) {
            try {
                this.port = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("SharedInsightCache/Port: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "Username")) != null) {
            this.username = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Password")) != null) {
            this.password = value;
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("SharedInsightCache/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("SharedInsightCache/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("SharedInsightCache");
        if (this.enabled != null) {
            element.setAttribute("Enabled", this.enabled != false ? "1" : "0");
        }
        if (this.enabledvSIC != null) {
            element.setAttribute("EnabledvSIC", this.enabledvSIC != false ? "1" : "0");
        }
        if (this.selectedvSIC != null) {
            element.setAttribute("SelectedvSIC", this.selectedvSIC != false ? "1" : "0");
        }
        if (this.requireSSL != null) {
            element.setAttribute("RequireSSL", this.requireSSL != false ? "1" : "0");
        }
        if (this.hostName != null) {
            element.setAttribute("HostName", this.hostName);
        }
        if (this.port != null) {
            element.setAttribute("Port", this.port.toString());
        }
        if (this.username != null) {
            element.setAttribute("Username", this.username);
        }
        if (this.password != null) {
            element.setAttribute("Password", this.password);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SharedInsightCache ");
            if (this.enabled != null) {
                strAttrs.append("Enabled=").append(this.enabled != false ? "\"1\" " : "\"0\" ");
            }
            if (this.enabledvSIC != null) {
                strAttrs.append("EnabledvSIC=").append(this.enabledvSIC != false ? "\"1\" " : "\"0\" ");
            }
            if (this.selectedvSIC != null) {
                strAttrs.append("SelectedvSIC=").append(this.selectedvSIC != false ? "\"1\" " : "\"0\" ");
            }
            if (this.requireSSL != null) {
                strAttrs.append("RequireSSL=").append(this.requireSSL != false ? "\"1\" " : "\"0\" ");
            }
            if (this.hostName != null) {
                strAttrs.append("HostName=\"").append(AbstractSchema.checkXMLContent(this.hostName)).append("\" ");
            }
            if (this.port != null) {
                strAttrs.append("Port=\"").append(this.port.toString()).append("\" ");
            }
            if (this.username != null) {
                strAttrs.append("Username=\"").append(AbstractSchema.checkXMLContent(this.username)).append("\" ");
            }
            if (this.password != null) {
                strAttrs.append("Password=\"").append(AbstractSchema.checkXMLContent(this.password)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SharedInsightCache>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

