/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.SemServerBlock;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SemServerList
extends TopLevelObject
implements NamedObject {
    public static final Integer ANY = 0;
    public static final Integer HTTPS_ONLY = 1;
    public static final Integer HTTP_ONLY = 2;
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String description;
    private String refId;
    private Long objAttributes;
    private Integer commSecurity;
    private Boolean verifyHttpsUrlName;

    public SemServerList() {
        this(true);
    }

    public SemServerList(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(230, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "SemServerList";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.id = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.name = value;
    }

    @Override
    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.description = value;
    }

    @Override
    public String getOptRefId() {
        return this.refId;
    }

    public void setOptRefId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.refId = value;
    }

    public Long getDefObjAttributes() {
        return 0L;
    }

    public Long getOptObjAttributes() {
        return this.objAttributes;
    }

    public void setOptObjAttributes(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.objAttributes = value;
    }

    public Integer getOptCommSecurity() {
        return this.commSecurity;
    }

    public String getOptCommSecurityValue() throws ValidationException {
        if (this.commSecurity == null) {
            return null;
        }
        String s = null;
        switch (this.commSecurity) {
            case 0: {
                s = "ANY";
                break;
            }
            case 1: {
                s = "HTTPS_ONLY";
                break;
            }
            case 2: {
                s = "HTTP_ONLY";
                break;
            }
            default: {
                throw new ValidationException("SemServerList/CommSecurity: invalid attribute value:" + this.commSecurity + "!");
            }
        }
        return s;
    }

    public void setOptCommSecurity(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.commSecurity = value;
    }

    public void setOptCommSecurityValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.commSecurity = null;
            return;
        }
        if ("ANY".equals(value)) {
            this.commSecurity = ANY;
        } else if ("HTTPS_ONLY".equals(value)) {
            this.commSecurity = HTTPS_ONLY;
        } else if ("HTTP_ONLY".equals(value)) {
            this.commSecurity = HTTP_ONLY;
        } else {
            throw new ValidationException("SemServerList/CommSecurity: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefVerifyHttpsUrlName() {
        return Boolean.FALSE;
    }

    public Boolean getOptVerifyHttpsUrlName() {
        return this.verifyHttpsUrlName;
    }

    public void setOptVerifyHttpsUrlName(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.verifyHttpsUrlName = value;
    }

    public void addSemServerBlock(SemServerBlock value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addSemServerBlock(int index, SemServerBlock value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<SemServerBlock> getSemServerBlock() {
        Vector<SemServerBlock> v = new Vector<SemServerBlock>();
        for (Transportable child : (ChildGroup)this.children.get(230)) {
            v.add((SemServerBlock)child);
        }
        return v;
    }

    public int getSemServerBlockCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(230);
        return childGroup.size();
    }

    public SemServerBlock getSemServerBlock(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(230);
        return (SemServerBlock)childGroup.get(index);
    }

    public void setSemServerBlock(int index, SemServerBlock value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeSemServerBlock(SemServerBlock value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 229;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.id == null) {
            throw new ValidationException("SemServerList/Id: attribute is required!");
        }
        if (this.name == null) {
            throw new ValidationException("SemServerList/Name: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof SemServerBlock) {
            try {
                this.addSemServerBlock((SemServerBlock)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Id");
            if (value == null) {
                throw new ValidationException("SemServerList/Id: attribute is required!");
            }
            this.id = value;
            value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("SemServerList/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Description");
            if (value != null) {
                this.description = value;
            }
            if ((value = attris.getValue("RefId")) != null) {
                this.refId = value;
            }
            if ((value = attris.getValue("ObjAttributes")) != null) {
                try {
                    this.objAttributes = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("SemServerList/ObjAttributes: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("SemServerList/ObjAttributes: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("CommSecurity")) != null) {
                this.setOptCommSecurityValue(value);
            }
            if ((value = attris.getValue("VerifyHttpsUrlName")) != null) {
                this.verifyHttpsUrlName = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getSemServerBlockCount();
        for (i = 0; i < objCnt; ++i) {
            this.getSemServerBlock(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"SemServerList".equals(element.getNodeName())) {
            throw new ValidationException("SemServerList: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Id");
        if (value == null) {
            throw new ValidationException("SemServerList/Id: attribute is required!");
        }
        this.id = value;
        value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("SemServerList/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Description");
        if (value != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RefId")) != null) {
            this.refId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ObjAttributes")) != null) {
            try {
                this.objAttributes = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("SemServerList/ObjAttributes: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "CommSecurity")) != null) {
            this.setOptCommSecurityValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "VerifyHttpsUrlName")) != null) {
            this.verifyHttpsUrlName = "1".equals(value);
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "SemServerBlock");
        for (int i = 0; i < v.size(); ++i) {
            SemServerBlock semServerBlockObj = new SemServerBlock();
            semServerBlockObj.importFromElement(v.get(i));
            this.addSemServerBlock(semServerBlockObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("SemServerList/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("SemServerList/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("SemServerList");
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.refId != null) {
            element.setAttribute("RefId", this.refId);
        }
        if (this.objAttributes != null) {
            element.setAttribute("ObjAttributes", this.objAttributes.toString());
        }
        if (this.commSecurity != null) {
            element.setAttribute("CommSecurity", this.getOptCommSecurityValue());
        }
        if (this.verifyHttpsUrlName != null) {
            element.setAttribute("VerifyHttpsUrlName", this.verifyHttpsUrlName != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SemServerList ");
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.refId != null) {
                strAttrs.append("RefId=\"").append(AbstractSchema.checkXMLContent(this.refId)).append("\" ");
            }
            if (this.objAttributes != null) {
                strAttrs.append("ObjAttributes=\"").append(this.objAttributes.toString()).append("\" ");
            }
            if (this.commSecurity != null) {
                strAttrs.append("CommSecurity=\"").append(this.getOptCommSecurityValue()).append("\" ");
            }
            if (this.verifyHttpsUrlName != null) {
                strAttrs.append("VerifyHttpsUrlName=").append(this.verifyHttpsUrlName != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SemServerList>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

