/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.DatabaseUpdateHistory;
import com.sygate.scm.common.configobject.schema.ReplicationUser;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SemLocalSettings
extends TopLevelObject {
    private static final long serialVersionUID = 1L;
    private String id;
    private String siteId;
    private String physicalDatabaseInstanceId;
    private Long baseUSN;
    private String databaseSchemaVersion;
    private Boolean releaseVersion;
    private String serverVersion;

    public SemLocalSettings() {
        this(true);
    }

    public SemLocalSettings(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(302, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(301, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "SemLocalSettings";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.id = value;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public void setSiteId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.siteId = value;
    }

    public String getPhysicalDatabaseInstanceId() {
        return this.physicalDatabaseInstanceId;
    }

    public void setPhysicalDatabaseInstanceId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.physicalDatabaseInstanceId = value;
    }

    public Long getBaseUSN() {
        return this.baseUSN;
    }

    public void setBaseUSN(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.baseUSN = value;
    }

    public String getOptDatabaseSchemaVersion() {
        return this.databaseSchemaVersion;
    }

    public void setOptDatabaseSchemaVersion(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.databaseSchemaVersion = value;
    }

    public Boolean getDefReleaseVersion() {
        return Boolean.TRUE;
    }

    public Boolean getOptReleaseVersion() {
        return this.releaseVersion;
    }

    public void setOptReleaseVersion(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.releaseVersion = value;
    }

    public String getOptServerVersion() {
        return this.serverVersion;
    }

    public void setOptServerVersion(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.serverVersion = value;
    }

    public void addDatabaseUpdateHistory(DatabaseUpdateHistory value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addDatabaseUpdateHistory(int index, DatabaseUpdateHistory value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<DatabaseUpdateHistory> getDatabaseUpdateHistory() {
        Vector<DatabaseUpdateHistory> v = new Vector<DatabaseUpdateHistory>();
        for (Transportable child : (ChildGroup)this.children.get(302)) {
            v.add((DatabaseUpdateHistory)child);
        }
        return v;
    }

    public int getDatabaseUpdateHistoryCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(302);
        return childGroup.size();
    }

    public DatabaseUpdateHistory getDatabaseUpdateHistory(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(302);
        return (DatabaseUpdateHistory)childGroup.get(index);
    }

    public void setDatabaseUpdateHistory(int index, DatabaseUpdateHistory value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeDatabaseUpdateHistory(DatabaseUpdateHistory value) {
        this.removeChild(value);
    }

    public ReplicationUser getOptReplicationUser() {
        ChildGroup childGroup = (ChildGroup)this.children.get(301);
        if (childGroup.size() > 0) {
            return (ReplicationUser)childGroup.get(0);
        }
        return null;
    }

    public void setOptReplicationUser(ReplicationUser value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ReplicationUser obj = this.getOptReplicationUser();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 300;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.id == null) {
            throw new ValidationException("SemLocalSettings/Id: attribute is required!");
        }
        if (this.siteId == null) {
            throw new ValidationException("SemLocalSettings/SiteId: attribute is required!");
        }
        if (this.physicalDatabaseInstanceId == null) {
            throw new ValidationException("SemLocalSettings/PhysicalDatabaseInstanceId: attribute is required!");
        }
        if (this.baseUSN == null) {
            throw new ValidationException("SemLocalSettings/BaseUSN: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof DatabaseUpdateHistory) {
            try {
                this.addDatabaseUpdateHistory((DatabaseUpdateHistory)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof ReplicationUser) {
            try {
                this.setOptReplicationUser((ReplicationUser)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Id");
            if (value == null) {
                throw new ValidationException("SemLocalSettings/Id: attribute is required!");
            }
            this.id = value;
            value = attris.getValue("SiteId");
            if (value == null) {
                throw new ValidationException("SemLocalSettings/SiteId: attribute is required!");
            }
            this.siteId = value;
            value = attris.getValue("PhysicalDatabaseInstanceId");
            if (value == null) {
                throw new ValidationException("SemLocalSettings/PhysicalDatabaseInstanceId: attribute is required!");
            }
            this.physicalDatabaseInstanceId = value;
            value = attris.getValue("BaseUSN");
            if (value == null) {
                throw new ValidationException("SemLocalSettings/BaseUSN: attribute is required!");
            }
            try {
                this.baseUSN = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("SemLocalSettings/BaseUSN: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("SemLocalSettings/BaseUSN: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("DatabaseSchemaVersion");
            if (value != null) {
                this.databaseSchemaVersion = value;
            }
            if ((value = attris.getValue("ReleaseVersion")) != null) {
                this.releaseVersion = "1".equals(value);
            }
            if ((value = attris.getValue("ServerVersion")) != null) {
                this.serverVersion = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getDatabaseUpdateHistoryCount();
        for (i = 0; i < objCnt; ++i) {
            this.getDatabaseUpdateHistory(i).setReadonly();
        }
        if (this.getOptReplicationUser() != null) {
            this.getOptReplicationUser().setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"SemLocalSettings".equals(element.getNodeName())) {
            throw new ValidationException("SemLocalSettings: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Id");
        if (value == null) {
            throw new ValidationException("SemLocalSettings/Id: attribute is required!");
        }
        this.id = value;
        value = XMLHelper.getAttribute(element, "SiteId");
        if (value == null) {
            throw new ValidationException("SemLocalSettings/SiteId: attribute is required!");
        }
        this.siteId = value;
        value = XMLHelper.getAttribute(element, "PhysicalDatabaseInstanceId");
        if (value == null) {
            throw new ValidationException("SemLocalSettings/PhysicalDatabaseInstanceId: attribute is required!");
        }
        this.physicalDatabaseInstanceId = value;
        value = XMLHelper.getAttribute(element, "BaseUSN");
        if (value == null) {
            throw new ValidationException("SemLocalSettings/BaseUSN: attribute is required!");
        }
        try {
            this.baseUSN = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("SemLocalSettings/BaseUSN: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("SemLocalSettings/BaseUSN: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "DatabaseSchemaVersion");
        if (value != null) {
            this.databaseSchemaVersion = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ReleaseVersion")) != null) {
            this.releaseVersion = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ServerVersion")) != null) {
            this.serverVersion = value;
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "DatabaseUpdateHistory");
        for (int i = 0; i < v.size(); ++i) {
            DatabaseUpdateHistory databaseUpdateHistoryObj = new DatabaseUpdateHistory();
            databaseUpdateHistoryObj.importFromElement(v.get(i));
            this.addDatabaseUpdateHistory(databaseUpdateHistoryObj);
        }
        v = XMLHelper.getChildElementByName(element, "ReplicationUser");
        if (v.size() > 0) {
            ReplicationUser replicationUserObj = new ReplicationUser();
            replicationUserObj.importFromElement(v.get(0));
            this.setOptReplicationUser(replicationUserObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("SemLocalSettings/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("SemLocalSettings/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("SemLocalSettings");
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.siteId != null) {
            element.setAttribute("SiteId", this.siteId);
        }
        if (this.physicalDatabaseInstanceId != null) {
            element.setAttribute("PhysicalDatabaseInstanceId", this.physicalDatabaseInstanceId);
        }
        if (this.baseUSN != null) {
            element.setAttribute("BaseUSN", this.baseUSN.toString());
        }
        if (this.databaseSchemaVersion != null) {
            element.setAttribute("DatabaseSchemaVersion", this.databaseSchemaVersion);
        }
        if (this.releaseVersion != null) {
            element.setAttribute("ReleaseVersion", this.releaseVersion != false ? "1" : "0");
        }
        if (this.serverVersion != null) {
            element.setAttribute("ServerVersion", this.serverVersion);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SemLocalSettings ");
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.siteId != null) {
                strAttrs.append("SiteId=\"").append(AbstractSchema.checkXMLContent(this.siteId)).append("\" ");
            }
            if (this.physicalDatabaseInstanceId != null) {
                strAttrs.append("PhysicalDatabaseInstanceId=\"").append(AbstractSchema.checkXMLContent(this.physicalDatabaseInstanceId)).append("\" ");
            }
            if (this.baseUSN != null) {
                strAttrs.append("BaseUSN=\"").append(this.baseUSN.toString()).append("\" ");
            }
            if (this.databaseSchemaVersion != null) {
                strAttrs.append("DatabaseSchemaVersion=\"").append(AbstractSchema.checkXMLContent(this.databaseSchemaVersion)).append("\" ");
            }
            if (this.releaseVersion != null) {
                strAttrs.append("ReleaseVersion=").append(this.releaseVersion != false ? "\"1\" " : "\"0\" ");
            }
            if (this.serverVersion != null) {
                strAttrs.append("ServerVersion=\"").append(AbstractSchema.checkXMLContent(this.serverVersion)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SemLocalSettings>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

