/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.ObjReference;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SemClientGroup
extends ConfigObject
implements NamedObject {
    public static final Integer NATIVE = 0;
    public static final Integer ADTREE = 1;
    public static final Integer ADNODE = 2;
    public static final Integer TEMPORARY = 3;
    public static final Integer CLOUDNODE = 4;
    private static final long serialVersionUID = 1L;
    private Integer type;
    private String creator;
    private Long creationTime;
    private Long modifiedTime;
    private String aDsPath;
    private String directoryServerRefId;
    private String distinguishedName;
    private String id;
    private String name;
    private String description;
    private String refId;
    private Boolean blockNewClient;
    private Boolean disableAutoUpgrade;
    private Boolean migrated;
    private String extReferenceId;

    public SemClientGroup() {
        this(true);
    }

    public SemClientGroup(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(174, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(3, new ChildGroup(1, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "SemClientGroup";
    }

    public Integer getDefType() {
        return NATIVE;
    }

    public Integer getOptType() {
        return this.type;
    }

    public String getOptTypeValue() throws ValidationException {
        if (this.type == null) {
            return null;
        }
        String s = null;
        switch (this.type) {
            case 0: {
                s = "NATIVE";
                break;
            }
            case 1: {
                s = "ADTREE";
                break;
            }
            case 2: {
                s = "ADNODE";
                break;
            }
            case 3: {
                s = "TEMPORARY";
                break;
            }
            case 4: {
                s = "CLOUDNODE";
                break;
            }
            default: {
                throw new ValidationException("SemClientGroup/Type: invalid attribute value:" + this.type + "!");
            }
        }
        return s;
    }

    public void setOptType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.type = value;
    }

    public void setOptTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.type = null;
            return;
        }
        if ("NATIVE".equals(value)) {
            this.type = NATIVE;
        } else if ("ADTREE".equals(value)) {
            this.type = ADTREE;
        } else if ("ADNODE".equals(value)) {
            this.type = ADNODE;
        } else if ("TEMPORARY".equals(value)) {
            this.type = TEMPORARY;
        } else if ("CLOUDNODE".equals(value)) {
            this.type = CLOUDNODE;
        } else {
            throw new ValidationException("SemClientGroup/Type: invalid attribute value:" + value + "!");
        }
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.creator = value;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.creationTime = value;
    }

    public Long getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.modifiedTime = value;
    }

    public String getOptADsPath() {
        return this.aDsPath;
    }

    public void setOptADsPath(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.aDsPath = value;
    }

    public String getOptDirectoryServerRefId() {
        return this.directoryServerRefId;
    }

    public void setOptDirectoryServerRefId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.directoryServerRefId = value;
    }

    public String getOptDistinguishedName() {
        return this.distinguishedName;
    }

    public void setOptDistinguishedName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.distinguishedName = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.id = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.name = value;
    }

    @Override
    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.description = value;
    }

    @Override
    public String getOptRefId() {
        return this.refId;
    }

    public void setOptRefId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.refId = value;
    }

    public Boolean getDefBlockNewClient() {
        return Boolean.FALSE;
    }

    public Boolean getOptBlockNewClient() {
        return this.blockNewClient;
    }

    public void setOptBlockNewClient(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.blockNewClient = value;
    }

    public Boolean getDefDisableAutoUpgrade() {
        return Boolean.FALSE;
    }

    public Boolean getOptDisableAutoUpgrade() {
        return this.disableAutoUpgrade;
    }

    public void setOptDisableAutoUpgrade(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.disableAutoUpgrade = value;
    }

    public Boolean getDefMigrated() {
        return Boolean.FALSE;
    }

    public Boolean getOptMigrated() {
        return this.migrated;
    }

    public void setOptMigrated(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.migrated = value;
    }

    public String getOptExtReferenceId() {
        return this.extReferenceId;
    }

    public void setOptExtReferenceId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.extReferenceId = value;
    }

    public void addSemClientGroup(SemClientGroup value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addSemClientGroup(int index, SemClientGroup value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<SemClientGroup> getSemClientGroup() {
        Vector<SemClientGroup> v = new Vector<SemClientGroup>();
        for (Transportable child : (ChildGroup)this.children.get(174)) {
            v.add((SemClientGroup)child);
        }
        return v;
    }

    public int getSemClientGroupCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(174);
        return childGroup.size();
    }

    public SemClientGroup getSemClientGroup(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(174);
        return (SemClientGroup)childGroup.get(index);
    }

    public void setSemClientGroup(int index, SemClientGroup value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeSemClientGroup(SemClientGroup value) {
        this.removeChild(value);
    }

    public ObjReference getObjReference() {
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        if (childGroup.size() > 0) {
            return (ObjReference)childGroup.get(0);
        }
        return null;
    }

    public void setObjReference(ObjReference value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ObjReference obj = this.getObjReference();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 174;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.creator == null) {
            throw new ValidationException("SemClientGroup/Creator: attribute is required!");
        }
        if (this.creationTime == null) {
            throw new ValidationException("SemClientGroup/CreationTime: attribute is required!");
        }
        if (this.modifiedTime == null) {
            throw new ValidationException("SemClientGroup/ModifiedTime: attribute is required!");
        }
        if (this.id == null) {
            throw new ValidationException("SemClientGroup/Id: attribute is required!");
        }
        if (this.name == null) {
            throw new ValidationException("SemClientGroup/Name: attribute is required!");
        }
        if (this.getObjReference() == null) {
            throw new ValidationException("SemClientGroup/ObjReference: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof SemClientGroup) {
            try {
                this.addSemClientGroup((SemClientGroup)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof ObjReference) {
            try {
                this.setObjReference((ObjReference)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Type");
            if (value != null) {
                this.setOptTypeValue(value);
            }
            if ((value = attris.getValue("Creator")) == null) {
                throw new ValidationException("SemClientGroup/Creator: attribute is required!");
            }
            this.creator = value;
            value = attris.getValue("CreationTime");
            if (value == null) {
                throw new ValidationException("SemClientGroup/CreationTime: attribute is required!");
            }
            try {
                this.creationTime = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("SemClientGroup/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("SemClientGroup/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("ModifiedTime");
            if (value == null) {
                throw new ValidationException("SemClientGroup/ModifiedTime: attribute is required!");
            }
            try {
                this.modifiedTime = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("SemClientGroup/ModifiedTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("SemClientGroup/ModifiedTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("ADsPath");
            if (value != null) {
                this.aDsPath = value;
            }
            if ((value = attris.getValue("DirectoryServerRefId")) != null) {
                this.directoryServerRefId = value;
            }
            if ((value = attris.getValue("DistinguishedName")) != null) {
                this.distinguishedName = value;
            }
            if ((value = attris.getValue("Id")) == null) {
                throw new ValidationException("SemClientGroup/Id: attribute is required!");
            }
            this.id = value;
            value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("SemClientGroup/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Description");
            if (value != null) {
                this.description = value;
            }
            if ((value = attris.getValue("RefId")) != null) {
                this.refId = value;
            }
            if ((value = attris.getValue("BlockNewClient")) != null) {
                this.blockNewClient = "1".equals(value);
            }
            if ((value = attris.getValue("DisableAutoUpgrade")) != null) {
                this.disableAutoUpgrade = "1".equals(value);
            }
            if ((value = attris.getValue("Migrated")) != null) {
                this.migrated = "1".equals(value);
            }
            if ((value = attris.getValue("ExtReferenceId")) != null) {
                this.extReferenceId = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getSemClientGroupCount();
        for (i = 0; i < objCnt; ++i) {
            this.getSemClientGroup(i).setReadonly();
        }
        if (this.getObjReference() != null) {
            this.getObjReference().setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(3)).size();
        }
        catch (Throwable t) {
            throw new SAXException("SemClientGroup: can't import element == ObjReference!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"SemClientGroup".equals(element.getNodeName())) {
            throw new ValidationException("SemClientGroup: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Type");
        if (value != null) {
            this.setOptTypeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Creator")) == null) {
            throw new ValidationException("SemClientGroup/Creator: attribute is required!");
        }
        this.creator = value;
        value = XMLHelper.getAttribute(element, "CreationTime");
        if (value == null) {
            throw new ValidationException("SemClientGroup/CreationTime: attribute is required!");
        }
        try {
            this.creationTime = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("SemClientGroup/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("SemClientGroup/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "ModifiedTime");
        if (value == null) {
            throw new ValidationException("SemClientGroup/ModifiedTime: attribute is required!");
        }
        try {
            this.modifiedTime = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("SemClientGroup/ModifiedTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("SemClientGroup/ModifiedTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "ADsPath");
        if (value != null) {
            this.aDsPath = value;
        }
        if ((value = XMLHelper.getAttribute(element, "DirectoryServerRefId")) != null) {
            this.directoryServerRefId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "DistinguishedName")) != null) {
            this.distinguishedName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Id")) == null) {
            throw new ValidationException("SemClientGroup/Id: attribute is required!");
        }
        this.id = value;
        value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("SemClientGroup/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Description");
        if (value != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RefId")) != null) {
            this.refId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "BlockNewClient")) != null) {
            this.blockNewClient = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "DisableAutoUpgrade")) != null) {
            this.disableAutoUpgrade = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Migrated")) != null) {
            this.migrated = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ExtReferenceId")) != null) {
            this.extReferenceId = value;
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "SemClientGroup");
        for (int i = 0; i < v.size(); ++i) {
            SemClientGroup semClientGroupObj = new SemClientGroup();
            semClientGroupObj.importFromElement(v.get(i));
            this.addSemClientGroup(semClientGroupObj);
        }
        v = XMLHelper.getChildElementByName(element, "ObjReference");
        if (v.size() != 1) {
            throw new ValidationException("SemClientGroup/ObjReference: element is require!");
        }
        ObjReference objReferenceObj = new ObjReference();
        objReferenceObj.importFromElement(v.get(0));
        this.setObjReference(objReferenceObj);
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("SemClientGroup/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("SemClientGroup/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("SemClientGroup");
        if (this.type != null) {
            element.setAttribute("Type", this.getOptTypeValue());
        }
        if (this.creator != null) {
            element.setAttribute("Creator", this.creator);
        }
        if (this.creationTime != null) {
            element.setAttribute("CreationTime", this.creationTime.toString());
        }
        if (this.modifiedTime != null) {
            element.setAttribute("ModifiedTime", this.modifiedTime.toString());
        }
        if (this.aDsPath != null) {
            element.setAttribute("ADsPath", this.aDsPath);
        }
        if (this.directoryServerRefId != null) {
            element.setAttribute("DirectoryServerRefId", this.directoryServerRefId);
        }
        if (this.distinguishedName != null) {
            element.setAttribute("DistinguishedName", this.distinguishedName);
        }
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.refId != null) {
            element.setAttribute("RefId", this.refId);
        }
        if (this.blockNewClient != null) {
            element.setAttribute("BlockNewClient", this.blockNewClient != false ? "1" : "0");
        }
        if (this.disableAutoUpgrade != null) {
            element.setAttribute("DisableAutoUpgrade", this.disableAutoUpgrade != false ? "1" : "0");
        }
        if (this.migrated != null) {
            element.setAttribute("Migrated", this.migrated != false ? "1" : "0");
        }
        if (this.extReferenceId != null) {
            element.setAttribute("ExtReferenceId", this.extReferenceId);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SemClientGroup ");
            if (this.type != null) {
                strAttrs.append("Type=\"").append(this.getOptTypeValue()).append("\" ");
            }
            if (this.creator != null) {
                strAttrs.append("Creator=\"").append(AbstractSchema.checkXMLContent(this.creator)).append("\" ");
            }
            if (this.creationTime != null) {
                strAttrs.append("CreationTime=\"").append(this.creationTime.toString()).append("\" ");
            }
            if (this.modifiedTime != null) {
                strAttrs.append("ModifiedTime=\"").append(this.modifiedTime.toString()).append("\" ");
            }
            if (this.aDsPath != null) {
                strAttrs.append("ADsPath=\"").append(AbstractSchema.checkXMLContent(this.aDsPath)).append("\" ");
            }
            if (this.directoryServerRefId != null) {
                strAttrs.append("DirectoryServerRefId=\"").append(AbstractSchema.checkXMLContent(this.directoryServerRefId)).append("\" ");
            }
            if (this.distinguishedName != null) {
                strAttrs.append("DistinguishedName=\"").append(AbstractSchema.checkXMLContent(this.distinguishedName)).append("\" ");
            }
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.refId != null) {
                strAttrs.append("RefId=\"").append(AbstractSchema.checkXMLContent(this.refId)).append("\" ");
            }
            if (this.blockNewClient != null) {
                strAttrs.append("BlockNewClient=").append(this.blockNewClient != false ? "\"1\" " : "\"0\" ");
            }
            if (this.disableAutoUpgrade != null) {
                strAttrs.append("DisableAutoUpgrade=").append(this.disableAutoUpgrade != false ? "\"1\" " : "\"0\" ");
            }
            if (this.migrated != null) {
                strAttrs.append("Migrated=").append(this.migrated != false ? "\"1\" " : "\"0\" ");
            }
            if (this.extReferenceId != null) {
                strAttrs.append("ExtReferenceId=\"").append(AbstractSchema.checkXMLContent(this.extReferenceId)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SemClientGroup>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

