/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.AdminPayload;
import com.sygate.scm.common.configobject.schema.AdminPreference;
import com.sygate.scm.common.configobject.schema.DirectoryAuthentication;
import com.sygate.scm.common.configobject.schema.DisplayFilter;
import com.sygate.scm.common.configobject.schema.PasswordHistoryList;
import com.sygate.scm.common.configobject.schema.TempTokenToBypass2faInRestApi;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SemAdministrator
extends ConfigObject
implements NamedObject {
    public static final Integer DEFAULT = 0;
    public static final Integer SECURID = 1;
    public static final Integer DIRECTORY = 2;
    public static final Integer VIP = 3;
    public static final Integer SMARTCARD = 4;
    private static final long serialVersionUID = 1L;
    private String id;
    private Boolean enable;
    private String name;
    private String description;
    private String refId;
    private String fullName;
    private String emailAddress;
    private String passwordHash;
    private String randomPasswordHash;
    private Integer passwordAge;
    private Boolean useSecurId;
    private Integer authenticationMethod;
    private Long creationTime;
    private Long randomPasswordCreationTime;
    private Integer resetPasswordTimes;
    private Boolean hasAdminLoggedIn;
    private Boolean disableCopyPolicyReminder;
    private Boolean disableCIWReminder;
    private String lastViewedVersion;
    private String sAEPRefreshToken;
    private Long sAEPRefreshTokenExpiresBy;
    private String certificateIssuerAndSubject;
    private Boolean smartCardCertChainValid;
    private Long smartCardChainValidationTime;
    private String smartCardCertificate;

    public SemAdministrator() {
        this(true);
    }

    public SemAdministrator(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(108, new ChildGroup(1, 1));
        this.children.put(107, new ChildGroup(0, 1));
        this.children.put(109, new ChildGroup(0, 1));
        this.children.put(106, new ChildGroup(0, 1));
        this.children.put(105, new ChildGroup(0, 1));
        this.children.put(103, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "SemAdministrator";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.id = value;
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.name = value;
    }

    @Override
    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.description = value;
    }

    @Override
    public String getOptRefId() {
        return this.refId;
    }

    public void setOptRefId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.refId = value;
    }

    public String getOptFullName() {
        return this.fullName;
    }

    public void setOptFullName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.fullName = value;
    }

    public String getOptEmailAddress() {
        return this.emailAddress;
    }

    public void setOptEmailAddress(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.emailAddress = value;
    }

    public String getOptPasswordHash() {
        return this.passwordHash;
    }

    public void setOptPasswordHash(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.passwordHash = value;
    }

    public String getOptRandomPasswordHash() {
        return this.randomPasswordHash;
    }

    public void setOptRandomPasswordHash(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.randomPasswordHash = value;
    }

    public Integer getDefPasswordAge() {
        String productType = System.getProperty("Spc.Product.Type", "");
        return "SEPSB".equals(productType) ? Integer.valueOf(90) : Integer.valueOf(60);
    }

    public Integer getOptPasswordAge() {
        return this.passwordAge;
    }

    public void setOptPasswordAge(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.passwordAge = value;
    }

    public Boolean getDefUseSecurId() {
        return Boolean.FALSE;
    }

    public Boolean getOptUseSecurId() {
        return this.useSecurId;
    }

    public void setOptUseSecurId(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.useSecurId = value;
    }

    public Integer getOptAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public String getOptAuthenticationMethodValue() throws ValidationException {
        if (this.authenticationMethod == null) {
            return null;
        }
        String s = null;
        switch (this.authenticationMethod) {
            case 0: {
                s = "DEFAULT";
                break;
            }
            case 1: {
                s = "SECURID";
                break;
            }
            case 2: {
                s = "DIRECTORY";
                break;
            }
            case 3: {
                s = "VIP";
                break;
            }
            case 4: {
                s = "SMARTCARD";
                break;
            }
            default: {
                throw new ValidationException("SemAdministrator/AuthenticationMethod: invalid attribute value:" + this.authenticationMethod + "!");
            }
        }
        return s;
    }

    public void setOptAuthenticationMethod(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.authenticationMethod = value;
    }

    public void setOptAuthenticationMethodValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.authenticationMethod = null;
            return;
        }
        if ("DEFAULT".equals(value)) {
            this.authenticationMethod = DEFAULT;
        } else if ("SECURID".equals(value)) {
            this.authenticationMethod = SECURID;
        } else if ("DIRECTORY".equals(value)) {
            this.authenticationMethod = DIRECTORY;
        } else if ("VIP".equals(value)) {
            this.authenticationMethod = VIP;
        } else if ("SMARTCARD".equals(value)) {
            this.authenticationMethod = SMARTCARD;
        } else {
            throw new ValidationException("SemAdministrator/AuthenticationMethod: invalid attribute value:" + value + "!");
        }
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.creationTime = value;
    }

    public Long getOptRandomPasswordCreationTime() {
        return this.randomPasswordCreationTime;
    }

    public void setOptRandomPasswordCreationTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.randomPasswordCreationTime = value;
    }

    public Integer getDefResetPasswordTimes() {
        return 0;
    }

    public Integer getOptResetPasswordTimes() {
        return this.resetPasswordTimes;
    }

    public void setOptResetPasswordTimes(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.resetPasswordTimes = value;
    }

    public Boolean getDefHasAdminLoggedIn() {
        return Boolean.FALSE;
    }

    public Boolean getOptHasAdminLoggedIn() {
        return this.hasAdminLoggedIn;
    }

    public void setOptHasAdminLoggedIn(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.hasAdminLoggedIn = value;
    }

    public Boolean getDefDisableCopyPolicyReminder() {
        return Boolean.FALSE;
    }

    public Boolean getOptDisableCopyPolicyReminder() {
        return this.disableCopyPolicyReminder;
    }

    public void setOptDisableCopyPolicyReminder(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.disableCopyPolicyReminder = value;
    }

    public Boolean getDefDisableCIWReminder() {
        return Boolean.FALSE;
    }

    public Boolean getOptDisableCIWReminder() {
        return this.disableCIWReminder;
    }

    public void setOptDisableCIWReminder(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.disableCIWReminder = value;
    }

    public String getOptLastViewedVersion() {
        return this.lastViewedVersion;
    }

    public void setOptLastViewedVersion(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lastViewedVersion = value;
    }

    public String getOptSAEPRefreshToken() {
        return this.sAEPRefreshToken;
    }

    public void setOptSAEPRefreshToken(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.sAEPRefreshToken = value;
    }

    public Long getOptSAEPRefreshTokenExpiresBy() {
        return this.sAEPRefreshTokenExpiresBy;
    }

    public void setOptSAEPRefreshTokenExpiresBy(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.sAEPRefreshTokenExpiresBy = value;
    }

    public String getOptCertificateIssuerAndSubject() {
        return this.certificateIssuerAndSubject;
    }

    public void setOptCertificateIssuerAndSubject(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.certificateIssuerAndSubject = value;
    }

    public Boolean getDefSmartCardCertChainValid() {
        return Boolean.FALSE;
    }

    public Boolean getOptSmartCardCertChainValid() {
        return this.smartCardCertChainValid;
    }

    public void setOptSmartCardCertChainValid(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.smartCardCertChainValid = value;
    }

    public Long getDefSmartCardChainValidationTime() {
        return 0L;
    }

    public Long getOptSmartCardChainValidationTime() {
        return this.smartCardChainValidationTime;
    }

    public void setOptSmartCardChainValidationTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.smartCardChainValidationTime = value;
    }

    public String getOptSmartCardCertificate() {
        return this.smartCardCertificate;
    }

    public void setOptSmartCardCertificate(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.smartCardCertificate = value;
    }

    public AdminPayload getAdminPayload() {
        ChildGroup childGroup = (ChildGroup)this.children.get(108);
        if (childGroup.size() > 0) {
            return (AdminPayload)childGroup.get(0);
        }
        return null;
    }

    public void setAdminPayload(AdminPayload value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            AdminPayload obj = this.getAdminPayload();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public DirectoryAuthentication getOptDirectoryAuthentication() {
        ChildGroup childGroup = (ChildGroup)this.children.get(107);
        if (childGroup.size() > 0) {
            return (DirectoryAuthentication)childGroup.get(0);
        }
        return null;
    }

    public void setOptDirectoryAuthentication(DirectoryAuthentication value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            DirectoryAuthentication obj = this.getOptDirectoryAuthentication();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public AdminPreference getOptAdminPreference() {
        ChildGroup childGroup = (ChildGroup)this.children.get(109);
        if (childGroup.size() > 0) {
            return (AdminPreference)childGroup.get(0);
        }
        return null;
    }

    public void setOptAdminPreference(AdminPreference value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            AdminPreference obj = this.getOptAdminPreference();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public DisplayFilter getOptDisplayFilter() {
        ChildGroup childGroup = (ChildGroup)this.children.get(106);
        if (childGroup.size() > 0) {
            return (DisplayFilter)childGroup.get(0);
        }
        return null;
    }

    public void setOptDisplayFilter(DisplayFilter value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            DisplayFilter obj = this.getOptDisplayFilter();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public TempTokenToBypass2faInRestApi getOptTempTokenToBypass2faInRestApi() {
        ChildGroup childGroup = (ChildGroup)this.children.get(105);
        if (childGroup.size() > 0) {
            return (TempTokenToBypass2faInRestApi)childGroup.get(0);
        }
        return null;
    }

    public void setOptTempTokenToBypass2faInRestApi(TempTokenToBypass2faInRestApi value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            TempTokenToBypass2faInRestApi obj = this.getOptTempTokenToBypass2faInRestApi();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public PasswordHistoryList getOptPasswordHistoryList() {
        ChildGroup childGroup = (ChildGroup)this.children.get(103);
        if (childGroup.size() > 0) {
            return (PasswordHistoryList)childGroup.get(0);
        }
        return null;
    }

    public void setOptPasswordHistoryList(PasswordHistoryList value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            PasswordHistoryList obj = this.getOptPasswordHistoryList();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 102;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.id == null) {
            throw new ValidationException("SemAdministrator/Id: attribute is required!");
        }
        if (this.name == null) {
            throw new ValidationException("SemAdministrator/Name: attribute is required!");
        }
        if (this.creationTime == null) {
            throw new ValidationException("SemAdministrator/CreationTime: attribute is required!");
        }
        if (this.getAdminPayload() == null) {
            throw new ValidationException("SemAdministrator/AdminPayload: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof AdminPayload) {
            try {
                this.setAdminPayload((AdminPayload)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof DirectoryAuthentication) {
            try {
                this.setOptDirectoryAuthentication((DirectoryAuthentication)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof AdminPreference) {
            try {
                this.setOptAdminPreference((AdminPreference)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof DisplayFilter) {
            try {
                this.setOptDisplayFilter((DisplayFilter)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof TempTokenToBypass2faInRestApi) {
            try {
                this.setOptTempTokenToBypass2faInRestApi((TempTokenToBypass2faInRestApi)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof PasswordHistoryList) {
            try {
                this.setOptPasswordHistoryList((PasswordHistoryList)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Id");
            if (value == null) {
                throw new ValidationException("SemAdministrator/Id: attribute is required!");
            }
            this.id = value;
            value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("Name")) == null) {
                throw new ValidationException("SemAdministrator/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Description");
            if (value != null) {
                this.description = value;
            }
            if ((value = attris.getValue("RefId")) != null) {
                this.refId = value;
            }
            if ((value = attris.getValue("FullName")) != null) {
                this.fullName = value;
            }
            if ((value = attris.getValue("EmailAddress")) != null) {
                this.emailAddress = value;
            }
            if ((value = attris.getValue("PasswordHash")) != null) {
                this.passwordHash = value;
            }
            if ((value = attris.getValue("RandomPasswordHash")) != null) {
                this.randomPasswordHash = value;
            }
            if ((value = attris.getValue("PasswordAge")) != null) {
                try {
                    this.passwordAge = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("SemAdministrator/PasswordAge: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("SemAdministrator/PasswordAge: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("UseSecurId")) != null) {
                this.useSecurId = "1".equals(value);
            }
            if ((value = attris.getValue("AuthenticationMethod")) != null) {
                this.setOptAuthenticationMethodValue(value);
            }
            if ((value = attris.getValue("CreationTime")) == null) {
                throw new ValidationException("SemAdministrator/CreationTime: attribute is required!");
            }
            try {
                this.creationTime = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("SemAdministrator/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("SemAdministrator/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("RandomPasswordCreationTime");
            if (value != null) {
                try {
                    this.randomPasswordCreationTime = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("SemAdministrator/RandomPasswordCreationTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("SemAdministrator/RandomPasswordCreationTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("ResetPasswordTimes")) != null) {
                try {
                    this.resetPasswordTimes = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("SemAdministrator/ResetPasswordTimes: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("SemAdministrator/ResetPasswordTimes: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("HasAdminLoggedIn")) != null) {
                this.hasAdminLoggedIn = "1".equals(value);
            }
            if ((value = attris.getValue("DisableCopyPolicyReminder")) != null) {
                this.disableCopyPolicyReminder = "1".equals(value);
            }
            if ((value = attris.getValue("DisableCIWReminder")) != null) {
                this.disableCIWReminder = "1".equals(value);
            }
            if ((value = attris.getValue("LastViewedVersion")) != null) {
                this.lastViewedVersion = value;
            }
            if ((value = attris.getValue("SAEPRefreshToken")) != null) {
                this.sAEPRefreshToken = value;
            }
            if ((value = attris.getValue("SAEPRefreshTokenExpiresBy")) != null) {
                try {
                    this.sAEPRefreshTokenExpiresBy = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("SemAdministrator/SAEPRefreshTokenExpiresBy: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("SemAdministrator/SAEPRefreshTokenExpiresBy: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("CertificateIssuerAndSubject")) != null) {
                this.certificateIssuerAndSubject = value;
            }
            if ((value = attris.getValue("SmartCardCertChainValid")) != null) {
                this.smartCardCertChainValid = "1".equals(value);
            }
            if ((value = attris.getValue("SmartCardChainValidationTime")) != null) {
                try {
                    this.smartCardChainValidationTime = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("SemAdministrator/SmartCardChainValidationTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("SemAdministrator/SmartCardChainValidationTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("SmartCardCertificate")) != null) {
                this.smartCardCertificate = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getAdminPayload() != null) {
            this.getAdminPayload().setReadonly();
        }
        if (this.getOptDirectoryAuthentication() != null) {
            this.getOptDirectoryAuthentication().setReadonly();
        }
        if (this.getOptAdminPreference() != null) {
            this.getOptAdminPreference().setReadonly();
        }
        if (this.getOptDisplayFilter() != null) {
            this.getOptDisplayFilter().setReadonly();
        }
        if (this.getOptTempTokenToBypass2faInRestApi() != null) {
            this.getOptTempTokenToBypass2faInRestApi().setReadonly();
        }
        if (this.getOptPasswordHistoryList() != null) {
            this.getOptPasswordHistoryList().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(108)).size();
        }
        catch (Throwable t) {
            throw new SAXException("SemAdministrator: can't import element == AdminPayload!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"SemAdministrator".equals(element.getNodeName())) {
            throw new ValidationException("SemAdministrator: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Id");
        if (value == null) {
            throw new ValidationException("SemAdministrator/Id: attribute is required!");
        }
        this.id = value;
        value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Name")) == null) {
            throw new ValidationException("SemAdministrator/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Description");
        if (value != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RefId")) != null) {
            this.refId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "FullName")) != null) {
            this.fullName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "EmailAddress")) != null) {
            this.emailAddress = value;
        }
        if ((value = XMLHelper.getAttribute(element, "PasswordHash")) != null) {
            this.passwordHash = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RandomPasswordHash")) != null) {
            this.randomPasswordHash = value;
        }
        if ((value = XMLHelper.getAttribute(element, "PasswordAge")) != null) {
            try {
                this.passwordAge = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("SemAdministrator/PasswordAge: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "UseSecurId")) != null) {
            this.useSecurId = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AuthenticationMethod")) != null) {
            this.setOptAuthenticationMethodValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "CreationTime")) == null) {
            throw new ValidationException("SemAdministrator/CreationTime: attribute is required!");
        }
        try {
            this.creationTime = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("SemAdministrator/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("SemAdministrator/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "RandomPasswordCreationTime");
        if (value != null) {
            try {
                this.randomPasswordCreationTime = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("SemAdministrator/RandomPasswordCreationTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "ResetPasswordTimes")) != null) {
            try {
                this.resetPasswordTimes = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("SemAdministrator/ResetPasswordTimes: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "HasAdminLoggedIn")) != null) {
            this.hasAdminLoggedIn = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "DisableCopyPolicyReminder")) != null) {
            this.disableCopyPolicyReminder = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "DisableCIWReminder")) != null) {
            this.disableCIWReminder = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LastViewedVersion")) != null) {
            this.lastViewedVersion = value;
        }
        if ((value = XMLHelper.getAttribute(element, "SAEPRefreshToken")) != null) {
            this.sAEPRefreshToken = value;
        }
        if ((value = XMLHelper.getAttribute(element, "SAEPRefreshTokenExpiresBy")) != null) {
            try {
                this.sAEPRefreshTokenExpiresBy = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("SemAdministrator/SAEPRefreshTokenExpiresBy: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "CertificateIssuerAndSubject")) != null) {
            this.certificateIssuerAndSubject = value;
        }
        if ((value = XMLHelper.getAttribute(element, "SmartCardCertChainValid")) != null) {
            this.smartCardCertChainValid = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "SmartCardChainValidationTime")) != null) {
            try {
                this.smartCardChainValidationTime = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("SemAdministrator/SmartCardChainValidationTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "SmartCardCertificate")) != null) {
            this.smartCardCertificate = value;
        }
        if ((v = XMLHelper.getChildElementByName(element, "AdminPayload")).size() != 1) {
            throw new ValidationException("SemAdministrator/AdminPayload: element is require!");
        }
        AdminPayload adminPayloadObj = new AdminPayload();
        adminPayloadObj.importFromElement(v.get(0));
        this.setAdminPayload(adminPayloadObj);
        v = XMLHelper.getChildElementByName(element, "DirectoryAuthentication");
        if (v.size() > 0) {
            DirectoryAuthentication directoryAuthenticationObj = new DirectoryAuthentication();
            directoryAuthenticationObj.importFromElement(v.get(0));
            this.setOptDirectoryAuthentication(directoryAuthenticationObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "AdminPreference")).size() > 0) {
            AdminPreference adminPreferenceObj = new AdminPreference();
            adminPreferenceObj.importFromElement(v.get(0));
            this.setOptAdminPreference(adminPreferenceObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "DisplayFilter")).size() > 0) {
            DisplayFilter displayFilterObj = new DisplayFilter();
            displayFilterObj.importFromElement(v.get(0));
            this.setOptDisplayFilter(displayFilterObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "TempTokenToBypass2faInRestApi")).size() > 0) {
            TempTokenToBypass2faInRestApi tempTokenToBypass2faInRestApiObj = new TempTokenToBypass2faInRestApi();
            tempTokenToBypass2faInRestApiObj.importFromElement(v.get(0));
            this.setOptTempTokenToBypass2faInRestApi(tempTokenToBypass2faInRestApiObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "PasswordHistoryList")).size() > 0) {
            PasswordHistoryList passwordHistoryListObj = new PasswordHistoryList();
            passwordHistoryListObj.importFromElement(v.get(0));
            this.setOptPasswordHistoryList(passwordHistoryListObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("SemAdministrator/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("SemAdministrator/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("SemAdministrator");
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.refId != null) {
            element.setAttribute("RefId", this.refId);
        }
        if (this.fullName != null) {
            element.setAttribute("FullName", this.fullName);
        }
        if (this.emailAddress != null) {
            element.setAttribute("EmailAddress", this.emailAddress);
        }
        if (this.passwordHash != null) {
            element.setAttribute("PasswordHash", this.passwordHash);
        }
        if (this.randomPasswordHash != null) {
            element.setAttribute("RandomPasswordHash", this.randomPasswordHash);
        }
        if (this.passwordAge != null) {
            element.setAttribute("PasswordAge", this.passwordAge.toString());
        }
        if (this.useSecurId != null) {
            element.setAttribute("UseSecurId", this.useSecurId != false ? "1" : "0");
        }
        if (this.authenticationMethod != null) {
            element.setAttribute("AuthenticationMethod", this.getOptAuthenticationMethodValue());
        }
        if (this.creationTime != null) {
            element.setAttribute("CreationTime", this.creationTime.toString());
        }
        if (this.randomPasswordCreationTime != null) {
            element.setAttribute("RandomPasswordCreationTime", this.randomPasswordCreationTime.toString());
        }
        if (this.resetPasswordTimes != null) {
            element.setAttribute("ResetPasswordTimes", this.resetPasswordTimes.toString());
        }
        if (this.hasAdminLoggedIn != null) {
            element.setAttribute("HasAdminLoggedIn", this.hasAdminLoggedIn != false ? "1" : "0");
        }
        if (this.disableCopyPolicyReminder != null) {
            element.setAttribute("DisableCopyPolicyReminder", this.disableCopyPolicyReminder != false ? "1" : "0");
        }
        if (this.disableCIWReminder != null) {
            element.setAttribute("DisableCIWReminder", this.disableCIWReminder != false ? "1" : "0");
        }
        if (this.lastViewedVersion != null) {
            element.setAttribute("LastViewedVersion", this.lastViewedVersion);
        }
        if (this.sAEPRefreshToken != null) {
            element.setAttribute("SAEPRefreshToken", this.sAEPRefreshToken);
        }
        if (this.sAEPRefreshTokenExpiresBy != null) {
            element.setAttribute("SAEPRefreshTokenExpiresBy", this.sAEPRefreshTokenExpiresBy.toString());
        }
        if (this.certificateIssuerAndSubject != null) {
            element.setAttribute("CertificateIssuerAndSubject", this.certificateIssuerAndSubject);
        }
        if (this.smartCardCertChainValid != null) {
            element.setAttribute("SmartCardCertChainValid", this.smartCardCertChainValid != false ? "1" : "0");
        }
        if (this.smartCardChainValidationTime != null) {
            element.setAttribute("SmartCardChainValidationTime", this.smartCardChainValidationTime.toString());
        }
        if (this.smartCardCertificate != null) {
            element.setAttribute("SmartCardCertificate", this.smartCardCertificate);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SemAdministrator ");
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.refId != null) {
                strAttrs.append("RefId=\"").append(AbstractSchema.checkXMLContent(this.refId)).append("\" ");
            }
            if (this.fullName != null) {
                strAttrs.append("FullName=\"").append(AbstractSchema.checkXMLContent(this.fullName)).append("\" ");
            }
            if (this.emailAddress != null) {
                strAttrs.append("EmailAddress=\"").append(AbstractSchema.checkXMLContent(this.emailAddress)).append("\" ");
            }
            if (this.passwordHash != null) {
                strAttrs.append("PasswordHash=\"").append(AbstractSchema.checkXMLContent(this.passwordHash)).append("\" ");
            }
            if (this.randomPasswordHash != null) {
                strAttrs.append("RandomPasswordHash=\"").append(AbstractSchema.checkXMLContent(this.randomPasswordHash)).append("\" ");
            }
            if (this.passwordAge != null) {
                strAttrs.append("PasswordAge=\"").append(this.passwordAge.toString()).append("\" ");
            }
            if (this.useSecurId != null) {
                strAttrs.append("UseSecurId=").append(this.useSecurId != false ? "\"1\" " : "\"0\" ");
            }
            if (this.authenticationMethod != null) {
                strAttrs.append("AuthenticationMethod=\"").append(this.getOptAuthenticationMethodValue()).append("\" ");
            }
            if (this.creationTime != null) {
                strAttrs.append("CreationTime=\"").append(this.creationTime.toString()).append("\" ");
            }
            if (this.randomPasswordCreationTime != null) {
                strAttrs.append("RandomPasswordCreationTime=\"").append(this.randomPasswordCreationTime.toString()).append("\" ");
            }
            if (this.resetPasswordTimes != null) {
                strAttrs.append("ResetPasswordTimes=\"").append(this.resetPasswordTimes.toString()).append("\" ");
            }
            if (this.hasAdminLoggedIn != null) {
                strAttrs.append("HasAdminLoggedIn=").append(this.hasAdminLoggedIn != false ? "\"1\" " : "\"0\" ");
            }
            if (this.disableCopyPolicyReminder != null) {
                strAttrs.append("DisableCopyPolicyReminder=").append(this.disableCopyPolicyReminder != false ? "\"1\" " : "\"0\" ");
            }
            if (this.disableCIWReminder != null) {
                strAttrs.append("DisableCIWReminder=").append(this.disableCIWReminder != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lastViewedVersion != null) {
                strAttrs.append("LastViewedVersion=\"").append(AbstractSchema.checkXMLContent(this.lastViewedVersion)).append("\" ");
            }
            if (this.sAEPRefreshToken != null) {
                strAttrs.append("SAEPRefreshToken=\"").append(AbstractSchema.checkXMLContent(this.sAEPRefreshToken)).append("\" ");
            }
            if (this.sAEPRefreshTokenExpiresBy != null) {
                strAttrs.append("SAEPRefreshTokenExpiresBy=\"").append(this.sAEPRefreshTokenExpiresBy.toString()).append("\" ");
            }
            if (this.certificateIssuerAndSubject != null) {
                strAttrs.append("CertificateIssuerAndSubject=\"").append(AbstractSchema.checkXMLContent(this.certificateIssuerAndSubject)).append("\" ");
            }
            if (this.smartCardCertChainValid != null) {
                strAttrs.append("SmartCardCertChainValid=").append(this.smartCardCertChainValid != false ? "\"1\" " : "\"0\" ");
            }
            if (this.smartCardChainValidationTime != null) {
                strAttrs.append("SmartCardChainValidationTime=\"").append(this.smartCardChainValidationTime.toString()).append("\" ");
            }
            if (this.smartCardCertificate != null) {
                strAttrs.append("SmartCardCertificate=\"").append(AbstractSchema.checkXMLContent(this.smartCardCertificate)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SemAdministrator>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

