/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.AllowedClientGroup;
import com.sygate.scm.common.configobject.schema.DisallowedClientGroup;
import com.sygate.scm.common.configobject.schema.ReadOnlyClientGroup;
import com.sygate.scm.common.configobject.schema.SitePrivilegeSet;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SemAdminPrivilege
extends ConfigObject {
    public static final Integer FULL_ACCESS = 0;
    public static final Integer NO_ACCESS = 1;
    public static final Integer READ_ONLY = 2;
    private static final long serialVersionUID = 1L;
    private String allowedPane;
    private String disallowedFeature;
    private String allowedLegacyDomain;
    private String allowedLegacyGroup;
    private String allowedLegacyServer;
    private String allowedComputer;
    private String allowedIP;
    private String disallowedCommand;
    private Boolean allowReadOnlyRunCommands;
    private Integer packagePrivilege;

    public SemAdminPrivilege() {
        this(true);
    }

    public SemAdminPrivilege(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(123, new ChildGroup(1, 1));
        this.children.put(125, new ChildGroup(0, 1));
        this.children.put(126, new ChildGroup(0, 1));
        this.children.put(128, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "SemAdminPrivilege";
    }

    public String getOptAllowedPane() {
        return this.allowedPane;
    }

    public void setOptAllowedPane(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowedPane = value;
    }

    public String getOptDisallowedFeature() {
        return this.disallowedFeature;
    }

    public void setOptDisallowedFeature(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.disallowedFeature = value;
    }

    public String getOptAllowedLegacyDomain() {
        return this.allowedLegacyDomain;
    }

    public void setOptAllowedLegacyDomain(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowedLegacyDomain = value;
    }

    public String getOptAllowedLegacyGroup() {
        return this.allowedLegacyGroup;
    }

    public void setOptAllowedLegacyGroup(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowedLegacyGroup = value;
    }

    public String getOptAllowedLegacyServer() {
        return this.allowedLegacyServer;
    }

    public void setOptAllowedLegacyServer(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowedLegacyServer = value;
    }

    public String getOptAllowedComputer() {
        return this.allowedComputer;
    }

    public void setOptAllowedComputer(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowedComputer = value;
    }

    public String getOptAllowedIP() {
        return this.allowedIP;
    }

    public void setOptAllowedIP(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowedIP = value;
    }

    public String getOptDisallowedCommand() {
        return this.disallowedCommand;
    }

    public void setOptDisallowedCommand(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.disallowedCommand = value;
    }

    public Boolean getDefAllowReadOnlyRunCommands() {
        return Boolean.FALSE;
    }

    public Boolean getOptAllowReadOnlyRunCommands() {
        return this.allowReadOnlyRunCommands;
    }

    public void setOptAllowReadOnlyRunCommands(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowReadOnlyRunCommands = value;
    }

    public Integer getDefPackagePrivilege() {
        return FULL_ACCESS;
    }

    public Integer getOptPackagePrivilege() {
        return this.packagePrivilege;
    }

    public String getOptPackagePrivilegeValue() throws ValidationException {
        if (this.packagePrivilege == null) {
            return null;
        }
        String s = null;
        switch (this.packagePrivilege) {
            case 0: {
                s = "FULL_ACCESS";
                break;
            }
            case 1: {
                s = "NO_ACCESS";
                break;
            }
            case 2: {
                s = "READ_ONLY";
                break;
            }
            default: {
                throw new ValidationException("SemAdminPrivilege/PackagePrivilege: invalid attribute value:" + this.packagePrivilege + "!");
            }
        }
        return s;
    }

    public void setOptPackagePrivilege(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.packagePrivilege = value;
    }

    public void setOptPackagePrivilegeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.packagePrivilege = null;
            return;
        }
        if ("FULL_ACCESS".equals(value)) {
            this.packagePrivilege = FULL_ACCESS;
        } else if ("NO_ACCESS".equals(value)) {
            this.packagePrivilege = NO_ACCESS;
        } else if ("READ_ONLY".equals(value)) {
            this.packagePrivilege = READ_ONLY;
        } else {
            throw new ValidationException("SemAdminPrivilege/PackagePrivilege: invalid attribute value:" + value + "!");
        }
    }

    public AllowedClientGroup getAllowedClientGroup() {
        ChildGroup childGroup = (ChildGroup)this.children.get(123);
        if (childGroup.size() > 0) {
            return (AllowedClientGroup)childGroup.get(0);
        }
        return null;
    }

    public void setAllowedClientGroup(AllowedClientGroup value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            AllowedClientGroup obj = this.getAllowedClientGroup();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public DisallowedClientGroup getOptDisallowedClientGroup() {
        ChildGroup childGroup = (ChildGroup)this.children.get(125);
        if (childGroup.size() > 0) {
            return (DisallowedClientGroup)childGroup.get(0);
        }
        return null;
    }

    public void setOptDisallowedClientGroup(DisallowedClientGroup value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            DisallowedClientGroup obj = this.getOptDisallowedClientGroup();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public ReadOnlyClientGroup getOptReadOnlyClientGroup() {
        ChildGroup childGroup = (ChildGroup)this.children.get(126);
        if (childGroup.size() > 0) {
            return (ReadOnlyClientGroup)childGroup.get(0);
        }
        return null;
    }

    public void setOptReadOnlyClientGroup(ReadOnlyClientGroup value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ReadOnlyClientGroup obj = this.getOptReadOnlyClientGroup();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public SitePrivilegeSet getOptSitePrivilegeSet() {
        ChildGroup childGroup = (ChildGroup)this.children.get(128);
        if (childGroup.size() > 0) {
            return (SitePrivilegeSet)childGroup.get(0);
        }
        return null;
    }

    public void setOptSitePrivilegeSet(SitePrivilegeSet value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            SitePrivilegeSet obj = this.getOptSitePrivilegeSet();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 122;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.getAllowedClientGroup() == null) {
            throw new ValidationException("SemAdminPrivilege/AllowedClientGroup: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof AllowedClientGroup) {
            try {
                this.setAllowedClientGroup((AllowedClientGroup)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof DisallowedClientGroup) {
            try {
                this.setOptDisallowedClientGroup((DisallowedClientGroup)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof ReadOnlyClientGroup) {
            try {
                this.setOptReadOnlyClientGroup((ReadOnlyClientGroup)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof SitePrivilegeSet) {
            try {
                this.setOptSitePrivilegeSet((SitePrivilegeSet)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("AllowedPane");
            if (value != null) {
                this.allowedPane = value;
            }
            if ((value = attris.getValue("DisallowedFeature")) != null) {
                this.disallowedFeature = value;
            }
            if ((value = attris.getValue("AllowedLegacyDomain")) != null) {
                this.allowedLegacyDomain = value;
            }
            if ((value = attris.getValue("AllowedLegacyGroup")) != null) {
                this.allowedLegacyGroup = value;
            }
            if ((value = attris.getValue("AllowedLegacyServer")) != null) {
                this.allowedLegacyServer = value;
            }
            if ((value = attris.getValue("AllowedComputer")) != null) {
                this.allowedComputer = value;
            }
            if ((value = attris.getValue("AllowedIP")) != null) {
                this.allowedIP = value;
            }
            if ((value = attris.getValue("DisallowedCommand")) != null) {
                this.disallowedCommand = value;
            }
            if ((value = attris.getValue("AllowReadOnlyRunCommands")) != null) {
                this.allowReadOnlyRunCommands = "1".equals(value);
            }
            if ((value = attris.getValue("PackagePrivilege")) != null) {
                this.setOptPackagePrivilegeValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getAllowedClientGroup() != null) {
            this.getAllowedClientGroup().setReadonly();
        }
        if (this.getOptDisallowedClientGroup() != null) {
            this.getOptDisallowedClientGroup().setReadonly();
        }
        if (this.getOptReadOnlyClientGroup() != null) {
            this.getOptReadOnlyClientGroup().setReadonly();
        }
        if (this.getOptSitePrivilegeSet() != null) {
            this.getOptSitePrivilegeSet().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(123)).size();
        }
        catch (Throwable t) {
            throw new SAXException("SemAdminPrivilege: can't import element == AllowedClientGroup!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"SemAdminPrivilege".equals(element.getNodeName())) {
            throw new ValidationException("SemAdminPrivilege: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "AllowedPane");
        if (value != null) {
            this.allowedPane = value;
        }
        if ((value = XMLHelper.getAttribute(element, "DisallowedFeature")) != null) {
            this.disallowedFeature = value;
        }
        if ((value = XMLHelper.getAttribute(element, "AllowedLegacyDomain")) != null) {
            this.allowedLegacyDomain = value;
        }
        if ((value = XMLHelper.getAttribute(element, "AllowedLegacyGroup")) != null) {
            this.allowedLegacyGroup = value;
        }
        if ((value = XMLHelper.getAttribute(element, "AllowedLegacyServer")) != null) {
            this.allowedLegacyServer = value;
        }
        if ((value = XMLHelper.getAttribute(element, "AllowedComputer")) != null) {
            this.allowedComputer = value;
        }
        if ((value = XMLHelper.getAttribute(element, "AllowedIP")) != null) {
            this.allowedIP = value;
        }
        if ((value = XMLHelper.getAttribute(element, "DisallowedCommand")) != null) {
            this.disallowedCommand = value;
        }
        if ((value = XMLHelper.getAttribute(element, "AllowReadOnlyRunCommands")) != null) {
            this.allowReadOnlyRunCommands = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "PackagePrivilege")) != null) {
            this.setOptPackagePrivilegeValue(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "AllowedClientGroup")).size() != 1) {
            throw new ValidationException("SemAdminPrivilege/AllowedClientGroup: element is require!");
        }
        AllowedClientGroup allowedClientGroupObj = new AllowedClientGroup();
        allowedClientGroupObj.importFromElement(v.get(0));
        this.setAllowedClientGroup(allowedClientGroupObj);
        v = XMLHelper.getChildElementByName(element, "DisallowedClientGroup");
        if (v.size() > 0) {
            DisallowedClientGroup disallowedClientGroupObj = new DisallowedClientGroup();
            disallowedClientGroupObj.importFromElement(v.get(0));
            this.setOptDisallowedClientGroup(disallowedClientGroupObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "ReadOnlyClientGroup")).size() > 0) {
            ReadOnlyClientGroup readOnlyClientGroupObj = new ReadOnlyClientGroup();
            readOnlyClientGroupObj.importFromElement(v.get(0));
            this.setOptReadOnlyClientGroup(readOnlyClientGroupObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "SitePrivilegeSet")).size() > 0) {
            SitePrivilegeSet sitePrivilegeSetObj = new SitePrivilegeSet();
            sitePrivilegeSetObj.importFromElement(v.get(0));
            this.setOptSitePrivilegeSet(sitePrivilegeSetObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("SemAdminPrivilege/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("SemAdminPrivilege/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("SemAdminPrivilege");
        if (this.allowedPane != null) {
            element.setAttribute("AllowedPane", this.allowedPane);
        }
        if (this.disallowedFeature != null) {
            element.setAttribute("DisallowedFeature", this.disallowedFeature);
        }
        if (this.allowedLegacyDomain != null) {
            element.setAttribute("AllowedLegacyDomain", this.allowedLegacyDomain);
        }
        if (this.allowedLegacyGroup != null) {
            element.setAttribute("AllowedLegacyGroup", this.allowedLegacyGroup);
        }
        if (this.allowedLegacyServer != null) {
            element.setAttribute("AllowedLegacyServer", this.allowedLegacyServer);
        }
        if (this.allowedComputer != null) {
            element.setAttribute("AllowedComputer", this.allowedComputer);
        }
        if (this.allowedIP != null) {
            element.setAttribute("AllowedIP", this.allowedIP);
        }
        if (this.disallowedCommand != null) {
            element.setAttribute("DisallowedCommand", this.disallowedCommand);
        }
        if (this.allowReadOnlyRunCommands != null) {
            element.setAttribute("AllowReadOnlyRunCommands", this.allowReadOnlyRunCommands != false ? "1" : "0");
        }
        if (this.packagePrivilege != null) {
            element.setAttribute("PackagePrivilege", this.getOptPackagePrivilegeValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SemAdminPrivilege ");
            if (this.allowedPane != null) {
                strAttrs.append("AllowedPane=\"").append(AbstractSchema.checkXMLContent(this.allowedPane)).append("\" ");
            }
            if (this.disallowedFeature != null) {
                strAttrs.append("DisallowedFeature=\"").append(AbstractSchema.checkXMLContent(this.disallowedFeature)).append("\" ");
            }
            if (this.allowedLegacyDomain != null) {
                strAttrs.append("AllowedLegacyDomain=\"").append(AbstractSchema.checkXMLContent(this.allowedLegacyDomain)).append("\" ");
            }
            if (this.allowedLegacyGroup != null) {
                strAttrs.append("AllowedLegacyGroup=\"").append(AbstractSchema.checkXMLContent(this.allowedLegacyGroup)).append("\" ");
            }
            if (this.allowedLegacyServer != null) {
                strAttrs.append("AllowedLegacyServer=\"").append(AbstractSchema.checkXMLContent(this.allowedLegacyServer)).append("\" ");
            }
            if (this.allowedComputer != null) {
                strAttrs.append("AllowedComputer=\"").append(AbstractSchema.checkXMLContent(this.allowedComputer)).append("\" ");
            }
            if (this.allowedIP != null) {
                strAttrs.append("AllowedIP=\"").append(AbstractSchema.checkXMLContent(this.allowedIP)).append("\" ");
            }
            if (this.disallowedCommand != null) {
                strAttrs.append("DisallowedCommand=\"").append(AbstractSchema.checkXMLContent(this.disallowedCommand)).append("\" ");
            }
            if (this.allowReadOnlyRunCommands != null) {
                strAttrs.append("AllowReadOnlyRunCommands=").append(this.allowReadOnlyRunCommands != false ? "\"1\" " : "\"0\" ");
            }
            if (this.packagePrivilege != null) {
                strAttrs.append("PackagePrivilege=\"").append(this.getOptPackagePrivilegeValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SemAdminPrivilege>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

