/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.DirectoryOverride;
import com.sygate.scm.common.configobject.schema.Extension;
import com.sygate.scm.common.configobject.schema.FileOverride;
import com.sygate.scm.common.configobject.schema.KnownRiskOverrride;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SecurityRiskOverride
extends ConfigObject {
    public static final Integer GESC_AP = 0;
    public static final Integer GESC_MANUAL = 1;
    public static final Integer GESC_ALL = 2;
    private static final long serialVersionUID = 1L;
    private Integer scanCategories;

    public SecurityRiskOverride() {
        this(true);
    }

    public SecurityRiskOverride(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(681, new ChildGroup(0, 1));
        this.children.put(607, new ChildGroup(0, 1));
        this.children.put(683, new ChildGroup(0, 1));
        this.children.put(687, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "SecurityRiskOverride";
    }

    public Integer getDefScanCategories() {
        return GESC_ALL;
    }

    public Integer getOptScanCategories() {
        return this.scanCategories;
    }

    public String getOptScanCategoriesValue() throws ValidationException {
        if (this.scanCategories == null) {
            return null;
        }
        String s = null;
        switch (this.scanCategories) {
            case 0: {
                s = "GESC_AP";
                break;
            }
            case 1: {
                s = "GESC_MANUAL";
                break;
            }
            case 2: {
                s = "GESC_ALL";
                break;
            }
            default: {
                throw new ValidationException("SecurityRiskOverride/ScanCategories: invalid attribute value:" + this.scanCategories + "!");
            }
        }
        return s;
    }

    public void setOptScanCategories(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.scanCategories = value;
    }

    public void setOptScanCategoriesValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.scanCategories = null;
            return;
        }
        if ("GESC_AP".equals(value)) {
            this.scanCategories = GESC_AP;
        } else if ("GESC_MANUAL".equals(value)) {
            this.scanCategories = GESC_MANUAL;
        } else if ("GESC_ALL".equals(value)) {
            this.scanCategories = GESC_ALL;
        } else {
            throw new ValidationException("SecurityRiskOverride/ScanCategories: invalid attribute value:" + value + "!");
        }
    }

    public KnownRiskOverrride getOptKnownRiskOverrride() {
        ChildGroup childGroup = (ChildGroup)this.children.get(681);
        if (childGroup.size() > 0) {
            return (KnownRiskOverrride)childGroup.get(0);
        }
        return null;
    }

    public void setOptKnownRiskOverrride(KnownRiskOverrride value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            KnownRiskOverrride obj = this.getOptKnownRiskOverrride();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public Extension getOptExtension() {
        ChildGroup childGroup = (ChildGroup)this.children.get(607);
        if (childGroup.size() > 0) {
            return (Extension)childGroup.get(0);
        }
        return null;
    }

    public void setOptExtension(Extension value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            Extension obj = this.getOptExtension();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public FileOverride getOptFileOverride() {
        ChildGroup childGroup = (ChildGroup)this.children.get(683);
        if (childGroup.size() > 0) {
            return (FileOverride)childGroup.get(0);
        }
        return null;
    }

    public void setOptFileOverride(FileOverride value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            FileOverride obj = this.getOptFileOverride();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public DirectoryOverride getOptDirectoryOverride() {
        ChildGroup childGroup = (ChildGroup)this.children.get(687);
        if (childGroup.size() > 0) {
            return (DirectoryOverride)childGroup.get(0);
        }
        return null;
    }

    public void setOptDirectoryOverride(DirectoryOverride value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            DirectoryOverride obj = this.getOptDirectoryOverride();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 680;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof KnownRiskOverrride) {
            try {
                this.setOptKnownRiskOverrride((KnownRiskOverrride)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof Extension) {
            try {
                this.setOptExtension((Extension)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof FileOverride) {
            try {
                this.setOptFileOverride((FileOverride)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof DirectoryOverride) {
            try {
                this.setOptDirectoryOverride((DirectoryOverride)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("ScanCategories");
            if (value != null) {
                this.setOptScanCategoriesValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptKnownRiskOverrride() != null) {
            this.getOptKnownRiskOverrride().setReadonly();
        }
        if (this.getOptExtension() != null) {
            this.getOptExtension().setReadonly();
        }
        if (this.getOptFileOverride() != null) {
            this.getOptFileOverride().setReadonly();
        }
        if (this.getOptDirectoryOverride() != null) {
            this.getOptDirectoryOverride().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"SecurityRiskOverride".equals(element.getNodeName())) {
            throw new ValidationException("SecurityRiskOverride: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "ScanCategories");
        if (value != null) {
            this.setOptScanCategoriesValue(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "KnownRiskOverrride")).size() > 0) {
            KnownRiskOverrride knownRiskOverrrideObj = new KnownRiskOverrride();
            knownRiskOverrrideObj.importFromElement(v.get(0));
            this.setOptKnownRiskOverrride(knownRiskOverrrideObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "Extension")).size() > 0) {
            Extension extensionObj = new Extension();
            extensionObj.importFromElement(v.get(0));
            this.setOptExtension(extensionObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "FileOverride")).size() > 0) {
            FileOverride fileOverrideObj = new FileOverride();
            fileOverrideObj.importFromElement(v.get(0));
            this.setOptFileOverride(fileOverrideObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "DirectoryOverride")).size() > 0) {
            DirectoryOverride directoryOverrideObj = new DirectoryOverride();
            directoryOverrideObj.importFromElement(v.get(0));
            this.setOptDirectoryOverride(directoryOverrideObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("SecurityRiskOverride/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("SecurityRiskOverride/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("SecurityRiskOverride");
        if (this.scanCategories != null) {
            element.setAttribute("ScanCategories", this.getOptScanCategoriesValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SecurityRiskOverride ");
            if (this.scanCategories != null) {
                strAttrs.append("ScanCategories=\"").append(this.getOptScanCategoriesValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SecurityRiskOverride>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

