/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SecurityFixContentInfo
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private String clientMoniker;
    private String sequenceNum;
    private String productBuildNum;
    private String packageChecksum;
    private String packageCode;
    private String productCode;

    public SecurityFixContentInfo() {
        this(true);
    }

    public SecurityFixContentInfo(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "SecurityFixContentInfo";
    }

    public String getClientMoniker() {
        return this.clientMoniker;
    }

    public void setClientMoniker(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.clientMoniker = value;
    }

    public String getSequenceNum() {
        return this.sequenceNum;
    }

    public void setSequenceNum(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.sequenceNum = value;
    }

    public String getProductBuildNum() {
        return this.productBuildNum;
    }

    public void setProductBuildNum(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.productBuildNum = value;
    }

    public String getPackageChecksum() {
        return this.packageChecksum;
    }

    public void setPackageChecksum(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.packageChecksum = value;
    }

    public String getPackageCode() {
        return this.packageCode;
    }

    public void setPackageCode(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.packageCode = value;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.productCode = value;
    }

    @Override
    public int getObjectType() {
        return 736;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.clientMoniker == null) {
            throw new ValidationException("SecurityFixContentInfo/ClientMoniker: attribute is required!");
        }
        if (this.sequenceNum == null) {
            throw new ValidationException("SecurityFixContentInfo/SequenceNum: attribute is required!");
        }
        if (this.productBuildNum == null) {
            throw new ValidationException("SecurityFixContentInfo/ProductBuildNum: attribute is required!");
        }
        if (this.packageChecksum == null) {
            throw new ValidationException("SecurityFixContentInfo/PackageChecksum: attribute is required!");
        }
        if (this.packageCode == null) {
            throw new ValidationException("SecurityFixContentInfo/PackageCode: attribute is required!");
        }
        if (this.productCode == null) {
            throw new ValidationException("SecurityFixContentInfo/ProductCode: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("ClientMoniker");
            if (value == null) {
                throw new ValidationException("SecurityFixContentInfo/ClientMoniker: attribute is required!");
            }
            this.clientMoniker = value;
            value = attris.getValue("SequenceNum");
            if (value == null) {
                throw new ValidationException("SecurityFixContentInfo/SequenceNum: attribute is required!");
            }
            this.sequenceNum = value;
            value = attris.getValue("ProductBuildNum");
            if (value == null) {
                throw new ValidationException("SecurityFixContentInfo/ProductBuildNum: attribute is required!");
            }
            this.productBuildNum = value;
            value = attris.getValue("PackageChecksum");
            if (value == null) {
                throw new ValidationException("SecurityFixContentInfo/PackageChecksum: attribute is required!");
            }
            this.packageChecksum = value;
            value = attris.getValue("PackageCode");
            if (value == null) {
                throw new ValidationException("SecurityFixContentInfo/PackageCode: attribute is required!");
            }
            this.packageCode = value;
            value = attris.getValue("ProductCode");
            if (value == null) {
                throw new ValidationException("SecurityFixContentInfo/ProductCode: attribute is required!");
            }
            this.productCode = value;
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"SecurityFixContentInfo".equals(element.getNodeName())) {
            throw new ValidationException("SecurityFixContentInfo: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "ClientMoniker");
        if (value == null) {
            throw new ValidationException("SecurityFixContentInfo/ClientMoniker: attribute is required!");
        }
        this.clientMoniker = value;
        value = XMLHelper.getAttribute(element, "SequenceNum");
        if (value == null) {
            throw new ValidationException("SecurityFixContentInfo/SequenceNum: attribute is required!");
        }
        this.sequenceNum = value;
        value = XMLHelper.getAttribute(element, "ProductBuildNum");
        if (value == null) {
            throw new ValidationException("SecurityFixContentInfo/ProductBuildNum: attribute is required!");
        }
        this.productBuildNum = value;
        value = XMLHelper.getAttribute(element, "PackageChecksum");
        if (value == null) {
            throw new ValidationException("SecurityFixContentInfo/PackageChecksum: attribute is required!");
        }
        this.packageChecksum = value;
        value = XMLHelper.getAttribute(element, "PackageCode");
        if (value == null) {
            throw new ValidationException("SecurityFixContentInfo/PackageCode: attribute is required!");
        }
        this.packageCode = value;
        value = XMLHelper.getAttribute(element, "ProductCode");
        if (value == null) {
            throw new ValidationException("SecurityFixContentInfo/ProductCode: attribute is required!");
        }
        this.productCode = value;
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("SecurityFixContentInfo/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("SecurityFixContentInfo/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("SecurityFixContentInfo");
        if (this.clientMoniker != null) {
            element.setAttribute("ClientMoniker", this.clientMoniker);
        }
        if (this.sequenceNum != null) {
            element.setAttribute("SequenceNum", this.sequenceNum);
        }
        if (this.productBuildNum != null) {
            element.setAttribute("ProductBuildNum", this.productBuildNum);
        }
        if (this.packageChecksum != null) {
            element.setAttribute("PackageChecksum", this.packageChecksum);
        }
        if (this.packageCode != null) {
            element.setAttribute("PackageCode", this.packageCode);
        }
        if (this.productCode != null) {
            element.setAttribute("ProductCode", this.productCode);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SecurityFixContentInfo ");
            if (this.clientMoniker != null) {
                strAttrs.append("ClientMoniker=\"").append(AbstractSchema.checkXMLContent(this.clientMoniker)).append("\" ");
            }
            if (this.sequenceNum != null) {
                strAttrs.append("SequenceNum=\"").append(AbstractSchema.checkXMLContent(this.sequenceNum)).append("\" ");
            }
            if (this.productBuildNum != null) {
                strAttrs.append("ProductBuildNum=\"").append(AbstractSchema.checkXMLContent(this.productBuildNum)).append("\" ");
            }
            if (this.packageChecksum != null) {
                strAttrs.append("PackageChecksum=\"").append(AbstractSchema.checkXMLContent(this.packageChecksum)).append("\" ");
            }
            if (this.packageCode != null) {
                strAttrs.append("PackageCode=\"").append(AbstractSchema.checkXMLContent(this.packageCode)).append("\" ");
            }
            if (this.productCode != null) {
                strAttrs.append("ProductCode=\"").append(AbstractSchema.checkXMLContent(this.productCode)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SecurityFixContentInfo>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

