/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SeSyslogSetting
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private String syslogServer;
    private Integer level;
    private Integer failureThreshold;
    private Integer failureInterval;
    private Integer aliveInterval;

    public SeSyslogSetting() {
        this(true);
    }

    public SeSyslogSetting(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "SeSyslogSetting";
    }

    public Boolean getDefEnable() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public String getOptSyslogServer() {
        return this.syslogServer;
    }

    public void setOptSyslogServer(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.syslogServer = value;
    }

    public Integer getDefLevel() {
        return 3;
    }

    public Integer getOptLevel() {
        return this.level;
    }

    public void setOptLevel(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.level = value;
    }

    public Integer getDefFailureThreshold() {
        return 0;
    }

    public Integer getOptFailureThreshold() {
        return this.failureThreshold;
    }

    public void setOptFailureThreshold(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.failureThreshold = value;
    }

    public Integer getDefFailureInterval() {
        return 0;
    }

    public Integer getOptFailureInterval() {
        return this.failureInterval;
    }

    public void setOptFailureInterval(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.failureInterval = value;
    }

    public Integer getDefAliveInterval() {
        return 30;
    }

    public Integer getOptAliveInterval() {
        return this.aliveInterval;
    }

    public void setOptAliveInterval(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.aliveInterval = value;
    }

    @Override
    public int getObjectType() {
        return 808;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("SyslogServer")) != null) {
                this.syslogServer = value;
            }
            if ((value = attris.getValue("Level")) != null) {
                try {
                    this.level = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("SeSyslogSetting/Level: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("SeSyslogSetting/Level: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("FailureThreshold")) != null) {
                try {
                    this.failureThreshold = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("SeSyslogSetting/FailureThreshold: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("SeSyslogSetting/FailureThreshold: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("FailureInterval")) != null) {
                try {
                    this.failureInterval = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("SeSyslogSetting/FailureInterval: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("SeSyslogSetting/FailureInterval: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("AliveInterval")) != null) {
                try {
                    this.aliveInterval = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("SeSyslogSetting/AliveInterval: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("SeSyslogSetting/AliveInterval: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"SeSyslogSetting".equals(element.getNodeName())) {
            throw new ValidationException("SeSyslogSetting: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "SyslogServer")) != null) {
            this.syslogServer = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Level")) != null) {
            try {
                this.level = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("SeSyslogSetting/Level: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "FailureThreshold")) != null) {
            try {
                this.failureThreshold = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("SeSyslogSetting/FailureThreshold: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "FailureInterval")) != null) {
            try {
                this.failureInterval = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("SeSyslogSetting/FailureInterval: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "AliveInterval")) != null) {
            try {
                this.aliveInterval = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("SeSyslogSetting/AliveInterval: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("SeSyslogSetting/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("SeSyslogSetting/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("SeSyslogSetting");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.syslogServer != null) {
            element.setAttribute("SyslogServer", this.syslogServer);
        }
        if (this.level != null) {
            element.setAttribute("Level", this.level.toString());
        }
        if (this.failureThreshold != null) {
            element.setAttribute("FailureThreshold", this.failureThreshold.toString());
        }
        if (this.failureInterval != null) {
            element.setAttribute("FailureInterval", this.failureInterval.toString());
        }
        if (this.aliveInterval != null) {
            element.setAttribute("AliveInterval", this.aliveInterval.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SeSyslogSetting ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.syslogServer != null) {
                strAttrs.append("SyslogServer=\"").append(AbstractSchema.checkXMLContent(this.syslogServer)).append("\" ");
            }
            if (this.level != null) {
                strAttrs.append("Level=\"").append(this.level.toString()).append("\" ");
            }
            if (this.failureThreshold != null) {
                strAttrs.append("FailureThreshold=\"").append(this.failureThreshold.toString()).append("\" ");
            }
            if (this.failureInterval != null) {
                strAttrs.append("FailureInterval=\"").append(this.failureInterval.toString()).append("\" ");
            }
            if (this.aliveInterval != null) {
                strAttrs.append("AliveInterval=\"").append(this.aliveInterval.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SeSyslogSetting>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

