/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.Schedule;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ScanSchedule
extends ConfigObject {
    public static final Integer SCAN_UNTIL_FINISHED = 0;
    public static final Integer SCAN_UPTO = 1;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Boolean retryMissedScan;
    private Integer retryWithinHours;
    private Integer scanTimeWindow;
    private Integer scanUptoSeconds;
    private Boolean randomizeScanStartTime;

    public ScanSchedule() {
        this(true);
    }

    public ScanSchedule(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(83, new ChildGroup(1, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "ScanSchedule";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public Boolean getDefRetryMissedScan() {
        return Boolean.TRUE;
    }

    public Boolean getOptRetryMissedScan() {
        return this.retryMissedScan;
    }

    public void setOptRetryMissedScan(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.retryMissedScan = value;
    }

    public Integer getDefRetryWithinHours() {
        return 8;
    }

    public Integer getOptRetryWithinHours() {
        return this.retryWithinHours;
    }

    public void setOptRetryWithinHours(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.retryWithinHours = value;
    }

    public Integer getDefScanTimeWindow() {
        return SCAN_UNTIL_FINISHED;
    }

    public Integer getOptScanTimeWindow() {
        return this.scanTimeWindow;
    }

    public String getOptScanTimeWindowValue() throws ValidationException {
        if (this.scanTimeWindow == null) {
            return null;
        }
        String s = null;
        switch (this.scanTimeWindow) {
            case 0: {
                s = "SCAN_UNTIL_FINISHED";
                break;
            }
            case 1: {
                s = "SCAN_UPTO";
                break;
            }
            default: {
                throw new ValidationException("ScanSchedule/ScanTimeWindow: invalid attribute value:" + this.scanTimeWindow + "!");
            }
        }
        return s;
    }

    public void setOptScanTimeWindow(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.scanTimeWindow = value;
    }

    public void setOptScanTimeWindowValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.scanTimeWindow = null;
            return;
        }
        if ("SCAN_UNTIL_FINISHED".equals(value)) {
            this.scanTimeWindow = SCAN_UNTIL_FINISHED;
        } else if ("SCAN_UPTO".equals(value)) {
            this.scanTimeWindow = SCAN_UPTO;
        } else {
            throw new ValidationException("ScanSchedule/ScanTimeWindow: invalid attribute value:" + value + "!");
        }
    }

    public Integer getDefScanUptoSeconds() {
        return 7200;
    }

    public Integer getOptScanUptoSeconds() {
        return this.scanUptoSeconds;
    }

    public void setOptScanUptoSeconds(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.scanUptoSeconds = value;
    }

    public Boolean getDefRandomizeScanStartTime() {
        return Boolean.FALSE;
    }

    public Boolean getOptRandomizeScanStartTime() {
        return this.randomizeScanStartTime;
    }

    public void setOptRandomizeScanStartTime(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.randomizeScanStartTime = value;
    }

    public Schedule getSchedule() {
        ChildGroup childGroup = (ChildGroup)this.children.get(83);
        if (childGroup.size() > 0) {
            return (Schedule)childGroup.get(0);
        }
        return null;
    }

    public void setSchedule(Schedule value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            Schedule obj = this.getSchedule();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 674;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.getSchedule() == null) {
            throw new ValidationException("ScanSchedule/Schedule: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof Schedule) {
            try {
                this.setSchedule((Schedule)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("RetryMissedScan")) != null) {
                this.retryMissedScan = "1".equals(value);
            }
            if ((value = attris.getValue("RetryWithinHours")) != null) {
                try {
                    this.retryWithinHours = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("ScanSchedule/RetryWithinHours: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("ScanSchedule/RetryWithinHours: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("ScanTimeWindow")) != null) {
                this.setOptScanTimeWindowValue(value);
            }
            if ((value = attris.getValue("ScanUptoSeconds")) != null) {
                try {
                    this.scanUptoSeconds = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("ScanSchedule/ScanUptoSeconds: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("ScanSchedule/ScanUptoSeconds: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("RandomizeScanStartTime")) != null) {
                this.randomizeScanStartTime = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getSchedule() != null) {
            this.getSchedule().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(83)).size();
        }
        catch (Throwable t) {
            throw new SAXException("ScanSchedule: can't import element == Schedule!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"ScanSchedule".equals(element.getNodeName())) {
            throw new ValidationException("ScanSchedule: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "RetryMissedScan")) != null) {
            this.retryMissedScan = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "RetryWithinHours")) != null) {
            try {
                this.retryWithinHours = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ScanSchedule/RetryWithinHours: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "ScanTimeWindow")) != null) {
            this.setOptScanTimeWindowValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ScanUptoSeconds")) != null) {
            try {
                this.scanUptoSeconds = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ScanSchedule/ScanUptoSeconds: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "RandomizeScanStartTime")) != null) {
            this.randomizeScanStartTime = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "Schedule")).size() != 1) {
            throw new ValidationException("ScanSchedule/Schedule: element is require!");
        }
        Schedule scheduleObj = new Schedule();
        scheduleObj.importFromElement(v.get(0));
        this.setSchedule(scheduleObj);
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("ScanSchedule/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("ScanSchedule/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("ScanSchedule");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.retryMissedScan != null) {
            element.setAttribute("RetryMissedScan", this.retryMissedScan != false ? "1" : "0");
        }
        if (this.retryWithinHours != null) {
            element.setAttribute("RetryWithinHours", this.retryWithinHours.toString());
        }
        if (this.scanTimeWindow != null) {
            element.setAttribute("ScanTimeWindow", this.getOptScanTimeWindowValue());
        }
        if (this.scanUptoSeconds != null) {
            element.setAttribute("ScanUptoSeconds", this.scanUptoSeconds.toString());
        }
        if (this.randomizeScanStartTime != null) {
            element.setAttribute("RandomizeScanStartTime", this.randomizeScanStartTime != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ScanSchedule ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.retryMissedScan != null) {
                strAttrs.append("RetryMissedScan=").append(this.retryMissedScan != false ? "\"1\" " : "\"0\" ");
            }
            if (this.retryWithinHours != null) {
                strAttrs.append("RetryWithinHours=\"").append(this.retryWithinHours.toString()).append("\" ");
            }
            if (this.scanTimeWindow != null) {
                strAttrs.append("ScanTimeWindow=\"").append(this.getOptScanTimeWindowValue()).append("\" ");
            }
            if (this.scanUptoSeconds != null) {
                strAttrs.append("ScanUptoSeconds=\"").append(this.scanUptoSeconds.toString()).append("\" ");
            }
            if (this.randomizeScanStartTime != null) {
                strAttrs.append("RandomizeScanStartTime=").append(this.randomizeScanStartTime != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ScanSchedule>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

