/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.PauseOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ScanProgressOptions
extends ConfigObject {
    public static final Integer DO_NOT_SHOW_PROGRESS = 0;
    public static final Integer SHOW_PROGRESS = 1;
    public static final Integer SHOW_PROGRESS_RISK_DETECTED = 2;
    public static final Integer SHOW_PROGRESS_MEDIUM_HIGH_RISK_DETECTED = 3;
    private static final long serialVersionUID = 1L;
    private Integer progressDisplayOption;
    private Boolean closeProgressWindowWhenDone;
    private Boolean allowUserStopScan;
    private Boolean allowPauseOrDelayScan;

    public ScanProgressOptions() {
        this(true);
    }

    public ScanProgressOptions(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(677, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "ScanProgressOptions";
    }

    public Integer getDefProgressDisplayOption() {
        return DO_NOT_SHOW_PROGRESS;
    }

    public Integer getProgressDisplayOption() {
        return this.progressDisplayOption;
    }

    public String getProgressDisplayOptionValue() throws ValidationException {
        if (this.progressDisplayOption == null) {
            return null;
        }
        String s = null;
        switch (this.progressDisplayOption) {
            case 0: {
                s = "DO_NOT_SHOW_PROGRESS";
                break;
            }
            case 1: {
                s = "SHOW_PROGRESS";
                break;
            }
            case 2: {
                s = "SHOW_PROGRESS_RISK_DETECTED";
                break;
            }
            case 3: {
                s = "SHOW_PROGRESS_MEDIUM_HIGH_RISK_DETECTED";
                break;
            }
            default: {
                throw new ValidationException("ScanProgressOptions/ProgressDisplayOption: invalid attribute value:" + this.progressDisplayOption + "!");
            }
        }
        return s;
    }

    public void setProgressDisplayOption(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.progressDisplayOption = value;
    }

    public void setProgressDisplayOptionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("DO_NOT_SHOW_PROGRESS".equals(value)) {
            this.progressDisplayOption = DO_NOT_SHOW_PROGRESS;
        } else if ("SHOW_PROGRESS".equals(value)) {
            this.progressDisplayOption = SHOW_PROGRESS;
        } else if ("SHOW_PROGRESS_RISK_DETECTED".equals(value)) {
            this.progressDisplayOption = SHOW_PROGRESS_RISK_DETECTED;
        } else if ("SHOW_PROGRESS_MEDIUM_HIGH_RISK_DETECTED".equals(value)) {
            this.progressDisplayOption = SHOW_PROGRESS_MEDIUM_HIGH_RISK_DETECTED;
        } else {
            throw new ValidationException("ScanProgressOptions/ProgressDisplayOption: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefCloseProgressWindowWhenDone() {
        return Boolean.FALSE;
    }

    public Boolean getOptCloseProgressWindowWhenDone() {
        return this.closeProgressWindowWhenDone;
    }

    public void setOptCloseProgressWindowWhenDone(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.closeProgressWindowWhenDone = value;
    }

    public Boolean getDefAllowUserStopScan() {
        return Boolean.FALSE;
    }

    public Boolean getOptAllowUserStopScan() {
        return this.allowUserStopScan;
    }

    public void setOptAllowUserStopScan(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowUserStopScan = value;
    }

    public Boolean getDefAllowPauseOrDelayScan() {
        return Boolean.TRUE;
    }

    public Boolean getOptAllowPauseOrDelayScan() {
        return this.allowPauseOrDelayScan;
    }

    public void setOptAllowPauseOrDelayScan(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowPauseOrDelayScan = value;
    }

    public PauseOptions getOptPauseOptions() {
        ChildGroup childGroup = (ChildGroup)this.children.get(677);
        if (childGroup.size() > 0) {
            return (PauseOptions)childGroup.get(0);
        }
        return null;
    }

    public void setOptPauseOptions(PauseOptions value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            PauseOptions obj = this.getOptPauseOptions();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 676;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.progressDisplayOption == null) {
            throw new ValidationException("ScanProgressOptions/ProgressDisplayOption: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof PauseOptions) {
            try {
                this.setOptPauseOptions((PauseOptions)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("ProgressDisplayOption");
            if (value == null) {
                throw new ValidationException("ScanProgressOptions/ProgressDisplayOption: attribute is required!");
            }
            this.setProgressDisplayOptionValue(value);
            value = attris.getValue("CloseProgressWindowWhenDone");
            if (value != null) {
                this.closeProgressWindowWhenDone = "1".equals(value);
            }
            if ((value = attris.getValue("AllowUserStopScan")) != null) {
                this.allowUserStopScan = "1".equals(value);
            }
            if ((value = attris.getValue("AllowPauseOrDelayScan")) != null) {
                this.allowPauseOrDelayScan = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptPauseOptions() != null) {
            this.getOptPauseOptions().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"ScanProgressOptions".equals(element.getNodeName())) {
            throw new ValidationException("ScanProgressOptions: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "ProgressDisplayOption");
        if (value == null) {
            throw new ValidationException("ScanProgressOptions/ProgressDisplayOption: attribute is required!");
        }
        this.setProgressDisplayOptionValue(value);
        value = XMLHelper.getAttribute(element, "CloseProgressWindowWhenDone");
        if (value != null) {
            this.closeProgressWindowWhenDone = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AllowUserStopScan")) != null) {
            this.allowUserStopScan = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AllowPauseOrDelayScan")) != null) {
            this.allowPauseOrDelayScan = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "PauseOptions")).size() > 0) {
            PauseOptions pauseOptionsObj = new PauseOptions();
            pauseOptionsObj.importFromElement(v.get(0));
            this.setOptPauseOptions(pauseOptionsObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("ScanProgressOptions/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("ScanProgressOptions/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("ScanProgressOptions");
        if (this.progressDisplayOption != null) {
            element.setAttribute("ProgressDisplayOption", this.getProgressDisplayOptionValue());
        }
        if (this.closeProgressWindowWhenDone != null) {
            element.setAttribute("CloseProgressWindowWhenDone", this.closeProgressWindowWhenDone != false ? "1" : "0");
        }
        if (this.allowUserStopScan != null) {
            element.setAttribute("AllowUserStopScan", this.allowUserStopScan != false ? "1" : "0");
        }
        if (this.allowPauseOrDelayScan != null) {
            element.setAttribute("AllowPauseOrDelayScan", this.allowPauseOrDelayScan != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ScanProgressOptions ");
            if (this.progressDisplayOption != null) {
                strAttrs.append("ProgressDisplayOption=\"").append(this.getProgressDisplayOptionValue()).append("\" ");
            }
            if (this.closeProgressWindowWhenDone != null) {
                strAttrs.append("CloseProgressWindowWhenDone=").append(this.closeProgressWindowWhenDone != false ? "\"1\" " : "\"0\" ");
            }
            if (this.allowUserStopScan != null) {
                strAttrs.append("AllowUserStopScan=").append(this.allowUserStopScan != false ? "\"1\" " : "\"0\" ");
            }
            if (this.allowPauseOrDelayScan != null) {
                strAttrs.append("AllowPauseOrDelayScan=").append(this.allowPauseOrDelayScan != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ScanProgressOptions>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

