/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ScanLess
extends ConfigObject {
    public static final Integer ADMIN = 0;
    public static final Integer USER = 1;
    public static final Integer SYMANTEC_AND_COMMUNITY_TRUSTED = 0;
    public static final Integer SYMANTEC_TRUSTED_ONLY = 1;
    private static final long serialVersionUID = 1L;
    private Boolean enabledScanLess;
    private Boolean lockEnabledScanless;
    private Integer applyModeEnabledScanless;
    private Integer trustedSign;

    public ScanLess() {
        this(true);
    }

    public ScanLess(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "ScanLess";
    }

    public Boolean getDefEnabledScanLess() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnabledScanLess() {
        return this.enabledScanLess;
    }

    public void setOptEnabledScanLess(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enabledScanLess = value;
    }

    public Boolean getDefLockEnabledScanless() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockEnabledScanless() {
        return this.lockEnabledScanless;
    }

    public void setOptLockEnabledScanless(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockEnabledScanless = value;
    }

    public Integer getDefApplyModeEnabledScanless() {
        return ADMIN;
    }

    public Integer getOptApplyModeEnabledScanless() {
        return this.applyModeEnabledScanless;
    }

    public String getOptApplyModeEnabledScanlessValue() throws ValidationException {
        if (this.applyModeEnabledScanless == null) {
            return null;
        }
        String s = null;
        switch (this.applyModeEnabledScanless) {
            case 0: {
                s = "ADMIN";
                break;
            }
            case 1: {
                s = "USER";
                break;
            }
            default: {
                throw new ValidationException("ScanLess/ApplyModeEnabledScanless: invalid attribute value:" + this.applyModeEnabledScanless + "!");
            }
        }
        return s;
    }

    public void setOptApplyModeEnabledScanless(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.applyModeEnabledScanless = value;
    }

    public void setOptApplyModeEnabledScanlessValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.applyModeEnabledScanless = null;
            return;
        }
        if ("ADMIN".equals(value)) {
            this.applyModeEnabledScanless = ADMIN;
        } else if ("USER".equals(value)) {
            this.applyModeEnabledScanless = USER;
        } else {
            throw new ValidationException("ScanLess/ApplyModeEnabledScanless: invalid attribute value:" + value + "!");
        }
    }

    public Integer getDefTrustedSign() {
        return SYMANTEC_TRUSTED_ONLY;
    }

    public Integer getTrustedSign() {
        return this.trustedSign;
    }

    public String getTrustedSignValue() throws ValidationException {
        if (this.trustedSign == null) {
            return null;
        }
        String s = null;
        switch (this.trustedSign) {
            case 0: {
                s = "SYMANTEC_AND_COMMUNITY_TRUSTED";
                break;
            }
            case 1: {
                s = "SYMANTEC_TRUSTED_ONLY";
                break;
            }
            default: {
                throw new ValidationException("ScanLess/TrustedSign: invalid attribute value:" + this.trustedSign + "!");
            }
        }
        return s;
    }

    public void setTrustedSign(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.trustedSign = value;
    }

    public void setTrustedSignValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("SYMANTEC_AND_COMMUNITY_TRUSTED".equals(value)) {
            this.trustedSign = SYMANTEC_AND_COMMUNITY_TRUSTED;
        } else if ("SYMANTEC_TRUSTED_ONLY".equals(value)) {
            this.trustedSign = SYMANTEC_TRUSTED_ONLY;
        } else {
            throw new ValidationException("ScanLess/TrustedSign: invalid attribute value:" + value + "!");
        }
    }

    @Override
    public int getObjectType() {
        return 666;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.trustedSign == null) {
            throw new ValidationException("ScanLess/TrustedSign: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("EnabledScanLess");
            if (value != null) {
                this.enabledScanLess = "1".equals(value);
            }
            if ((value = attris.getValue("LockEnabledScanless")) != null) {
                this.lockEnabledScanless = "1".equals(value);
            }
            if ((value = attris.getValue("ApplyModeEnabledScanless")) != null) {
                this.setOptApplyModeEnabledScanlessValue(value);
            }
            if ((value = attris.getValue("TrustedSign")) == null) {
                throw new ValidationException("ScanLess/TrustedSign: attribute is required!");
            }
            this.setTrustedSignValue(value);
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"ScanLess".equals(element.getNodeName())) {
            throw new ValidationException("ScanLess: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "EnabledScanLess");
        if (value != null) {
            this.enabledScanLess = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockEnabledScanless")) != null) {
            this.lockEnabledScanless = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ApplyModeEnabledScanless")) != null) {
            this.setOptApplyModeEnabledScanlessValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "TrustedSign")) == null) {
            throw new ValidationException("ScanLess/TrustedSign: attribute is required!");
        }
        this.setTrustedSignValue(value);
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("ScanLess/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("ScanLess/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("ScanLess");
        if (this.enabledScanLess != null) {
            element.setAttribute("EnabledScanLess", this.enabledScanLess != false ? "1" : "0");
        }
        if (this.lockEnabledScanless != null) {
            element.setAttribute("LockEnabledScanless", this.lockEnabledScanless != false ? "1" : "0");
        }
        if (this.applyModeEnabledScanless != null) {
            element.setAttribute("ApplyModeEnabledScanless", this.getOptApplyModeEnabledScanlessValue());
        }
        if (this.trustedSign != null) {
            element.setAttribute("TrustedSign", this.getTrustedSignValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ScanLess ");
            if (this.enabledScanLess != null) {
                strAttrs.append("EnabledScanLess=").append(this.enabledScanLess != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lockEnabledScanless != null) {
                strAttrs.append("LockEnabledScanless=").append(this.lockEnabledScanless != false ? "\"1\" " : "\"0\" ");
            }
            if (this.applyModeEnabledScanless != null) {
                strAttrs.append("ApplyModeEnabledScanless=\"").append(this.getOptApplyModeEnabledScanlessValue()).append("\" ");
            }
            if (this.trustedSign != null) {
                strAttrs.append("TrustedSign=\"").append(this.getTrustedSignValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ScanLess>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

