/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RiskTracer
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Boolean lockRiskTracerOptions;
    private Boolean resolveSourceIPAddr;
    private Boolean pollForNetworkSession;
    private Long pollNetworkEveryMilliSec;
    private Boolean fWAutoBlockSourceIPAddr;

    public RiskTracer() {
        this(true);
    }

    public RiskTracer(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "RiskTracer";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public Boolean getDefLockRiskTracerOptions() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockRiskTracerOptions() {
        return this.lockRiskTracerOptions;
    }

    public void setOptLockRiskTracerOptions(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lockRiskTracerOptions = value;
    }

    public Boolean getDefResolveSourceIPAddr() {
        return Boolean.TRUE;
    }

    public Boolean getOptResolveSourceIPAddr() {
        return this.resolveSourceIPAddr;
    }

    public void setOptResolveSourceIPAddr(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.resolveSourceIPAddr = value;
    }

    public Boolean getDefPollForNetworkSession() {
        return Boolean.TRUE;
    }

    public Boolean getOptPollForNetworkSession() {
        return this.pollForNetworkSession;
    }

    public void setOptPollForNetworkSession(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.pollForNetworkSession = value;
    }

    public Long getDefPollNetworkEveryMilliSec() {
        return 1000L;
    }

    public Long getOptPollNetworkEveryMilliSec() {
        return this.pollNetworkEveryMilliSec;
    }

    public void setOptPollNetworkEveryMilliSec(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.pollNetworkEveryMilliSec = value;
    }

    public Boolean getDefFWAutoBlockSourceIPAddr() {
        return Boolean.TRUE;
    }

    public Boolean getOptFWAutoBlockSourceIPAddr() {
        return this.fWAutoBlockSourceIPAddr;
    }

    public void setOptFWAutoBlockSourceIPAddr(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.fWAutoBlockSourceIPAddr = value;
    }

    @Override
    public int getObjectType() {
        return 624;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("LockRiskTracerOptions")) != null) {
                this.lockRiskTracerOptions = "1".equals(value);
            }
            if ((value = attris.getValue("ResolveSourceIPAddr")) != null) {
                this.resolveSourceIPAddr = "1".equals(value);
            }
            if ((value = attris.getValue("PollForNetworkSession")) != null) {
                this.pollForNetworkSession = "1".equals(value);
            }
            if ((value = attris.getValue("PollNetworkEveryMilliSec")) != null) {
                try {
                    this.pollNetworkEveryMilliSec = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("RiskTracer/PollNetworkEveryMilliSec: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("RiskTracer/PollNetworkEveryMilliSec: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("FWAutoBlockSourceIPAddr")) != null) {
                this.fWAutoBlockSourceIPAddr = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"RiskTracer".equals(element.getNodeName())) {
            throw new ValidationException("RiskTracer: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockRiskTracerOptions")) != null) {
            this.lockRiskTracerOptions = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ResolveSourceIPAddr")) != null) {
            this.resolveSourceIPAddr = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "PollForNetworkSession")) != null) {
            this.pollForNetworkSession = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "PollNetworkEveryMilliSec")) != null) {
            try {
                this.pollNetworkEveryMilliSec = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("RiskTracer/PollNetworkEveryMilliSec: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "FWAutoBlockSourceIPAddr")) != null) {
            this.fWAutoBlockSourceIPAddr = "1".equals(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("RiskTracer/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("RiskTracer/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("RiskTracer");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.lockRiskTracerOptions != null) {
            element.setAttribute("LockRiskTracerOptions", this.lockRiskTracerOptions != false ? "1" : "0");
        }
        if (this.resolveSourceIPAddr != null) {
            element.setAttribute("ResolveSourceIPAddr", this.resolveSourceIPAddr != false ? "1" : "0");
        }
        if (this.pollForNetworkSession != null) {
            element.setAttribute("PollForNetworkSession", this.pollForNetworkSession != false ? "1" : "0");
        }
        if (this.pollNetworkEveryMilliSec != null) {
            element.setAttribute("PollNetworkEveryMilliSec", this.pollNetworkEveryMilliSec.toString());
        }
        if (this.fWAutoBlockSourceIPAddr != null) {
            element.setAttribute("FWAutoBlockSourceIPAddr", this.fWAutoBlockSourceIPAddr != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<RiskTracer ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lockRiskTracerOptions != null) {
                strAttrs.append("LockRiskTracerOptions=").append(this.lockRiskTracerOptions != false ? "\"1\" " : "\"0\" ");
            }
            if (this.resolveSourceIPAddr != null) {
                strAttrs.append("ResolveSourceIPAddr=").append(this.resolveSourceIPAddr != false ? "\"1\" " : "\"0\" ");
            }
            if (this.pollForNetworkSession != null) {
                strAttrs.append("PollForNetworkSession=").append(this.pollForNetworkSession != false ? "\"1\" " : "\"0\" ");
            }
            if (this.pollNetworkEveryMilliSec != null) {
                strAttrs.append("PollNetworkEveryMilliSec=\"").append(this.pollNetworkEveryMilliSec.toString()).append("\" ");
            }
            if (this.fWAutoBlockSourceIPAddr != null) {
                strAttrs.append("FWAutoBlockSourceIPAddr=").append(this.fWAutoBlockSourceIPAddr != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</RiskTracer>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

