/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReplicationState
extends ConfigObject {
    public static final Integer OK = 0;
    public static final Integer FAILED_TO_CONNECT = 1;
    public static final Integer FAILED_TO_AUTHENTIC = 2;
    public static final Integer FAILED_TO_DOWNLOAD = 3;
    public static final Integer FAILED_TO_PROCESS = 4;
    public static final Integer FAILED_TO_SUBMIT = 5;
    public static final Integer DB_VERSION_NO_MATCH = 6;
    public static final Integer CANCELED = 6;
    public static final Integer IDLE = 0;
    public static final Integer REP_CONNECTING = 1;
    public static final Integer REP_AUTHENTICATING = 2;
    public static final Integer REP_DOWNLOADING = 3;
    public static final Integer REP_PROCESSING = 4;
    public static final Integer REP_SUBMITING = 5;
    public static final Integer BUSY = 1;
    private static final long serialVersionUID = 1L;
    private Long lastReplicationAttempTime;
    private Integer lastReplicationResult;
    private Integer replicatorClientStatus;
    private Integer replicatorClientProgress;
    private String replicatorClientSourceSiteId;
    private String replicatorClientSourceSiteName;
    private String replicatorClientSourceSiteServerIp;
    private Integer replicatorListenerStatus;
    private String replicatorListenerClientSiteId;
    private String replicatorListenerClientSiteName;
    private String replicatorListenerClientIp;

    public ReplicationState() {
        this(true);
    }

    public ReplicationState(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "ReplicationState";
    }

    public Long getOptLastReplicationAttempTime() {
        return this.lastReplicationAttempTime;
    }

    public void setOptLastReplicationAttempTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lastReplicationAttempTime = value;
    }

    public Integer getOptLastReplicationResult() {
        return this.lastReplicationResult;
    }

    public String getOptLastReplicationResultValue() throws ValidationException {
        if (this.lastReplicationResult == null) {
            return null;
        }
        String s = null;
        switch (this.lastReplicationResult) {
            case 0: {
                s = "OK";
                break;
            }
            case 1: {
                s = "FAILED_TO_CONNECT";
                break;
            }
            case 2: {
                s = "FAILED_TO_AUTHENTIC";
                break;
            }
            case 3: {
                s = "FAILED_TO_DOWNLOAD";
                break;
            }
            case 4: {
                s = "FAILED_TO_PROCESS";
                break;
            }
            case 5: {
                s = "FAILED_TO_SUBMIT";
                break;
            }
            case 6: {
                s = "DB_VERSION_NO_MATCH";
                break;
            }
            case 7: {
                s = "CANCELED";
                break;
            }
            default: {
                throw new ValidationException("ReplicationState/LastReplicationResult: invalid attribute value:" + this.lastReplicationResult + "!");
            }
        }
        return s;
    }

    public void setOptLastReplicationResult(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lastReplicationResult = value;
    }

    public void setOptLastReplicationResultValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.lastReplicationResult = null;
            return;
        }
        if ("OK".equals(value)) {
            this.lastReplicationResult = OK;
        } else if ("FAILED_TO_CONNECT".equals(value)) {
            this.lastReplicationResult = FAILED_TO_CONNECT;
        } else if ("FAILED_TO_AUTHENTIC".equals(value)) {
            this.lastReplicationResult = FAILED_TO_AUTHENTIC;
        } else if ("FAILED_TO_DOWNLOAD".equals(value)) {
            this.lastReplicationResult = FAILED_TO_DOWNLOAD;
        } else if ("FAILED_TO_PROCESS".equals(value)) {
            this.lastReplicationResult = FAILED_TO_PROCESS;
        } else if ("FAILED_TO_SUBMIT".equals(value)) {
            this.lastReplicationResult = FAILED_TO_SUBMIT;
        } else if ("DB_VERSION_NO_MATCH".equals(value)) {
            this.lastReplicationResult = DB_VERSION_NO_MATCH;
        } else if ("CANCELED".equals(value)) {
            this.lastReplicationResult = CANCELED;
        } else {
            throw new ValidationException("ReplicationState/LastReplicationResult: invalid attribute value:" + value + "!");
        }
    }

    public Integer getOptReplicatorClientStatus() {
        return this.replicatorClientStatus;
    }

    public String getOptReplicatorClientStatusValue() throws ValidationException {
        if (this.replicatorClientStatus == null) {
            return null;
        }
        String s = null;
        switch (this.replicatorClientStatus) {
            case 0: {
                s = "IDLE";
                break;
            }
            case 1: {
                s = "REP_CONNECTING";
                break;
            }
            case 2: {
                s = "REP_AUTHENTICATING";
                break;
            }
            case 3: {
                s = "REP_DOWNLOADING";
                break;
            }
            case 4: {
                s = "REP_PROCESSING";
                break;
            }
            case 5: {
                s = "REP_SUBMITING";
                break;
            }
            case 6: {
                s = "CANCELED";
                break;
            }
            default: {
                throw new ValidationException("ReplicationState/ReplicatorClientStatus: invalid attribute value:" + this.replicatorClientStatus + "!");
            }
        }
        return s;
    }

    public void setOptReplicatorClientStatus(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.replicatorClientStatus = value;
    }

    public void setOptReplicatorClientStatusValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.replicatorClientStatus = null;
            return;
        }
        if ("IDLE".equals(value)) {
            this.replicatorClientStatus = IDLE;
        } else if ("REP_CONNECTING".equals(value)) {
            this.replicatorClientStatus = REP_CONNECTING;
        } else if ("REP_AUTHENTICATING".equals(value)) {
            this.replicatorClientStatus = REP_AUTHENTICATING;
        } else if ("REP_DOWNLOADING".equals(value)) {
            this.replicatorClientStatus = REP_DOWNLOADING;
        } else if ("REP_PROCESSING".equals(value)) {
            this.replicatorClientStatus = REP_PROCESSING;
        } else if ("REP_SUBMITING".equals(value)) {
            this.replicatorClientStatus = REP_SUBMITING;
        } else if ("CANCELED".equals(value)) {
            this.replicatorClientStatus = CANCELED;
        } else {
            throw new ValidationException("ReplicationState/ReplicatorClientStatus: invalid attribute value:" + value + "!");
        }
    }

    public Integer getOptReplicatorClientProgress() {
        return this.replicatorClientProgress;
    }

    public void setOptReplicatorClientProgress(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.replicatorClientProgress = value;
    }

    public String getOptReplicatorClientSourceSiteId() {
        return this.replicatorClientSourceSiteId;
    }

    public void setOptReplicatorClientSourceSiteId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.replicatorClientSourceSiteId = value;
    }

    public String getOptReplicatorClientSourceSiteName() {
        return this.replicatorClientSourceSiteName;
    }

    public void setOptReplicatorClientSourceSiteName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.replicatorClientSourceSiteName = value;
    }

    public String getReplicatorClientSourceSiteServerIp() {
        return this.replicatorClientSourceSiteServerIp;
    }

    public void setReplicatorClientSourceSiteServerIp(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.replicatorClientSourceSiteServerIp = value;
    }

    public Integer getOptReplicatorListenerStatus() {
        return this.replicatorListenerStatus;
    }

    public String getOptReplicatorListenerStatusValue() throws ValidationException {
        if (this.replicatorListenerStatus == null) {
            return null;
        }
        String s = null;
        switch (this.replicatorListenerStatus) {
            case 0: {
                s = "IDLE";
                break;
            }
            case 1: {
                s = "BUSY";
                break;
            }
            default: {
                throw new ValidationException("ReplicationState/ReplicatorListenerStatus: invalid attribute value:" + this.replicatorListenerStatus + "!");
            }
        }
        return s;
    }

    public void setOptReplicatorListenerStatus(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.replicatorListenerStatus = value;
    }

    public void setOptReplicatorListenerStatusValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.replicatorListenerStatus = null;
            return;
        }
        if ("IDLE".equals(value)) {
            this.replicatorListenerStatus = IDLE;
        } else if ("BUSY".equals(value)) {
            this.replicatorListenerStatus = BUSY;
        } else {
            throw new ValidationException("ReplicationState/ReplicatorListenerStatus: invalid attribute value:" + value + "!");
        }
    }

    public String getOptReplicatorListenerClientSiteId() {
        return this.replicatorListenerClientSiteId;
    }

    public void setOptReplicatorListenerClientSiteId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.replicatorListenerClientSiteId = value;
    }

    public String getOptReplicatorListenerClientSiteName() {
        return this.replicatorListenerClientSiteName;
    }

    public void setOptReplicatorListenerClientSiteName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.replicatorListenerClientSiteName = value;
    }

    public String getOptReplicatorListenerClientIp() {
        return this.replicatorListenerClientIp;
    }

    public void setOptReplicatorListenerClientIp(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.replicatorListenerClientIp = value;
    }

    @Override
    public int getObjectType() {
        return 195;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.replicatorClientSourceSiteServerIp == null) {
            throw new ValidationException("ReplicationState/ReplicatorClientSourceSiteServerIp: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("LastReplicationAttempTime");
            if (value != null) {
                try {
                    this.lastReplicationAttempTime = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("ReplicationState/LastReplicationAttempTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("ReplicationState/LastReplicationAttempTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("LastReplicationResult")) != null) {
                this.setOptLastReplicationResultValue(value);
            }
            if ((value = attris.getValue("ReplicatorClientStatus")) != null) {
                this.setOptReplicatorClientStatusValue(value);
            }
            if ((value = attris.getValue("ReplicatorClientProgress")) != null) {
                try {
                    this.replicatorClientProgress = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("ReplicationState/ReplicatorClientProgress: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("ReplicationState/ReplicatorClientProgress: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("ReplicatorClientSourceSiteId")) != null) {
                this.replicatorClientSourceSiteId = value;
            }
            if ((value = attris.getValue("ReplicatorClientSourceSiteName")) != null) {
                this.replicatorClientSourceSiteName = value;
            }
            if ((value = attris.getValue("ReplicatorClientSourceSiteServerIp")) == null) {
                throw new ValidationException("ReplicationState/ReplicatorClientSourceSiteServerIp: attribute is required!");
            }
            this.replicatorClientSourceSiteServerIp = value;
            value = attris.getValue("ReplicatorListenerStatus");
            if (value != null) {
                this.setOptReplicatorListenerStatusValue(value);
            }
            if ((value = attris.getValue("ReplicatorListenerClientSiteId")) != null) {
                this.replicatorListenerClientSiteId = value;
            }
            if ((value = attris.getValue("ReplicatorListenerClientSiteName")) != null) {
                this.replicatorListenerClientSiteName = value;
            }
            if ((value = attris.getValue("ReplicatorListenerClientIp")) != null) {
                this.replicatorListenerClientIp = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"ReplicationState".equals(element.getNodeName())) {
            throw new ValidationException("ReplicationState: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "LastReplicationAttempTime");
        if (value != null) {
            try {
                this.lastReplicationAttempTime = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ReplicationState/LastReplicationAttempTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "LastReplicationResult")) != null) {
            this.setOptLastReplicationResultValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ReplicatorClientStatus")) != null) {
            this.setOptReplicatorClientStatusValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ReplicatorClientProgress")) != null) {
            try {
                this.replicatorClientProgress = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ReplicationState/ReplicatorClientProgress: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "ReplicatorClientSourceSiteId")) != null) {
            this.replicatorClientSourceSiteId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ReplicatorClientSourceSiteName")) != null) {
            this.replicatorClientSourceSiteName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ReplicatorClientSourceSiteServerIp")) == null) {
            throw new ValidationException("ReplicationState/ReplicatorClientSourceSiteServerIp: attribute is required!");
        }
        this.replicatorClientSourceSiteServerIp = value;
        value = XMLHelper.getAttribute(element, "ReplicatorListenerStatus");
        if (value != null) {
            this.setOptReplicatorListenerStatusValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ReplicatorListenerClientSiteId")) != null) {
            this.replicatorListenerClientSiteId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ReplicatorListenerClientSiteName")) != null) {
            this.replicatorListenerClientSiteName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ReplicatorListenerClientIp")) != null) {
            this.replicatorListenerClientIp = value;
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("ReplicationState/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("ReplicationState/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("ReplicationState");
        if (this.lastReplicationAttempTime != null) {
            element.setAttribute("LastReplicationAttempTime", this.lastReplicationAttempTime.toString());
        }
        if (this.lastReplicationResult != null) {
            element.setAttribute("LastReplicationResult", this.getOptLastReplicationResultValue());
        }
        if (this.replicatorClientStatus != null) {
            element.setAttribute("ReplicatorClientStatus", this.getOptReplicatorClientStatusValue());
        }
        if (this.replicatorClientProgress != null) {
            element.setAttribute("ReplicatorClientProgress", this.replicatorClientProgress.toString());
        }
        if (this.replicatorClientSourceSiteId != null) {
            element.setAttribute("ReplicatorClientSourceSiteId", this.replicatorClientSourceSiteId);
        }
        if (this.replicatorClientSourceSiteName != null) {
            element.setAttribute("ReplicatorClientSourceSiteName", this.replicatorClientSourceSiteName);
        }
        if (this.replicatorClientSourceSiteServerIp != null) {
            element.setAttribute("ReplicatorClientSourceSiteServerIp", this.replicatorClientSourceSiteServerIp);
        }
        if (this.replicatorListenerStatus != null) {
            element.setAttribute("ReplicatorListenerStatus", this.getOptReplicatorListenerStatusValue());
        }
        if (this.replicatorListenerClientSiteId != null) {
            element.setAttribute("ReplicatorListenerClientSiteId", this.replicatorListenerClientSiteId);
        }
        if (this.replicatorListenerClientSiteName != null) {
            element.setAttribute("ReplicatorListenerClientSiteName", this.replicatorListenerClientSiteName);
        }
        if (this.replicatorListenerClientIp != null) {
            element.setAttribute("ReplicatorListenerClientIp", this.replicatorListenerClientIp);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ReplicationState ");
            if (this.lastReplicationAttempTime != null) {
                strAttrs.append("LastReplicationAttempTime=\"").append(this.lastReplicationAttempTime.toString()).append("\" ");
            }
            if (this.lastReplicationResult != null) {
                strAttrs.append("LastReplicationResult=\"").append(this.getOptLastReplicationResultValue()).append("\" ");
            }
            if (this.replicatorClientStatus != null) {
                strAttrs.append("ReplicatorClientStatus=\"").append(this.getOptReplicatorClientStatusValue()).append("\" ");
            }
            if (this.replicatorClientProgress != null) {
                strAttrs.append("ReplicatorClientProgress=\"").append(this.replicatorClientProgress.toString()).append("\" ");
            }
            if (this.replicatorClientSourceSiteId != null) {
                strAttrs.append("ReplicatorClientSourceSiteId=\"").append(AbstractSchema.checkXMLContent(this.replicatorClientSourceSiteId)).append("\" ");
            }
            if (this.replicatorClientSourceSiteName != null) {
                strAttrs.append("ReplicatorClientSourceSiteName=\"").append(AbstractSchema.checkXMLContent(this.replicatorClientSourceSiteName)).append("\" ");
            }
            if (this.replicatorClientSourceSiteServerIp != null) {
                strAttrs.append("ReplicatorClientSourceSiteServerIp=\"").append(AbstractSchema.checkXMLContent(this.replicatorClientSourceSiteServerIp)).append("\" ");
            }
            if (this.replicatorListenerStatus != null) {
                strAttrs.append("ReplicatorListenerStatus=\"").append(this.getOptReplicatorListenerStatusValue()).append("\" ");
            }
            if (this.replicatorListenerClientSiteId != null) {
                strAttrs.append("ReplicatorListenerClientSiteId=\"").append(AbstractSchema.checkXMLContent(this.replicatorListenerClientSiteId)).append("\" ");
            }
            if (this.replicatorListenerClientSiteName != null) {
                strAttrs.append("ReplicatorListenerClientSiteName=\"").append(AbstractSchema.checkXMLContent(this.replicatorListenerClientSiteName)).append("\" ");
            }
            if (this.replicatorListenerClientIp != null) {
                strAttrs.append("ReplicatorListenerClientIp=\"").append(AbstractSchema.checkXMLContent(this.replicatorListenerClientIp)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ReplicationState>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

