/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.PartnerState;
import com.sygate.scm.common.configobject.schema.ReplicationContent;
import com.sygate.scm.common.configobject.schema.Schedule;
import com.sygate.scm.common.configobject.schema.SiteContactArray;
import com.sygate.scm.util.Utility;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReplicationPartnership
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private String partnerSiteName;
    private String sourceSiteDescription;
    private String password;
    private Boolean disableHostnameValidation;

    public ReplicationPartnership() {
        this(true);
    }

    public ReplicationPartnership(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(81, new ChildGroup(1, 1));
        this.children.put(83, new ChildGroup(0, 1));
        this.children.put(91, new ChildGroup(0, 1));
        this.children.put(70, new ChildGroup(1, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "ReplicationPartnership";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public String getPartnerSiteName() {
        return this.partnerSiteName;
    }

    public void setPartnerSiteName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.partnerSiteName = value;
    }

    public String getOptSourceSiteDescription() {
        return this.sourceSiteDescription;
    }

    public void setOptSourceSiteDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.sourceSiteDescription = value;
    }

    public String getPassword() {
        try {
            return Utility.decrypt(this.password);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setPassword(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        try {
            this.password = Utility.encrypt(value);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Boolean getDefDisableHostnameValidation() {
        return Boolean.FALSE;
    }

    public Boolean getOptDisableHostnameValidation() {
        return this.disableHostnameValidation;
    }

    public void setOptDisableHostnameValidation(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.disableHostnameValidation = value;
    }

    public SiteContactArray getSiteContactArray() {
        ChildGroup childGroup = (ChildGroup)this.children.get(81);
        if (childGroup.size() > 0) {
            return (SiteContactArray)childGroup.get(0);
        }
        return null;
    }

    public void setSiteContactArray(SiteContactArray value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            SiteContactArray obj = this.getSiteContactArray();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public Schedule getOptSchedule() {
        ChildGroup childGroup = (ChildGroup)this.children.get(83);
        if (childGroup.size() > 0) {
            return (Schedule)childGroup.get(0);
        }
        return null;
    }

    public void setOptSchedule(Schedule value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            Schedule obj = this.getOptSchedule();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public ReplicationContent getOptReplicationContent() {
        ChildGroup childGroup = (ChildGroup)this.children.get(91);
        if (childGroup.size() > 0) {
            return (ReplicationContent)childGroup.get(0);
        }
        return null;
    }

    public void setOptReplicationContent(ReplicationContent value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ReplicationContent obj = this.getOptReplicationContent();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public PartnerState getPartnerState() {
        ChildGroup childGroup = (ChildGroup)this.children.get(70);
        if (childGroup.size() > 0) {
            return (PartnerState)childGroup.get(0);
        }
        return null;
    }

    public void setPartnerState(PartnerState value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            PartnerState obj = this.getPartnerState();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 69;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.partnerSiteName == null) {
            throw new ValidationException("ReplicationPartnership/PartnerSiteName: attribute is required!");
        }
        if (this.password == null) {
            throw new ValidationException("ReplicationPartnership/Password: attribute is required!");
        }
        if (this.getSiteContactArray() == null) {
            throw new ValidationException("ReplicationPartnership/SiteContactArray: attribute is required!");
        }
        if (this.getPartnerState() == null) {
            throw new ValidationException("ReplicationPartnership/PartnerState: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof SiteContactArray) {
            try {
                this.setSiteContactArray((SiteContactArray)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof Schedule) {
            try {
                this.setOptSchedule((Schedule)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof ReplicationContent) {
            try {
                this.setOptReplicationContent((ReplicationContent)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof PartnerState) {
            try {
                this.setPartnerState((PartnerState)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("PartnerSiteName")) == null) {
                throw new ValidationException("ReplicationPartnership/PartnerSiteName: attribute is required!");
            }
            this.partnerSiteName = value;
            value = attris.getValue("SourceSiteDescription");
            if (value != null) {
                this.sourceSiteDescription = value;
            }
            if ((value = attris.getValue("Password")) == null) {
                throw new ValidationException("ReplicationPartnership/Password: attribute is required!");
            }
            this.password = value;
            value = attris.getValue("DisableHostnameValidation");
            if (value != null) {
                this.disableHostnameValidation = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getSiteContactArray() != null) {
            this.getSiteContactArray().setReadonly();
        }
        if (this.getOptSchedule() != null) {
            this.getOptSchedule().setReadonly();
        }
        if (this.getOptReplicationContent() != null) {
            this.getOptReplicationContent().setReadonly();
        }
        if (this.getPartnerState() != null) {
            this.getPartnerState().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(81)).size();
        }
        catch (Throwable t) {
            throw new SAXException("ReplicationPartnership: can't import element == SiteContactArray!");
        }
        try {
            ((ChildGroup)this.children.get(70)).size();
        }
        catch (Throwable t) {
            throw new SAXException("ReplicationPartnership: can't import element == PartnerState!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"ReplicationPartnership".equals(element.getNodeName())) {
            throw new ValidationException("ReplicationPartnership: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "PartnerSiteName")) == null) {
            throw new ValidationException("ReplicationPartnership/PartnerSiteName: attribute is required!");
        }
        this.partnerSiteName = value;
        value = XMLHelper.getAttribute(element, "SourceSiteDescription");
        if (value != null) {
            this.sourceSiteDescription = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Password")) == null) {
            throw new ValidationException("ReplicationPartnership/Password: attribute is required!");
        }
        this.password = value;
        value = XMLHelper.getAttribute(element, "DisableHostnameValidation");
        if (value != null) {
            this.disableHostnameValidation = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "SiteContactArray")).size() != 1) {
            throw new ValidationException("ReplicationPartnership/SiteContactArray: element is require!");
        }
        SiteContactArray siteContactArrayObj = new SiteContactArray();
        siteContactArrayObj.importFromElement(v.get(0));
        this.setSiteContactArray(siteContactArrayObj);
        v = XMLHelper.getChildElementByName(element, "Schedule");
        if (v.size() > 0) {
            Schedule scheduleObj = new Schedule();
            scheduleObj.importFromElement(v.get(0));
            this.setOptSchedule(scheduleObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "ReplicationContent")).size() > 0) {
            ReplicationContent replicationContentObj = new ReplicationContent();
            replicationContentObj.importFromElement(v.get(0));
            this.setOptReplicationContent(replicationContentObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "PartnerState")).size() != 1) {
            throw new ValidationException("ReplicationPartnership/PartnerState: element is require!");
        }
        PartnerState partnerStateObj = new PartnerState();
        partnerStateObj.importFromElement(v.get(0));
        this.setPartnerState(partnerStateObj);
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("ReplicationPartnership/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("ReplicationPartnership/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("ReplicationPartnership");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.partnerSiteName != null) {
            element.setAttribute("PartnerSiteName", this.partnerSiteName);
        }
        if (this.sourceSiteDescription != null) {
            element.setAttribute("SourceSiteDescription", this.sourceSiteDescription);
        }
        if (this.password != null) {
            element.setAttribute("Password", this.password);
        }
        if (this.disableHostnameValidation != null) {
            element.setAttribute("DisableHostnameValidation", this.disableHostnameValidation != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ReplicationPartnership ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.partnerSiteName != null) {
                strAttrs.append("PartnerSiteName=\"").append(AbstractSchema.checkXMLContent(this.partnerSiteName)).append("\" ");
            }
            if (this.sourceSiteDescription != null) {
                strAttrs.append("SourceSiteDescription=\"").append(AbstractSchema.checkXMLContent(this.sourceSiteDescription)).append("\" ");
            }
            if (this.password != null) {
                strAttrs.append("Password=\"").append(AbstractSchema.checkXMLContent(this.password)).append("\" ");
            }
            if (this.disableHostnameValidation != null) {
                strAttrs.append("DisableHostnameValidation=").append(this.disableHostnameValidation != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ReplicationPartnership>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

