/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.RegistryData;
import com.sygate.scm.common.configobject.schema.RegistryKey;
import com.sygate.scm.common.configobject.schema.RegistryValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RegistryEntries
extends ConfigObject {
    private static final long serialVersionUID = 1L;

    public RegistryEntries() {
        this(true);
    }

    public RegistryEntries(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(264, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(265, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(266, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "RegistryEntries";
    }

    public void addRegistryKey(RegistryKey value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addRegistryKey(int index, RegistryKey value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<RegistryKey> getRegistryKey() {
        Vector<RegistryKey> v = new Vector<RegistryKey>();
        for (Transportable child : (ChildGroup)this.children.get(264)) {
            v.add((RegistryKey)child);
        }
        return v;
    }

    public int getRegistryKeyCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(264);
        return childGroup.size();
    }

    public RegistryKey getRegistryKey(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(264);
        return (RegistryKey)childGroup.get(index);
    }

    public void setRegistryKey(int index, RegistryKey value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeRegistryKey(RegistryKey value) {
        this.removeChild(value);
    }

    public void addRegistryValue(RegistryValue value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addRegistryValue(int index, RegistryValue value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<RegistryValue> getRegistryValue() {
        Vector<RegistryValue> v = new Vector<RegistryValue>();
        for (Transportable child : (ChildGroup)this.children.get(265)) {
            v.add((RegistryValue)child);
        }
        return v;
    }

    public int getRegistryValueCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(265);
        return childGroup.size();
    }

    public RegistryValue getRegistryValue(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(265);
        return (RegistryValue)childGroup.get(index);
    }

    public void setRegistryValue(int index, RegistryValue value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeRegistryValue(RegistryValue value) {
        this.removeChild(value);
    }

    public void addRegistryData(RegistryData value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addRegistryData(int index, RegistryData value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<RegistryData> getRegistryData() {
        Vector<RegistryData> v = new Vector<RegistryData>();
        for (Transportable child : (ChildGroup)this.children.get(266)) {
            v.add((RegistryData)child);
        }
        return v;
    }

    public int getRegistryDataCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(266);
        return childGroup.size();
    }

    public RegistryData getRegistryData(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(266);
        return (RegistryData)childGroup.get(index);
    }

    public void setRegistryData(int index, RegistryData value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeRegistryData(RegistryData value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 723;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof RegistryKey) {
            try {
                this.addRegistryKey((RegistryKey)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof RegistryValue) {
            try {
                this.addRegistryValue((RegistryValue)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof RegistryData) {
            try {
                this.addRegistryData((RegistryData)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getRegistryKeyCount();
        for (i = 0; i < objCnt; ++i) {
            this.getRegistryKey(i).setReadonly();
        }
        objCnt = this.getRegistryValueCount();
        for (i = 0; i < objCnt; ++i) {
            this.getRegistryValue(i).setReadonly();
        }
        objCnt = this.getRegistryDataCount();
        for (i = 0; i < objCnt; ++i) {
            this.getRegistryData(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        int i;
        if (!"RegistryEntries".equals(element.getNodeName())) {
            throw new ValidationException("RegistryEntries: can't import element(" + element.getNodeName() + ")!");
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "RegistryKey");
        for (i = 0; i < v.size(); ++i) {
            RegistryKey registryKeyObj = new RegistryKey();
            registryKeyObj.importFromElement(v.get(i));
            this.addRegistryKey(registryKeyObj);
        }
        v = XMLHelper.getChildElementByName(element, "RegistryValue");
        for (i = 0; i < v.size(); ++i) {
            RegistryValue registryValueObj = new RegistryValue();
            registryValueObj.importFromElement(v.get(i));
            this.addRegistryValue(registryValueObj);
        }
        v = XMLHelper.getChildElementByName(element, "RegistryData");
        for (i = 0; i < v.size(); ++i) {
            RegistryData registryDataObj = new RegistryData();
            registryDataObj.importFromElement(v.get(i));
            this.addRegistryData(registryDataObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i2 = 0; i2 < obsoleteItems.size(); ++i2) {
            Element e = obsoleteItems.get(i2);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("RegistryEntries/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("RegistryEntries/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("RegistryEntries");
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<RegistryEntries ");
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</RegistryEntries>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

