/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RegistryData
extends ConfigObject {
    public static final Integer EQUAL = 0;
    public static final Integer NOT_EQUAL = 1;
    public static final Integer REG_SZ = 0;
    public static final Integer REG_DWORD = 1;
    public static final Integer REG_BINARY = 2;
    private static final long serialVersionUID = 1L;
    private Integer operator;
    private String dataName;
    private Integer dataType;
    private String dataValue;

    public RegistryData() {
        this(true);
    }

    public RegistryData(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "RegistryData";
    }

    public Integer getDefOperator() {
        return EQUAL;
    }

    public Integer getOptOperator() {
        return this.operator;
    }

    public String getOptOperatorValue() throws ValidationException {
        if (this.operator == null) {
            return null;
        }
        String s = null;
        switch (this.operator) {
            case 0: {
                s = "EQUAL";
                break;
            }
            case 1: {
                s = "NOT_EQUAL";
                break;
            }
            default: {
                throw new ValidationException("RegistryData/Operator: invalid attribute value:" + this.operator + "!");
            }
        }
        return s;
    }

    public void setOptOperator(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.operator = value;
    }

    public void setOptOperatorValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.operator = null;
            return;
        }
        if ("EQUAL".equals(value)) {
            this.operator = EQUAL;
        } else if ("NOT_EQUAL".equals(value)) {
            this.operator = NOT_EQUAL;
        } else {
            throw new ValidationException("RegistryData/Operator: invalid attribute value:" + value + "!");
        }
    }

    public String getDataName() {
        return this.dataName;
    }

    public void setDataName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.dataName = value;
    }

    public Integer getDataType() {
        return this.dataType;
    }

    public String getDataTypeValue() throws ValidationException {
        if (this.dataType == null) {
            return null;
        }
        String s = null;
        switch (this.dataType) {
            case 0: {
                s = "REG_SZ";
                break;
            }
            case 1: {
                s = "REG_DWORD";
                break;
            }
            case 2: {
                s = "REG_BINARY";
                break;
            }
            default: {
                throw new ValidationException("RegistryData/DataType: invalid attribute value:" + this.dataType + "!");
            }
        }
        return s;
    }

    public void setDataType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.dataType = value;
    }

    public void setDataTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("REG_SZ".equals(value)) {
            this.dataType = REG_SZ;
        } else if ("REG_DWORD".equals(value)) {
            this.dataType = REG_DWORD;
        } else if ("REG_BINARY".equals(value)) {
            this.dataType = REG_BINARY;
        } else {
            throw new ValidationException("RegistryData/DataType: invalid attribute value:" + value + "!");
        }
    }

    public String getDataValue() {
        return this.dataValue;
    }

    public void setDataValue(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.dataValue = value;
    }

    @Override
    public int getObjectType() {
        return 266;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.dataName == null) {
            throw new ValidationException("RegistryData/DataName: attribute is required!");
        }
        if (this.dataType == null) {
            throw new ValidationException("RegistryData/DataType: attribute is required!");
        }
        if (this.dataValue == null) {
            throw new ValidationException("RegistryData/DataValue: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Operator");
            if (value != null) {
                this.setOptOperatorValue(value);
            }
            if ((value = attris.getValue("DataName")) == null) {
                throw new ValidationException("RegistryData/DataName: attribute is required!");
            }
            this.dataName = value;
            value = attris.getValue("DataType");
            if (value == null) {
                throw new ValidationException("RegistryData/DataType: attribute is required!");
            }
            this.setDataTypeValue(value);
            value = attris.getValue("DataValue");
            if (value == null) {
                throw new ValidationException("RegistryData/DataValue: attribute is required!");
            }
            this.dataValue = value;
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"RegistryData".equals(element.getNodeName())) {
            throw new ValidationException("RegistryData: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Operator");
        if (value != null) {
            this.setOptOperatorValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "DataName")) == null) {
            throw new ValidationException("RegistryData/DataName: attribute is required!");
        }
        this.dataName = value;
        value = XMLHelper.getAttribute(element, "DataType");
        if (value == null) {
            throw new ValidationException("RegistryData/DataType: attribute is required!");
        }
        this.setDataTypeValue(value);
        value = XMLHelper.getAttribute(element, "DataValue");
        if (value == null) {
            throw new ValidationException("RegistryData/DataValue: attribute is required!");
        }
        this.dataValue = value;
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("RegistryData/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("RegistryData/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("RegistryData");
        if (this.operator != null) {
            element.setAttribute("Operator", this.getOptOperatorValue());
        }
        if (this.dataName != null) {
            element.setAttribute("DataName", this.dataName);
        }
        if (this.dataType != null) {
            element.setAttribute("DataType", this.getDataTypeValue());
        }
        if (this.dataValue != null) {
            element.setAttribute("DataValue", this.dataValue);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<RegistryData ");
            if (this.operator != null) {
                strAttrs.append("Operator=\"").append(this.getOptOperatorValue()).append("\" ");
            }
            if (this.dataName != null) {
                strAttrs.append("DataName=\"").append(AbstractSchema.checkXMLContent(this.dataName)).append("\" ");
            }
            if (this.dataType != null) {
                strAttrs.append("DataType=\"").append(this.getDataTypeValue()).append("\" ");
            }
            if (this.dataValue != null) {
                strAttrs.append("DataValue=\"").append(AbstractSchema.checkXMLContent(this.dataValue)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</RegistryData>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

