/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RebootOptions
extends ConfigObject {
    public static final Integer CLIENT = 0;
    public static final Integer SERVER = 1;
    public static final Integer NONE = 2;
    public static final Integer CUSTOM = 3;
    public static final Integer NOW = 0;
    public static final Integer LATER = 1;
    public static final Integer TODAY = 0;
    public static final Integer MONDAY = 1;
    public static final Integer TUESDAY = 2;
    public static final Integer WEDNESDAY = 3;
    public static final Integer THURSDAY = 4;
    public static final Integer FRIDAY = 5;
    public static final Integer SATURDAY = 6;
    public static final Integer SUNDAY = 7;
    public static final Integer COUNTDOWN = 0;
    public static final Integer SNOOZE = 1;
    private static final long serialVersionUID = 1L;
    private Integer rebootMethod;
    private Integer rebootSchedule;
    private Integer rebootDay;
    private Integer rebootMinutes;
    private Boolean randomize;
    private Integer randomizeHours;
    private Boolean promptUser;
    private Integer promptType;
    private String promptMessage;
    private Integer displayTimeout;
    private Integer countdown;
    private Integer maxSnoozeCount;
    private Integer snoozeInterval;
    private Boolean hardReboot;
    private Boolean autoReboot;
    private Boolean locked;

    public RebootOptions() {
        this(true);
    }

    public RebootOptions(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "RebootOptions";
    }

    public Integer getDefRebootMethod() {
        return CLIENT;
    }

    public Integer getOptRebootMethod() {
        return this.rebootMethod;
    }

    public String getOptRebootMethodValue() throws ValidationException {
        if (this.rebootMethod == null) {
            return null;
        }
        String s = null;
        switch (this.rebootMethod) {
            case 0: {
                s = "CLIENT";
                break;
            }
            case 1: {
                s = "SERVER";
                break;
            }
            case 2: {
                s = "NONE";
                break;
            }
            case 3: {
                s = "CUSTOM";
                break;
            }
            default: {
                throw new ValidationException("RebootOptions/RebootMethod: invalid attribute value:" + this.rebootMethod + "!");
            }
        }
        return s;
    }

    public void setOptRebootMethod(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.rebootMethod = value;
    }

    public void setOptRebootMethodValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.rebootMethod = null;
            return;
        }
        if ("CLIENT".equals(value)) {
            this.rebootMethod = CLIENT;
        } else if ("SERVER".equals(value)) {
            this.rebootMethod = SERVER;
        } else if ("NONE".equals(value)) {
            this.rebootMethod = NONE;
        } else if ("CUSTOM".equals(value)) {
            this.rebootMethod = CUSTOM;
        } else {
            throw new ValidationException("RebootOptions/RebootMethod: invalid attribute value:" + value + "!");
        }
    }

    public Integer getDefRebootSchedule() {
        return LATER;
    }

    public Integer getOptRebootSchedule() {
        return this.rebootSchedule;
    }

    public String getOptRebootScheduleValue() throws ValidationException {
        if (this.rebootSchedule == null) {
            return null;
        }
        String s = null;
        switch (this.rebootSchedule) {
            case 0: {
                s = "NOW";
                break;
            }
            case 1: {
                s = "LATER";
                break;
            }
            default: {
                throw new ValidationException("RebootOptions/RebootSchedule: invalid attribute value:" + this.rebootSchedule + "!");
            }
        }
        return s;
    }

    public void setOptRebootSchedule(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.rebootSchedule = value;
    }

    public void setOptRebootScheduleValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.rebootSchedule = null;
            return;
        }
        if ("NOW".equals(value)) {
            this.rebootSchedule = NOW;
        } else if ("LATER".equals(value)) {
            this.rebootSchedule = LATER;
        } else {
            throw new ValidationException("RebootOptions/RebootSchedule: invalid attribute value:" + value + "!");
        }
    }

    public Integer getDefRebootDay() {
        return TODAY;
    }

    public Integer getOptRebootDay() {
        return this.rebootDay;
    }

    public String getOptRebootDayValue() throws ValidationException {
        if (this.rebootDay == null) {
            return null;
        }
        String s = null;
        switch (this.rebootDay) {
            case 0: {
                s = "TODAY";
                break;
            }
            case 1: {
                s = "MONDAY";
                break;
            }
            case 2: {
                s = "TUESDAY";
                break;
            }
            case 3: {
                s = "WEDNESDAY";
                break;
            }
            case 4: {
                s = "THURSDAY";
                break;
            }
            case 5: {
                s = "FRIDAY";
                break;
            }
            case 6: {
                s = "SATURDAY";
                break;
            }
            case 7: {
                s = "SUNDAY";
                break;
            }
            default: {
                throw new ValidationException("RebootOptions/RebootDay: invalid attribute value:" + this.rebootDay + "!");
            }
        }
        return s;
    }

    public void setOptRebootDay(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.rebootDay = value;
    }

    public void setOptRebootDayValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.rebootDay = null;
            return;
        }
        if ("TODAY".equals(value)) {
            this.rebootDay = TODAY;
        } else if ("MONDAY".equals(value)) {
            this.rebootDay = MONDAY;
        } else if ("TUESDAY".equals(value)) {
            this.rebootDay = TUESDAY;
        } else if ("WEDNESDAY".equals(value)) {
            this.rebootDay = WEDNESDAY;
        } else if ("THURSDAY".equals(value)) {
            this.rebootDay = THURSDAY;
        } else if ("FRIDAY".equals(value)) {
            this.rebootDay = FRIDAY;
        } else if ("SATURDAY".equals(value)) {
            this.rebootDay = SATURDAY;
        } else if ("SUNDAY".equals(value)) {
            this.rebootDay = SUNDAY;
        } else {
            throw new ValidationException("RebootOptions/RebootDay: invalid attribute value:" + value + "!");
        }
    }

    public Integer getDefRebootMinutes() {
        return 180;
    }

    public Integer getOptRebootMinutes() {
        return this.rebootMinutes;
    }

    public void setOptRebootMinutes(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.rebootMinutes = value;
    }

    public Boolean getDefRandomize() {
        return Boolean.TRUE;
    }

    public Boolean getOptRandomize() {
        return this.randomize;
    }

    public void setOptRandomize(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.randomize = value;
    }

    public Integer getDefRandomizeHours() {
        return 2;
    }

    public Integer getOptRandomizeHours() {
        return this.randomizeHours;
    }

    public void setOptRandomizeHours(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.randomizeHours = value;
    }

    public Boolean getDefPromptUser() {
        return Boolean.TRUE;
    }

    public Boolean getOptPromptUser() {
        return this.promptUser;
    }

    public void setOptPromptUser(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.promptUser = value;
    }

    public Integer getDefPromptType() {
        return SNOOZE;
    }

    public Integer getOptPromptType() {
        return this.promptType;
    }

    public String getOptPromptTypeValue() throws ValidationException {
        if (this.promptType == null) {
            return null;
        }
        String s = null;
        switch (this.promptType) {
            case 0: {
                s = "COUNTDOWN";
                break;
            }
            case 1: {
                s = "SNOOZE";
                break;
            }
            default: {
                throw new ValidationException("RebootOptions/PromptType: invalid attribute value:" + this.promptType + "!");
            }
        }
        return s;
    }

    public void setOptPromptType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.promptType = value;
    }

    public void setOptPromptTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.promptType = null;
            return;
        }
        if ("COUNTDOWN".equals(value)) {
            this.promptType = COUNTDOWN;
        } else if ("SNOOZE".equals(value)) {
            this.promptType = SNOOZE;
        } else {
            throw new ValidationException("RebootOptions/PromptType: invalid attribute value:" + value + "!");
        }
    }

    public String getOptPromptMessage() {
        return this.promptMessage;
    }

    public void setOptPromptMessage(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.promptMessage = value;
    }

    public Integer getDefDisplayTimeout() {
        return 60;
    }

    public Integer getOptDisplayTimeout() {
        return this.displayTimeout;
    }

    public void setOptDisplayTimeout(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.displayTimeout = value;
    }

    public Integer getDefCountdown() {
        return 5;
    }

    public Integer getOptCountdown() {
        return this.countdown;
    }

    public void setOptCountdown(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.countdown = value;
    }

    public Integer getDefMaxSnoozeCount() {
        return 3;
    }

    public Integer getOptMaxSnoozeCount() {
        return this.maxSnoozeCount;
    }

    public void setOptMaxSnoozeCount(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.maxSnoozeCount = value;
    }

    public Integer getDefSnoozeInterval() {
        return 60;
    }

    public Integer getOptSnoozeInterval() {
        return this.snoozeInterval;
    }

    public void setOptSnoozeInterval(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.snoozeInterval = value;
    }

    public Boolean getDefHardReboot() {
        return Boolean.TRUE;
    }

    public Boolean getOptHardReboot() {
        return this.hardReboot;
    }

    public void setOptHardReboot(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.hardReboot = value;
    }

    public Boolean getDefAutoReboot() {
        return Boolean.TRUE;
    }

    public Boolean getOptAutoReboot() {
        return this.autoReboot;
    }

    public void setOptAutoReboot(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.autoReboot = value;
    }

    public Boolean getDefLocked() {
        return Boolean.FALSE;
    }

    public Boolean getOptLocked() {
        return this.locked;
    }

    public void setOptLocked(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.locked = value;
    }

    @Override
    public int getObjectType() {
        return 284;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("RebootMethod");
            if (value != null) {
                this.setOptRebootMethodValue(value);
            }
            if ((value = attris.getValue("RebootSchedule")) != null) {
                this.setOptRebootScheduleValue(value);
            }
            if ((value = attris.getValue("RebootDay")) != null) {
                this.setOptRebootDayValue(value);
            }
            if ((value = attris.getValue("RebootMinutes")) != null) {
                try {
                    this.rebootMinutes = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("RebootOptions/RebootMinutes: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("RebootOptions/RebootMinutes: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("Randomize")) != null) {
                this.randomize = "1".equals(value);
            }
            if ((value = attris.getValue("RandomizeHours")) != null) {
                try {
                    this.randomizeHours = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("RebootOptions/RandomizeHours: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("RebootOptions/RandomizeHours: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("PromptUser")) != null) {
                this.promptUser = "1".equals(value);
            }
            if ((value = attris.getValue("PromptType")) != null) {
                this.setOptPromptTypeValue(value);
            }
            if ((value = attris.getValue("PromptMessage")) != null) {
                this.promptMessage = value;
            }
            if ((value = attris.getValue("DisplayTimeout")) != null) {
                try {
                    this.displayTimeout = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("RebootOptions/DisplayTimeout: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("RebootOptions/DisplayTimeout: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("Countdown")) != null) {
                try {
                    this.countdown = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("RebootOptions/Countdown: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("RebootOptions/Countdown: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("MaxSnoozeCount")) != null) {
                try {
                    this.maxSnoozeCount = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("RebootOptions/MaxSnoozeCount: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("RebootOptions/MaxSnoozeCount: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("SnoozeInterval")) != null) {
                try {
                    this.snoozeInterval = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("RebootOptions/SnoozeInterval: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("RebootOptions/SnoozeInterval: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("HardReboot")) != null) {
                this.hardReboot = "1".equals(value);
            }
            if ((value = attris.getValue("AutoReboot")) != null) {
                this.autoReboot = "1".equals(value);
            }
            if ((value = attris.getValue("Locked")) != null) {
                this.locked = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"RebootOptions".equals(element.getNodeName())) {
            throw new ValidationException("RebootOptions: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "RebootMethod");
        if (value != null) {
            this.setOptRebootMethodValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "RebootSchedule")) != null) {
            this.setOptRebootScheduleValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "RebootDay")) != null) {
            this.setOptRebootDayValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "RebootMinutes")) != null) {
            try {
                this.rebootMinutes = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("RebootOptions/RebootMinutes: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "Randomize")) != null) {
            this.randomize = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "RandomizeHours")) != null) {
            try {
                this.randomizeHours = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("RebootOptions/RandomizeHours: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "PromptUser")) != null) {
            this.promptUser = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "PromptType")) != null) {
            this.setOptPromptTypeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "PromptMessage")) != null) {
            this.promptMessage = value;
        }
        if ((value = XMLHelper.getAttribute(element, "DisplayTimeout")) != null) {
            try {
                this.displayTimeout = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("RebootOptions/DisplayTimeout: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "Countdown")) != null) {
            try {
                this.countdown = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("RebootOptions/Countdown: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "MaxSnoozeCount")) != null) {
            try {
                this.maxSnoozeCount = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("RebootOptions/MaxSnoozeCount: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "SnoozeInterval")) != null) {
            try {
                this.snoozeInterval = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("RebootOptions/SnoozeInterval: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "HardReboot")) != null) {
            this.hardReboot = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AutoReboot")) != null) {
            this.autoReboot = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Locked")) != null) {
            this.locked = "1".equals(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("RebootOptions/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("RebootOptions/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("RebootOptions");
        if (this.rebootMethod != null) {
            element.setAttribute("RebootMethod", this.getOptRebootMethodValue());
        }
        if (this.rebootSchedule != null) {
            element.setAttribute("RebootSchedule", this.getOptRebootScheduleValue());
        }
        if (this.rebootDay != null) {
            element.setAttribute("RebootDay", this.getOptRebootDayValue());
        }
        if (this.rebootMinutes != null) {
            element.setAttribute("RebootMinutes", this.rebootMinutes.toString());
        }
        if (this.randomize != null) {
            element.setAttribute("Randomize", this.randomize != false ? "1" : "0");
        }
        if (this.randomizeHours != null) {
            element.setAttribute("RandomizeHours", this.randomizeHours.toString());
        }
        if (this.promptUser != null) {
            element.setAttribute("PromptUser", this.promptUser != false ? "1" : "0");
        }
        if (this.promptType != null) {
            element.setAttribute("PromptType", this.getOptPromptTypeValue());
        }
        if (this.promptMessage != null) {
            element.setAttribute("PromptMessage", this.promptMessage);
        }
        if (this.displayTimeout != null) {
            element.setAttribute("DisplayTimeout", this.displayTimeout.toString());
        }
        if (this.countdown != null) {
            element.setAttribute("Countdown", this.countdown.toString());
        }
        if (this.maxSnoozeCount != null) {
            element.setAttribute("MaxSnoozeCount", this.maxSnoozeCount.toString());
        }
        if (this.snoozeInterval != null) {
            element.setAttribute("SnoozeInterval", this.snoozeInterval.toString());
        }
        if (this.hardReboot != null) {
            element.setAttribute("HardReboot", this.hardReboot != false ? "1" : "0");
        }
        if (this.autoReboot != null) {
            element.setAttribute("AutoReboot", this.autoReboot != false ? "1" : "0");
        }
        if (this.locked != null) {
            element.setAttribute("Locked", this.locked != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<RebootOptions ");
            if (this.rebootMethod != null) {
                strAttrs.append("RebootMethod=\"").append(this.getOptRebootMethodValue()).append("\" ");
            }
            if (this.rebootSchedule != null) {
                strAttrs.append("RebootSchedule=\"").append(this.getOptRebootScheduleValue()).append("\" ");
            }
            if (this.rebootDay != null) {
                strAttrs.append("RebootDay=\"").append(this.getOptRebootDayValue()).append("\" ");
            }
            if (this.rebootMinutes != null) {
                strAttrs.append("RebootMinutes=\"").append(this.rebootMinutes.toString()).append("\" ");
            }
            if (this.randomize != null) {
                strAttrs.append("Randomize=").append(this.randomize != false ? "\"1\" " : "\"0\" ");
            }
            if (this.randomizeHours != null) {
                strAttrs.append("RandomizeHours=\"").append(this.randomizeHours.toString()).append("\" ");
            }
            if (this.promptUser != null) {
                strAttrs.append("PromptUser=").append(this.promptUser != false ? "\"1\" " : "\"0\" ");
            }
            if (this.promptType != null) {
                strAttrs.append("PromptType=\"").append(this.getOptPromptTypeValue()).append("\" ");
            }
            if (this.promptMessage != null) {
                strAttrs.append("PromptMessage=\"").append(AbstractSchema.checkXMLContent(this.promptMessage)).append("\" ");
            }
            if (this.displayTimeout != null) {
                strAttrs.append("DisplayTimeout=\"").append(this.displayTimeout.toString()).append("\" ");
            }
            if (this.countdown != null) {
                strAttrs.append("Countdown=\"").append(this.countdown.toString()).append("\" ");
            }
            if (this.maxSnoozeCount != null) {
                strAttrs.append("MaxSnoozeCount=\"").append(this.maxSnoozeCount.toString()).append("\" ");
            }
            if (this.snoozeInterval != null) {
                strAttrs.append("SnoozeInterval=\"").append(this.snoozeInterval.toString()).append("\" ");
            }
            if (this.hardReboot != null) {
                strAttrs.append("HardReboot=").append(this.hardReboot != false ? "\"1\" " : "\"0\" ");
            }
            if (this.autoReboot != null) {
                strAttrs.append("AutoReboot=").append(this.autoReboot != false ? "\"1\" " : "\"0\" ");
            }
            if (this.locked != null) {
                strAttrs.append("Locked=").append(this.locked != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</RebootOptions>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

