/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RawTcp
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private String sourcePort;
    private String destinationPort;
    private String localPort;
    private String remotePort;
    private Boolean incomingCall;

    public RawTcp() {
        this(true);
    }

    public RawTcp(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "RawTcp";
    }

    public String getOptSourcePort() {
        return this.sourcePort;
    }

    public void setOptSourcePort(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.sourcePort = value;
    }

    public String getOptDestinationPort() {
        return this.destinationPort;
    }

    public void setOptDestinationPort(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.destinationPort = value;
    }

    public String getOptLocalPort() {
        return this.localPort;
    }

    public void setOptLocalPort(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.localPort = value;
    }

    public String getOptRemotePort() {
        return this.remotePort;
    }

    public void setOptRemotePort(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.remotePort = value;
    }

    public Boolean getOptIncomingCall() {
        return this.incomingCall;
    }

    public void setOptIncomingCall(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.incomingCall = value;
    }

    @Override
    public int getObjectType() {
        return 315;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("SourcePort");
            if (value != null) {
                this.sourcePort = value;
            }
            if ((value = attris.getValue("DestinationPort")) != null) {
                this.destinationPort = value;
            }
            if ((value = attris.getValue("LocalPort")) != null) {
                this.localPort = value;
            }
            if ((value = attris.getValue("RemotePort")) != null) {
                this.remotePort = value;
            }
            if ((value = attris.getValue("IncomingCall")) != null) {
                this.incomingCall = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"RawTcp".equals(element.getNodeName())) {
            throw new ValidationException("RawTcp: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "SourcePort");
        if (value != null) {
            this.sourcePort = value;
        }
        if ((value = XMLHelper.getAttribute(element, "DestinationPort")) != null) {
            this.destinationPort = value;
        }
        if ((value = XMLHelper.getAttribute(element, "LocalPort")) != null) {
            this.localPort = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RemotePort")) != null) {
            this.remotePort = value;
        }
        if ((value = XMLHelper.getAttribute(element, "IncomingCall")) != null) {
            this.incomingCall = "1".equals(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("RawTcp/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("RawTcp/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("RawTcp");
        if (this.sourcePort != null) {
            element.setAttribute("SourcePort", this.sourcePort);
        }
        if (this.destinationPort != null) {
            element.setAttribute("DestinationPort", this.destinationPort);
        }
        if (this.localPort != null) {
            element.setAttribute("LocalPort", this.localPort);
        }
        if (this.remotePort != null) {
            element.setAttribute("RemotePort", this.remotePort);
        }
        if (this.incomingCall != null) {
            element.setAttribute("IncomingCall", this.incomingCall != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<RawTcp ");
            if (this.sourcePort != null) {
                strAttrs.append("SourcePort=\"").append(AbstractSchema.checkXMLContent(this.sourcePort)).append("\" ");
            }
            if (this.destinationPort != null) {
                strAttrs.append("DestinationPort=\"").append(AbstractSchema.checkXMLContent(this.destinationPort)).append("\" ");
            }
            if (this.localPort != null) {
                strAttrs.append("LocalPort=\"").append(AbstractSchema.checkXMLContent(this.localPort)).append("\" ");
            }
            if (this.remotePort != null) {
                strAttrs.append("RemotePort=\"").append(AbstractSchema.checkXMLContent(this.remotePort)).append("\" ");
            }
            if (this.incomingCall != null) {
                strAttrs.append("IncomingCall=").append(this.incomingCall != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</RawTcp>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

