/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.util.Utility;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RadiusServer
extends ConfigObject
implements NamedObject {
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private String refId;
    private String radiusServerAddress;
    private Integer authPort;
    private Integer timeout;
    private Integer retry;
    private String sharedSecret;

    public RadiusServer() {
        this(true);
    }

    public RadiusServer(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "RadiusServer";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.name = value;
    }

    @Override
    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.description = value;
    }

    @Override
    public String getOptRefId() {
        return this.refId;
    }

    public void setOptRefId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.refId = value;
    }

    public String getRadiusServerAddress() {
        return this.radiusServerAddress;
    }

    public void setRadiusServerAddress(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.radiusServerAddress = value;
    }

    public Integer getDefAuthPort() {
        return 1812;
    }

    public Integer getOptAuthPort() {
        return this.authPort;
    }

    public void setOptAuthPort(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.authPort = value;
    }

    public Integer getDefTimeout() {
        return 3;
    }

    public Integer getOptTimeout() {
        return this.timeout;
    }

    public void setOptTimeout(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.timeout = value;
    }

    public Integer getDefRetry() {
        return 1;
    }

    public Integer getOptRetry() {
        return this.retry;
    }

    public void setOptRetry(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.retry = value;
    }

    public String getSharedSecret() {
        try {
            return Utility.decrypt(this.sharedSecret);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setSharedSecret(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        try {
            this.sharedSecret = Utility.encrypt(value);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getObjectType() {
        return 571;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.name == null) {
            throw new ValidationException("RadiusServer/Name: attribute is required!");
        }
        if (this.radiusServerAddress == null) {
            throw new ValidationException("RadiusServer/RadiusServerAddress: attribute is required!");
        }
        if (this.sharedSecret == null) {
            throw new ValidationException("RadiusServer/SharedSecret: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("RadiusServer/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Description");
            if (value != null) {
                this.description = value;
            }
            if ((value = attris.getValue("RefId")) != null) {
                this.refId = value;
            }
            if ((value = attris.getValue("RadiusServerAddress")) == null) {
                throw new ValidationException("RadiusServer/RadiusServerAddress: attribute is required!");
            }
            this.radiusServerAddress = value;
            value = attris.getValue("AuthPort");
            if (value != null) {
                try {
                    this.authPort = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("RadiusServer/AuthPort: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("RadiusServer/AuthPort: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("Timeout")) != null) {
                try {
                    this.timeout = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("RadiusServer/Timeout: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("RadiusServer/Timeout: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("Retry")) != null) {
                try {
                    this.retry = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("RadiusServer/Retry: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("RadiusServer/Retry: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("SharedSecret")) == null) {
                throw new ValidationException("RadiusServer/SharedSecret: attribute is required!");
            }
            this.sharedSecret = value;
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"RadiusServer".equals(element.getNodeName())) {
            throw new ValidationException("RadiusServer: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("RadiusServer/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Description");
        if (value != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RefId")) != null) {
            this.refId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RadiusServerAddress")) == null) {
            throw new ValidationException("RadiusServer/RadiusServerAddress: attribute is required!");
        }
        this.radiusServerAddress = value;
        value = XMLHelper.getAttribute(element, "AuthPort");
        if (value != null) {
            try {
                this.authPort = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("RadiusServer/AuthPort: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "Timeout")) != null) {
            try {
                this.timeout = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("RadiusServer/Timeout: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "Retry")) != null) {
            try {
                this.retry = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("RadiusServer/Retry: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "SharedSecret")) == null) {
            throw new ValidationException("RadiusServer/SharedSecret: attribute is required!");
        }
        this.sharedSecret = value;
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("RadiusServer/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("RadiusServer/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("RadiusServer");
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.refId != null) {
            element.setAttribute("RefId", this.refId);
        }
        if (this.radiusServerAddress != null) {
            element.setAttribute("RadiusServerAddress", this.radiusServerAddress);
        }
        if (this.authPort != null) {
            element.setAttribute("AuthPort", this.authPort.toString());
        }
        if (this.timeout != null) {
            element.setAttribute("Timeout", this.timeout.toString());
        }
        if (this.retry != null) {
            element.setAttribute("Retry", this.retry.toString());
        }
        if (this.sharedSecret != null) {
            element.setAttribute("SharedSecret", this.sharedSecret);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<RadiusServer ");
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.refId != null) {
                strAttrs.append("RefId=\"").append(AbstractSchema.checkXMLContent(this.refId)).append("\" ");
            }
            if (this.radiusServerAddress != null) {
                strAttrs.append("RadiusServerAddress=\"").append(AbstractSchema.checkXMLContent(this.radiusServerAddress)).append("\" ");
            }
            if (this.authPort != null) {
                strAttrs.append("AuthPort=\"").append(this.authPort.toString()).append("\" ");
            }
            if (this.timeout != null) {
                strAttrs.append("Timeout=\"").append(this.timeout.toString()).append("\" ");
            }
            if (this.retry != null) {
                strAttrs.append("Retry=\"").append(this.retry.toString()).append("\" ");
            }
            if (this.sharedSecret != null) {
                strAttrs.append("SharedSecret=\"").append(AbstractSchema.checkXMLContent(this.sharedSecret)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</RadiusServer>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

