/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.util.Utility;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ProxyServerConfig
extends ConfigObject {
    public static final Integer USE_IE_SETTINGS = 0;
    public static final Integer USE_CUSTOM = 1;
    public static final Integer NOT_USED = 2;
    public static final Integer BASIC = 0;
    public static final Integer NTLM = 1;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Integer usage;
    private String proxyServerAddress;
    private Integer proxyServerPort;
    private Boolean needAuthentication;
    private Integer proxyAuthenticationType;
    private String proxyUserName;
    private String proxyPassword;

    public ProxyServerConfig() {
        this(true);
    }

    public ProxyServerConfig(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "ProxyServerConfig";
    }

    public Boolean getDefEnable() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public Integer getDefUsage() {
        return USE_IE_SETTINGS;
    }

    public Integer getOptUsage() {
        return this.usage;
    }

    public String getOptUsageValue() throws ValidationException {
        if (this.usage == null) {
            return null;
        }
        String s = null;
        switch (this.usage) {
            case 0: {
                s = "USE_IE_SETTINGS";
                break;
            }
            case 1: {
                s = "USE_CUSTOM";
                break;
            }
            case 2: {
                s = "NOT_USED";
                break;
            }
            default: {
                throw new ValidationException("ProxyServerConfig/Usage: invalid attribute value:" + this.usage + "!");
            }
        }
        return s;
    }

    public void setOptUsage(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.usage = value;
    }

    public void setOptUsageValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.usage = null;
            return;
        }
        if ("USE_IE_SETTINGS".equals(value)) {
            this.usage = USE_IE_SETTINGS;
        } else if ("USE_CUSTOM".equals(value)) {
            this.usage = USE_CUSTOM;
        } else if ("NOT_USED".equals(value)) {
            this.usage = NOT_USED;
        } else {
            throw new ValidationException("ProxyServerConfig/Usage: invalid attribute value:" + value + "!");
        }
    }

    public String getProxyServerAddress() {
        return this.proxyServerAddress;
    }

    public void setProxyServerAddress(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.proxyServerAddress = value;
    }

    public Integer getProxyServerPort() {
        return this.proxyServerPort;
    }

    public void setProxyServerPort(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.proxyServerPort = value;
    }

    public Boolean getDefNeedAuthentication() {
        return Boolean.FALSE;
    }

    public Boolean getOptNeedAuthentication() {
        return this.needAuthentication;
    }

    public void setOptNeedAuthentication(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.needAuthentication = value;
    }

    public Integer getDefProxyAuthenticationType() {
        return BASIC;
    }

    public Integer getOptProxyAuthenticationType() {
        return this.proxyAuthenticationType;
    }

    public String getOptProxyAuthenticationTypeValue() throws ValidationException {
        if (this.proxyAuthenticationType == null) {
            return null;
        }
        String s = null;
        switch (this.proxyAuthenticationType) {
            case 0: {
                s = "BASIC";
                break;
            }
            case 1: {
                s = "NTLM";
                break;
            }
            default: {
                throw new ValidationException("ProxyServerConfig/ProxyAuthenticationType: invalid attribute value:" + this.proxyAuthenticationType + "!");
            }
        }
        return s;
    }

    public void setOptProxyAuthenticationType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.proxyAuthenticationType = value;
    }

    public void setOptProxyAuthenticationTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.proxyAuthenticationType = null;
            return;
        }
        if ("BASIC".equals(value)) {
            this.proxyAuthenticationType = BASIC;
        } else if ("NTLM".equals(value)) {
            this.proxyAuthenticationType = NTLM;
        } else {
            throw new ValidationException("ProxyServerConfig/ProxyAuthenticationType: invalid attribute value:" + value + "!");
        }
    }

    public String getOptProxyUserName() {
        return this.proxyUserName;
    }

    public void setOptProxyUserName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.proxyUserName = value;
    }

    public String getOptProxyPassword() {
        try {
            return Utility.decryptLatestForBackwardCompatibility(this.proxyPassword);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setOptProxyPassword(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        try {
            this.proxyPassword = Utility.encryptLatest(value);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getObjectType() {
        return 63;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.proxyServerAddress == null) {
            throw new ValidationException("ProxyServerConfig/ProxyServerAddress: attribute is required!");
        }
        if (this.proxyServerPort == null) {
            throw new ValidationException("ProxyServerConfig/ProxyServerPort: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("Usage")) != null) {
                this.setOptUsageValue(value);
            }
            if ((value = attris.getValue("ProxyServerAddress")) == null) {
                throw new ValidationException("ProxyServerConfig/ProxyServerAddress: attribute is required!");
            }
            this.proxyServerAddress = value;
            value = attris.getValue("ProxyServerPort");
            if (value == null) {
                throw new ValidationException("ProxyServerConfig/ProxyServerPort: attribute is required!");
            }
            try {
                this.proxyServerPort = Integer.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("ProxyServerConfig/ProxyServerPort: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("ProxyServerConfig/ProxyServerPort: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("NeedAuthentication");
            if (value != null) {
                this.needAuthentication = "1".equals(value);
            }
            if ((value = attris.getValue("ProxyAuthenticationType")) != null) {
                this.setOptProxyAuthenticationTypeValue(value);
            }
            if ((value = attris.getValue("ProxyUserName")) != null) {
                this.proxyUserName = value;
            }
            if ((value = attris.getValue("ProxyPassword")) != null) {
                this.proxyPassword = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"ProxyServerConfig".equals(element.getNodeName())) {
            throw new ValidationException("ProxyServerConfig: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Usage")) != null) {
            this.setOptUsageValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ProxyServerAddress")) == null) {
            throw new ValidationException("ProxyServerConfig/ProxyServerAddress: attribute is required!");
        }
        this.proxyServerAddress = value;
        value = XMLHelper.getAttribute(element, "ProxyServerPort");
        if (value == null) {
            throw new ValidationException("ProxyServerConfig/ProxyServerPort: attribute is required!");
        }
        try {
            this.proxyServerPort = Integer.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("ProxyServerConfig/ProxyServerPort: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("ProxyServerConfig/ProxyServerPort: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "NeedAuthentication");
        if (value != null) {
            this.needAuthentication = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ProxyAuthenticationType")) != null) {
            this.setOptProxyAuthenticationTypeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ProxyUserName")) != null) {
            this.proxyUserName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ProxyPassword")) != null) {
            this.proxyPassword = value;
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("ProxyServerConfig/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("ProxyServerConfig/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("ProxyServerConfig");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.usage != null) {
            element.setAttribute("Usage", this.getOptUsageValue());
        }
        if (this.proxyServerAddress != null) {
            element.setAttribute("ProxyServerAddress", this.proxyServerAddress);
        }
        if (this.proxyServerPort != null) {
            element.setAttribute("ProxyServerPort", this.proxyServerPort.toString());
        }
        if (this.needAuthentication != null) {
            element.setAttribute("NeedAuthentication", this.needAuthentication != false ? "1" : "0");
        }
        if (this.proxyAuthenticationType != null) {
            element.setAttribute("ProxyAuthenticationType", this.getOptProxyAuthenticationTypeValue());
        }
        if (this.proxyUserName != null) {
            element.setAttribute("ProxyUserName", this.proxyUserName);
        }
        if (this.proxyPassword != null) {
            element.setAttribute("ProxyPassword", this.proxyPassword);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ProxyServerConfig ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.usage != null) {
                strAttrs.append("Usage=\"").append(this.getOptUsageValue()).append("\" ");
            }
            if (this.proxyServerAddress != null) {
                strAttrs.append("ProxyServerAddress=\"").append(AbstractSchema.checkXMLContent(this.proxyServerAddress)).append("\" ");
            }
            if (this.proxyServerPort != null) {
                strAttrs.append("ProxyServerPort=\"").append(this.proxyServerPort.toString()).append("\" ");
            }
            if (this.needAuthentication != null) {
                strAttrs.append("NeedAuthentication=").append(this.needAuthentication != false ? "\"1\" " : "\"0\" ");
            }
            if (this.proxyAuthenticationType != null) {
                strAttrs.append("ProxyAuthenticationType=\"").append(this.getOptProxyAuthenticationTypeValue()).append("\" ");
            }
            if (this.proxyUserName != null) {
                strAttrs.append("ProxyUserName=\"").append(AbstractSchema.checkXMLContent(this.proxyUserName)).append("\" ");
            }
            if (this.proxyPassword != null) {
                strAttrs.append("ProxyPassword=\"").append(AbstractSchema.checkXMLContent(this.proxyPassword)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ProxyServerConfig>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

