/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ProtectionTechnology
extends ConfigObject {
    public static final Integer GEPT_HPP = 0;
    public static final Integer GEPT_ADC = 1;
    public static final Integer GEPT_SECURITY_RISK = 2;
    private static final long serialVersionUID = 1L;
    private Integer scanType;
    private Boolean aCExcludeChildProcesses;

    public ProtectionTechnology() {
        this(true);
    }

    public ProtectionTechnology(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "ProtectionTechnology";
    }

    public Integer getScanType() {
        return this.scanType;
    }

    public String getScanTypeValue() throws ValidationException {
        if (this.scanType == null) {
            return null;
        }
        String s = null;
        switch (this.scanType) {
            case 0: {
                s = "GEPT_HPP";
                break;
            }
            case 1: {
                s = "GEPT_ADC";
                break;
            }
            case 2: {
                s = "GEPT_SECURITY_RISK";
                break;
            }
            default: {
                throw new ValidationException("ProtectionTechnology/ScanType: invalid attribute value:" + this.scanType + "!");
            }
        }
        return s;
    }

    public void setScanType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.scanType = value;
    }

    public void setScanTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("GEPT_HPP".equals(value)) {
            this.scanType = GEPT_HPP;
        } else if ("GEPT_ADC".equals(value)) {
            this.scanType = GEPT_ADC;
        } else if ("GEPT_SECURITY_RISK".equals(value)) {
            this.scanType = GEPT_SECURITY_RISK;
        } else {
            throw new ValidationException("ProtectionTechnology/ScanType: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefACExcludeChildProcesses() {
        return Boolean.FALSE;
    }

    public Boolean getOptACExcludeChildProcesses() {
        return this.aCExcludeChildProcesses;
    }

    public void setOptACExcludeChildProcesses(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.aCExcludeChildProcesses = value;
    }

    @Override
    public int getObjectType() {
        return 608;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.scanType == null) {
            throw new ValidationException("ProtectionTechnology/ScanType: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("ScanType");
            if (value == null) {
                throw new ValidationException("ProtectionTechnology/ScanType: attribute is required!");
            }
            this.setScanTypeValue(value);
            value = attris.getValue("ACExcludeChildProcesses");
            if (value != null) {
                this.aCExcludeChildProcesses = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"ProtectionTechnology".equals(element.getNodeName())) {
            throw new ValidationException("ProtectionTechnology: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "ScanType");
        if (value == null) {
            throw new ValidationException("ProtectionTechnology/ScanType: attribute is required!");
        }
        this.setScanTypeValue(value);
        value = XMLHelper.getAttribute(element, "ACExcludeChildProcesses");
        if (value != null) {
            this.aCExcludeChildProcesses = "1".equals(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("ProtectionTechnology/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("ProtectionTechnology/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("ProtectionTechnology");
        if (this.scanType != null) {
            element.setAttribute("ScanType", this.getScanTypeValue());
        }
        if (this.aCExcludeChildProcesses != null) {
            element.setAttribute("ACExcludeChildProcesses", this.aCExcludeChildProcesses != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ProtectionTechnology ");
            if (this.scanType != null) {
                strAttrs.append("ScanType=\"").append(this.getScanTypeValue()).append("\" ");
            }
            if (this.aCExcludeChildProcesses != null) {
                strAttrs.append("ACExcludeChildProcesses=").append(this.aCExcludeChildProcesses != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ProtectionTechnology>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

