/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.TransportServerCertificate;
import com.sygate.scm.util.Utility;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PrivateInsightServer
extends ConfigObject
implements NamedObject {
    public static final Integer HTTP = 0;
    public static final Integer HTTPS = 1;
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private String refId;
    private String edrConnectToken;
    private Boolean enable;
    private String address;
    private Integer port;
    private Integer protocol;
    private Boolean httpsVerifyCA;
    private Boolean legacyClientSupport;

    public PrivateInsightServer() {
        this(true);
    }

    public PrivateInsightServer(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(56, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "PrivateInsightServer";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.name = value;
    }

    @Override
    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.description = value;
    }

    @Override
    public String getOptRefId() {
        return this.refId;
    }

    public void setOptRefId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.refId = value;
    }

    public String getOptEdrConnectToken() {
        try {
            return Utility.decrypt(this.edrConnectToken);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setOptEdrConnectToken(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        try {
            this.edrConnectToken = Utility.encrypt(value);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Boolean getDefEnable() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.address = value;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.port = value;
    }

    public Integer getDefProtocol() {
        return HTTP;
    }

    public Integer getOptProtocol() {
        return this.protocol;
    }

    public String getOptProtocolValue() throws ValidationException {
        if (this.protocol == null) {
            return null;
        }
        String s = null;
        switch (this.protocol) {
            case 0: {
                s = "HTTP";
                break;
            }
            case 1: {
                s = "HTTPS";
                break;
            }
            default: {
                throw new ValidationException("PrivateInsightServer/Protocol: invalid attribute value:" + this.protocol + "!");
            }
        }
        return s;
    }

    public void setOptProtocol(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.protocol = value;
    }

    public void setOptProtocolValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.protocol = null;
            return;
        }
        if ("HTTP".equals(value)) {
            this.protocol = HTTP;
        } else if ("HTTPS".equals(value)) {
            this.protocol = HTTPS;
        } else {
            throw new ValidationException("PrivateInsightServer/Protocol: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefHttpsVerifyCA() {
        return Boolean.FALSE;
    }

    public Boolean getOptHttpsVerifyCA() {
        return this.httpsVerifyCA;
    }

    public void setOptHttpsVerifyCA(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.httpsVerifyCA = value;
    }

    public Boolean getDefLegacyClientSupport() {
        return Boolean.FALSE;
    }

    public Boolean getOptLegacyClientSupport() {
        return this.legacyClientSupport;
    }

    public void setOptLegacyClientSupport(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.legacyClientSupport = value;
    }

    public void addTransportServerCertificate(TransportServerCertificate value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addTransportServerCertificate(int index, TransportServerCertificate value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<TransportServerCertificate> getTransportServerCertificate() {
        Vector<TransportServerCertificate> v = new Vector<TransportServerCertificate>();
        for (Transportable child : (ChildGroup)this.children.get(56)) {
            v.add((TransportServerCertificate)child);
        }
        return v;
    }

    public int getTransportServerCertificateCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(56);
        return childGroup.size();
    }

    public TransportServerCertificate getTransportServerCertificate(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(56);
        return (TransportServerCertificate)childGroup.get(index);
    }

    public void setTransportServerCertificate(int index, TransportServerCertificate value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeTransportServerCertificate(TransportServerCertificate value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 811;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.name == null) {
            throw new ValidationException("PrivateInsightServer/Name: attribute is required!");
        }
        if (this.address == null) {
            throw new ValidationException("PrivateInsightServer/Address: attribute is required!");
        }
        if (this.port == null) {
            throw new ValidationException("PrivateInsightServer/Port: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof TransportServerCertificate) {
            try {
                this.addTransportServerCertificate((TransportServerCertificate)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("PrivateInsightServer/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Description");
            if (value != null) {
                this.description = value;
            }
            if ((value = attris.getValue("RefId")) != null) {
                this.refId = value;
            }
            if ((value = attris.getValue("EdrConnectToken")) != null) {
                this.edrConnectToken = value;
            }
            if ((value = attris.getValue("Enable")) != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("Address")) == null) {
                throw new ValidationException("PrivateInsightServer/Address: attribute is required!");
            }
            this.address = value;
            value = attris.getValue("Port");
            if (value == null) {
                throw new ValidationException("PrivateInsightServer/Port: attribute is required!");
            }
            try {
                this.port = Integer.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("PrivateInsightServer/Port: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("PrivateInsightServer/Port: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("Protocol");
            if (value != null) {
                this.setOptProtocolValue(value);
            }
            if ((value = attris.getValue("HttpsVerifyCA")) != null) {
                this.httpsVerifyCA = "1".equals(value);
            }
            if ((value = attris.getValue("LegacyClientSupport")) != null) {
                this.legacyClientSupport = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getTransportServerCertificateCount();
        for (i = 0; i < objCnt; ++i) {
            this.getTransportServerCertificate(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"PrivateInsightServer".equals(element.getNodeName())) {
            throw new ValidationException("PrivateInsightServer: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("PrivateInsightServer/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Description");
        if (value != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RefId")) != null) {
            this.refId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "EdrConnectToken")) != null) {
            this.edrConnectToken = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Enable")) != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Address")) == null) {
            throw new ValidationException("PrivateInsightServer/Address: attribute is required!");
        }
        this.address = value;
        value = XMLHelper.getAttribute(element, "Port");
        if (value == null) {
            throw new ValidationException("PrivateInsightServer/Port: attribute is required!");
        }
        try {
            this.port = Integer.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("PrivateInsightServer/Port: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("PrivateInsightServer/Port: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "Protocol");
        if (value != null) {
            this.setOptProtocolValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "HttpsVerifyCA")) != null) {
            this.httpsVerifyCA = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LegacyClientSupport")) != null) {
            this.legacyClientSupport = "1".equals(value);
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "TransportServerCertificate");
        for (int i = 0; i < v.size(); ++i) {
            TransportServerCertificate transportServerCertificateObj = new TransportServerCertificate();
            transportServerCertificateObj.importFromElement(v.get(i));
            this.addTransportServerCertificate(transportServerCertificateObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("PrivateInsightServer/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("PrivateInsightServer/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("PrivateInsightServer");
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.refId != null) {
            element.setAttribute("RefId", this.refId);
        }
        if (this.edrConnectToken != null) {
            element.setAttribute("EdrConnectToken", this.edrConnectToken);
        }
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.address != null) {
            element.setAttribute("Address", this.address);
        }
        if (this.port != null) {
            element.setAttribute("Port", this.port.toString());
        }
        if (this.protocol != null) {
            element.setAttribute("Protocol", this.getOptProtocolValue());
        }
        if (this.httpsVerifyCA != null) {
            element.setAttribute("HttpsVerifyCA", this.httpsVerifyCA != false ? "1" : "0");
        }
        if (this.legacyClientSupport != null) {
            element.setAttribute("LegacyClientSupport", this.legacyClientSupport != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<PrivateInsightServer ");
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.refId != null) {
                strAttrs.append("RefId=\"").append(AbstractSchema.checkXMLContent(this.refId)).append("\" ");
            }
            if (this.edrConnectToken != null) {
                strAttrs.append("EdrConnectToken=\"").append(AbstractSchema.checkXMLContent(this.edrConnectToken)).append("\" ");
            }
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.address != null) {
                strAttrs.append("Address=\"").append(AbstractSchema.checkXMLContent(this.address)).append("\" ");
            }
            if (this.port != null) {
                strAttrs.append("Port=\"").append(this.port.toString()).append("\" ");
            }
            if (this.protocol != null) {
                strAttrs.append("Protocol=\"").append(this.getOptProtocolValue()).append("\" ");
            }
            if (this.httpsVerifyCA != null) {
                strAttrs.append("HttpsVerifyCA=").append(this.httpsVerifyCA != false ? "\"1\" " : "\"0\" ");
            }
            if (this.legacyClientSupport != null) {
                strAttrs.append("LegacyClientSupport=").append(this.legacyClientSupport != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</PrivateInsightServer>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

