/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PrevalenceRule
extends ConfigObject {
    public static final Integer LEARNING = 0;
    public static final Integer ZERO = 1;
    public static final Integer LOW = 2;
    public static final Integer MED = 3;
    public static final Integer HIGH = 4;
    private static final long serialVersionUID = 1L;
    private String virusId;
    private Integer prevalence;
    private Integer prevalencePercentage;

    public PrevalenceRule() {
        this(true);
    }

    public PrevalenceRule(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "PrevalenceRule";
    }

    public String getOptVirusId() {
        return this.virusId;
    }

    public void setOptVirusId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.virusId = value;
    }

    public Integer getDefPrevalence() {
        return LEARNING;
    }

    public Integer getOptPrevalence() {
        return this.prevalence;
    }

    public String getOptPrevalenceValue() throws ValidationException {
        if (this.prevalence == null) {
            return null;
        }
        String s = null;
        switch (this.prevalence) {
            case 0: {
                s = "LEARNING";
                break;
            }
            case 1: {
                s = "ZERO";
                break;
            }
            case 2: {
                s = "LOW";
                break;
            }
            case 3: {
                s = "MED";
                break;
            }
            case 4: {
                s = "HIGH";
                break;
            }
            default: {
                throw new ValidationException("PrevalenceRule/Prevalence: invalid attribute value:" + this.prevalence + "!");
            }
        }
        return s;
    }

    public void setOptPrevalence(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.prevalence = value;
    }

    public void setOptPrevalenceValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.prevalence = null;
            return;
        }
        if ("LEARNING".equals(value)) {
            this.prevalence = LEARNING;
        } else if ("ZERO".equals(value)) {
            this.prevalence = ZERO;
        } else if ("LOW".equals(value)) {
            this.prevalence = LOW;
        } else if ("MED".equals(value)) {
            this.prevalence = MED;
        } else if ("HIGH".equals(value)) {
            this.prevalence = HIGH;
        } else {
            throw new ValidationException("PrevalenceRule/Prevalence: invalid attribute value:" + value + "!");
        }
    }

    public Integer getDefPrevalencePercentage() {
        return 0;
    }

    public Integer getOptPrevalencePercentage() {
        return this.prevalencePercentage;
    }

    public void setOptPrevalencePercentage(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.prevalencePercentage = value;
    }

    @Override
    public int getObjectType() {
        return 845;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("VirusId");
            if (value != null) {
                this.virusId = value;
            }
            if ((value = attris.getValue("Prevalence")) != null) {
                this.setOptPrevalenceValue(value);
            }
            if ((value = attris.getValue("PrevalencePercentage")) != null) {
                try {
                    this.prevalencePercentage = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("PrevalenceRule/PrevalencePercentage: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("PrevalenceRule/PrevalencePercentage: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"PrevalenceRule".equals(element.getNodeName())) {
            throw new ValidationException("PrevalenceRule: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "VirusId");
        if (value != null) {
            this.virusId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Prevalence")) != null) {
            this.setOptPrevalenceValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "PrevalencePercentage")) != null) {
            try {
                this.prevalencePercentage = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("PrevalenceRule/PrevalencePercentage: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("PrevalenceRule/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("PrevalenceRule/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("PrevalenceRule");
        if (this.virusId != null) {
            element.setAttribute("VirusId", this.virusId);
        }
        if (this.prevalence != null) {
            element.setAttribute("Prevalence", this.getOptPrevalenceValue());
        }
        if (this.prevalencePercentage != null) {
            element.setAttribute("PrevalencePercentage", this.prevalencePercentage.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<PrevalenceRule ");
            if (this.virusId != null) {
                strAttrs.append("VirusId=\"").append(AbstractSchema.checkXMLContent(this.virusId)).append("\" ");
            }
            if (this.prevalence != null) {
                strAttrs.append("Prevalence=\"").append(this.getOptPrevalenceValue()).append("\" ");
            }
            if (this.prevalencePercentage != null) {
                strAttrs.append("PrevalencePercentage=\"").append(this.prevalencePercentage.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</PrevalenceRule>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

