/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.PluginData;
import com.sygate.scm.common.configobject.schema.PluginProfile;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PluginConfig
extends TopLevelObject
implements NamedObject {
    public static final Integer LOG = 0;
    public static final Integer IGNORE = 1;
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String description;
    private String refId;
    private String provider;
    private String version;
    private String serialNo;
    private Integer actionOnPluginMissing;

    public PluginConfig() {
        this(true);
    }

    public PluginConfig(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(581, new ChildGroup(0, 1));
        this.children.put(582, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "PluginConfig";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.id = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.name = value;
    }

    @Override
    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.description = value;
    }

    @Override
    public String getOptRefId() {
        return this.refId;
    }

    public void setOptRefId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.refId = value;
    }

    public String getOptProvider() {
        return this.provider;
    }

    public void setOptProvider(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.provider = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.version = value;
    }

    public String getOptSerialNo() {
        return this.serialNo;
    }

    public void setOptSerialNo(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.serialNo = value;
    }

    public Integer getDefActionOnPluginMissing() {
        return LOG;
    }

    public Integer getOptActionOnPluginMissing() {
        return this.actionOnPluginMissing;
    }

    public String getOptActionOnPluginMissingValue() throws ValidationException {
        if (this.actionOnPluginMissing == null) {
            return null;
        }
        String s = null;
        switch (this.actionOnPluginMissing) {
            case 0: {
                s = "LOG";
                break;
            }
            case 1: {
                s = "IGNORE";
                break;
            }
            default: {
                throw new ValidationException("PluginConfig/ActionOnPluginMissing: invalid attribute value:" + this.actionOnPluginMissing + "!");
            }
        }
        return s;
    }

    public void setOptActionOnPluginMissing(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.actionOnPluginMissing = value;
    }

    public void setOptActionOnPluginMissingValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.actionOnPluginMissing = null;
            return;
        }
        if ("LOG".equals(value)) {
            this.actionOnPluginMissing = LOG;
        } else if ("IGNORE".equals(value)) {
            this.actionOnPluginMissing = IGNORE;
        } else {
            throw new ValidationException("PluginConfig/ActionOnPluginMissing: invalid attribute value:" + value + "!");
        }
    }

    public PluginProfile getOptPluginProfile() {
        ChildGroup childGroup = (ChildGroup)this.children.get(581);
        if (childGroup.size() > 0) {
            return (PluginProfile)childGroup.get(0);
        }
        return null;
    }

    public void setOptPluginProfile(PluginProfile value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            PluginProfile obj = this.getOptPluginProfile();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public PluginData getOptPluginData() {
        ChildGroup childGroup = (ChildGroup)this.children.get(582);
        if (childGroup.size() > 0) {
            return (PluginData)childGroup.get(0);
        }
        return null;
    }

    public void setOptPluginData(PluginData value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            PluginData obj = this.getOptPluginData();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 580;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.id == null) {
            throw new ValidationException("PluginConfig/Id: attribute is required!");
        }
        if (this.name == null) {
            throw new ValidationException("PluginConfig/Name: attribute is required!");
        }
        if (this.version == null) {
            throw new ValidationException("PluginConfig/Version: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof PluginProfile) {
            try {
                this.setOptPluginProfile((PluginProfile)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof PluginData) {
            try {
                this.setOptPluginData((PluginData)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Id");
            if (value == null) {
                throw new ValidationException("PluginConfig/Id: attribute is required!");
            }
            this.id = value;
            value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("PluginConfig/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Description");
            if (value != null) {
                this.description = value;
            }
            if ((value = attris.getValue("RefId")) != null) {
                this.refId = value;
            }
            if ((value = attris.getValue("Provider")) != null) {
                this.provider = value;
            }
            if ((value = attris.getValue("Version")) == null) {
                throw new ValidationException("PluginConfig/Version: attribute is required!");
            }
            this.version = value;
            value = attris.getValue("SerialNo");
            if (value != null) {
                this.serialNo = value;
            }
            if ((value = attris.getValue("ActionOnPluginMissing")) != null) {
                this.setOptActionOnPluginMissingValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptPluginProfile() != null) {
            this.getOptPluginProfile().setReadonly();
        }
        if (this.getOptPluginData() != null) {
            this.getOptPluginData().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"PluginConfig".equals(element.getNodeName())) {
            throw new ValidationException("PluginConfig: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Id");
        if (value == null) {
            throw new ValidationException("PluginConfig/Id: attribute is required!");
        }
        this.id = value;
        value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("PluginConfig/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Description");
        if (value != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RefId")) != null) {
            this.refId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Provider")) != null) {
            this.provider = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Version")) == null) {
            throw new ValidationException("PluginConfig/Version: attribute is required!");
        }
        this.version = value;
        value = XMLHelper.getAttribute(element, "SerialNo");
        if (value != null) {
            this.serialNo = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ActionOnPluginMissing")) != null) {
            this.setOptActionOnPluginMissingValue(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "PluginProfile")).size() > 0) {
            PluginProfile pluginProfileObj = new PluginProfile();
            pluginProfileObj.importFromElement(v.get(0));
            this.setOptPluginProfile(pluginProfileObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "PluginData")).size() > 0) {
            PluginData pluginDataObj = new PluginData();
            pluginDataObj.importFromElement(v.get(0));
            this.setOptPluginData(pluginDataObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("PluginConfig/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("PluginConfig/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("PluginConfig");
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.refId != null) {
            element.setAttribute("RefId", this.refId);
        }
        if (this.provider != null) {
            element.setAttribute("Provider", this.provider);
        }
        if (this.version != null) {
            element.setAttribute("Version", this.version);
        }
        if (this.serialNo != null) {
            element.setAttribute("SerialNo", this.serialNo);
        }
        if (this.actionOnPluginMissing != null) {
            element.setAttribute("ActionOnPluginMissing", this.getOptActionOnPluginMissingValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<PluginConfig ");
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.refId != null) {
                strAttrs.append("RefId=\"").append(AbstractSchema.checkXMLContent(this.refId)).append("\" ");
            }
            if (this.provider != null) {
                strAttrs.append("Provider=\"").append(AbstractSchema.checkXMLContent(this.provider)).append("\" ");
            }
            if (this.version != null) {
                strAttrs.append("Version=\"").append(AbstractSchema.checkXMLContent(this.version)).append("\" ");
            }
            if (this.serialNo != null) {
                strAttrs.append("SerialNo=\"").append(AbstractSchema.checkXMLContent(this.serialNo)).append("\" ");
            }
            if (this.actionOnPluginMissing != null) {
                strAttrs.append("ActionOnPluginMissing=\"").append(this.getOptActionOnPluginMissingValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</PluginConfig>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

