/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.ObjReference;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PhysicalFile
extends TopLevelObject
implements NamedObject {
    public static final Integer UNKNOWN = 0;
    public static final Integer FULL = 1;
    public static final Integer INC_FWD_DELTA = 2;
    public static final Integer INC_REV_DELTA = 3;
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String description;
    private String refId;
    private Long creationTime;
    private String fileName;
    private Long fileLastModifiedTime;
    private Long fileSize;
    private String fileChecksum;
    private Integer fileType;

    public PhysicalFile() {
        this(true);
    }

    public PhysicalFile(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(3, new ChildGroup(1, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "PhysicalFile";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.id = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.name = value;
    }

    @Override
    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.description = value;
    }

    @Override
    public String getOptRefId() {
        return this.refId;
    }

    public void setOptRefId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.refId = value;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.creationTime = value;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.fileName = value;
    }

    public Long getFileLastModifiedTime() {
        return this.fileLastModifiedTime;
    }

    public void setFileLastModifiedTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.fileLastModifiedTime = value;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.fileSize = value;
    }

    public String getFileChecksum() {
        return this.fileChecksum;
    }

    public void setFileChecksum(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.fileChecksum = value;
    }

    public Integer getDefFileType() {
        return UNKNOWN;
    }

    public Integer getOptFileType() {
        return this.fileType;
    }

    public String getOptFileTypeValue() throws ValidationException {
        if (this.fileType == null) {
            return null;
        }
        String s = null;
        switch (this.fileType) {
            case 0: {
                s = "UNKNOWN";
                break;
            }
            case 1: {
                s = "FULL";
                break;
            }
            case 2: {
                s = "INC_FWD_DELTA";
                break;
            }
            case 3: {
                s = "INC_REV_DELTA";
                break;
            }
            default: {
                throw new ValidationException("PhysicalFile/FileType: invalid attribute value:" + this.fileType + "!");
            }
        }
        return s;
    }

    public void setOptFileType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.fileType = value;
    }

    public void setOptFileTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.fileType = null;
            return;
        }
        if ("UNKNOWN".equals(value)) {
            this.fileType = UNKNOWN;
        } else if ("FULL".equals(value)) {
            this.fileType = FULL;
        } else if ("INC_FWD_DELTA".equals(value)) {
            this.fileType = INC_FWD_DELTA;
        } else if ("INC_REV_DELTA".equals(value)) {
            this.fileType = INC_REV_DELTA;
        } else {
            throw new ValidationException("PhysicalFile/FileType: invalid attribute value:" + value + "!");
        }
    }

    public ObjReference getObjReference() {
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        if (childGroup.size() > 0) {
            return (ObjReference)childGroup.get(0);
        }
        return null;
    }

    public void setObjReference(ObjReference value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ObjReference obj = this.getObjReference();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 181;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.id == null) {
            throw new ValidationException("PhysicalFile/Id: attribute is required!");
        }
        if (this.name == null) {
            throw new ValidationException("PhysicalFile/Name: attribute is required!");
        }
        if (this.creationTime == null) {
            throw new ValidationException("PhysicalFile/CreationTime: attribute is required!");
        }
        if (this.fileName == null) {
            throw new ValidationException("PhysicalFile/FileName: attribute is required!");
        }
        if (this.fileLastModifiedTime == null) {
            throw new ValidationException("PhysicalFile/FileLastModifiedTime: attribute is required!");
        }
        if (this.fileSize == null) {
            throw new ValidationException("PhysicalFile/FileSize: attribute is required!");
        }
        if (this.fileChecksum == null) {
            throw new ValidationException("PhysicalFile/FileChecksum: attribute is required!");
        }
        if (this.getObjReference() == null) {
            throw new ValidationException("PhysicalFile/ObjReference: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof ObjReference) {
            try {
                this.setObjReference((ObjReference)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Id");
            if (value == null) {
                throw new ValidationException("PhysicalFile/Id: attribute is required!");
            }
            this.id = value;
            value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("PhysicalFile/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Description");
            if (value != null) {
                this.description = value;
            }
            if ((value = attris.getValue("RefId")) != null) {
                this.refId = value;
            }
            if ((value = attris.getValue("CreationTime")) == null) {
                throw new ValidationException("PhysicalFile/CreationTime: attribute is required!");
            }
            try {
                this.creationTime = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("PhysicalFile/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("PhysicalFile/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("FileName");
            if (value == null) {
                throw new ValidationException("PhysicalFile/FileName: attribute is required!");
            }
            this.fileName = value;
            value = attris.getValue("FileLastModifiedTime");
            if (value == null) {
                throw new ValidationException("PhysicalFile/FileLastModifiedTime: attribute is required!");
            }
            try {
                this.fileLastModifiedTime = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("PhysicalFile/FileLastModifiedTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("PhysicalFile/FileLastModifiedTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("FileSize");
            if (value == null) {
                throw new ValidationException("PhysicalFile/FileSize: attribute is required!");
            }
            try {
                this.fileSize = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("PhysicalFile/FileSize: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("PhysicalFile/FileSize: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("FileChecksum");
            if (value == null) {
                throw new ValidationException("PhysicalFile/FileChecksum: attribute is required!");
            }
            this.fileChecksum = value;
            value = attris.getValue("FileType");
            if (value != null) {
                this.setOptFileTypeValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getObjReference() != null) {
            this.getObjReference().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(3)).size();
        }
        catch (Throwable t) {
            throw new SAXException("PhysicalFile: can't import element == ObjReference!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"PhysicalFile".equals(element.getNodeName())) {
            throw new ValidationException("PhysicalFile: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Id");
        if (value == null) {
            throw new ValidationException("PhysicalFile/Id: attribute is required!");
        }
        this.id = value;
        value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("PhysicalFile/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Description");
        if (value != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RefId")) != null) {
            this.refId = value;
        }
        if ((value = XMLHelper.getAttribute(element, "CreationTime")) == null) {
            throw new ValidationException("PhysicalFile/CreationTime: attribute is required!");
        }
        try {
            this.creationTime = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("PhysicalFile/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("PhysicalFile/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "FileName");
        if (value == null) {
            throw new ValidationException("PhysicalFile/FileName: attribute is required!");
        }
        this.fileName = value;
        value = XMLHelper.getAttribute(element, "FileLastModifiedTime");
        if (value == null) {
            throw new ValidationException("PhysicalFile/FileLastModifiedTime: attribute is required!");
        }
        try {
            this.fileLastModifiedTime = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("PhysicalFile/FileLastModifiedTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("PhysicalFile/FileLastModifiedTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "FileSize");
        if (value == null) {
            throw new ValidationException("PhysicalFile/FileSize: attribute is required!");
        }
        try {
            this.fileSize = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("PhysicalFile/FileSize: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("PhysicalFile/FileSize: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "FileChecksum");
        if (value == null) {
            throw new ValidationException("PhysicalFile/FileChecksum: attribute is required!");
        }
        this.fileChecksum = value;
        value = XMLHelper.getAttribute(element, "FileType");
        if (value != null) {
            this.setOptFileTypeValue(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "ObjReference")).size() != 1) {
            throw new ValidationException("PhysicalFile/ObjReference: element is require!");
        }
        ObjReference objReferenceObj = new ObjReference();
        objReferenceObj.importFromElement(v.get(0));
        this.setObjReference(objReferenceObj);
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("PhysicalFile/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("PhysicalFile/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("PhysicalFile");
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.refId != null) {
            element.setAttribute("RefId", this.refId);
        }
        if (this.creationTime != null) {
            element.setAttribute("CreationTime", this.creationTime.toString());
        }
        if (this.fileName != null) {
            element.setAttribute("FileName", this.fileName);
        }
        if (this.fileLastModifiedTime != null) {
            element.setAttribute("FileLastModifiedTime", this.fileLastModifiedTime.toString());
        }
        if (this.fileSize != null) {
            element.setAttribute("FileSize", this.fileSize.toString());
        }
        if (this.fileChecksum != null) {
            element.setAttribute("FileChecksum", this.fileChecksum);
        }
        if (this.fileType != null) {
            element.setAttribute("FileType", this.getOptFileTypeValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<PhysicalFile ");
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.refId != null) {
                strAttrs.append("RefId=\"").append(AbstractSchema.checkXMLContent(this.refId)).append("\" ");
            }
            if (this.creationTime != null) {
                strAttrs.append("CreationTime=\"").append(this.creationTime.toString()).append("\" ");
            }
            if (this.fileName != null) {
                strAttrs.append("FileName=\"").append(AbstractSchema.checkXMLContent(this.fileName)).append("\" ");
            }
            if (this.fileLastModifiedTime != null) {
                strAttrs.append("FileLastModifiedTime=\"").append(this.fileLastModifiedTime.toString()).append("\" ");
            }
            if (this.fileSize != null) {
                strAttrs.append("FileSize=\"").append(this.fileSize.toString()).append("\" ");
            }
            if (this.fileChecksum != null) {
                strAttrs.append("FileChecksum=\"").append(AbstractSchema.checkXMLContent(this.fileChecksum)).append("\" ");
            }
            if (this.fileType != null) {
                strAttrs.append("FileType=\"").append(this.getOptFileTypeValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</PhysicalFile>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

