/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PackageSource
extends ConfigObject {
    public static final Integer SEM_SERVER = 0;
    public static final Integer EXTERNAL_URL = 1;
    private static final long serialVersionUID = 1L;
    private Integer sourceServer;
    private String packageSourceExternalUrl;

    public PackageSource() {
        this(true);
    }

    public PackageSource(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "PackageSource";
    }

    public Integer getSourceServer() {
        return this.sourceServer;
    }

    public String getSourceServerValue() throws ValidationException {
        if (this.sourceServer == null) {
            return null;
        }
        String s = null;
        switch (this.sourceServer) {
            case 0: {
                s = "SEM_SERVER";
                break;
            }
            case 1: {
                s = "EXTERNAL_URL";
                break;
            }
            default: {
                throw new ValidationException("PackageSource/SourceServer: invalid attribute value:" + this.sourceServer + "!");
            }
        }
        return s;
    }

    public void setSourceServer(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.sourceServer = value;
    }

    public void setSourceServerValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("SEM_SERVER".equals(value)) {
            this.sourceServer = SEM_SERVER;
        } else if ("EXTERNAL_URL".equals(value)) {
            this.sourceServer = EXTERNAL_URL;
        } else {
            throw new ValidationException("PackageSource/SourceServer: invalid attribute value:" + value + "!");
        }
    }

    public String getOptPackageSourceExternalUrl() {
        return this.packageSourceExternalUrl;
    }

    public void setOptPackageSourceExternalUrl(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.packageSourceExternalUrl = value;
    }

    @Override
    public int getObjectType() {
        return 233;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.sourceServer == null) {
            throw new ValidationException("PackageSource/SourceServer: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("SourceServer");
            if (value == null) {
                throw new ValidationException("PackageSource/SourceServer: attribute is required!");
            }
            this.setSourceServerValue(value);
            value = attris.getValue("PackageSourceExternalUrl");
            if (value != null) {
                this.packageSourceExternalUrl = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"PackageSource".equals(element.getNodeName())) {
            throw new ValidationException("PackageSource: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "SourceServer");
        if (value == null) {
            throw new ValidationException("PackageSource/SourceServer: attribute is required!");
        }
        this.setSourceServerValue(value);
        value = XMLHelper.getAttribute(element, "PackageSourceExternalUrl");
        if (value != null) {
            this.packageSourceExternalUrl = value;
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("PackageSource/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("PackageSource/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("PackageSource");
        if (this.sourceServer != null) {
            element.setAttribute("SourceServer", this.getSourceServerValue());
        }
        if (this.packageSourceExternalUrl != null) {
            element.setAttribute("PackageSourceExternalUrl", this.packageSourceExternalUrl);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<PackageSource ");
            if (this.sourceServer != null) {
                strAttrs.append("SourceServer=\"").append(this.getSourceServerValue()).append("\" ");
            }
            if (this.packageSourceExternalUrl != null) {
                strAttrs.append("PackageSourceExternalUrl=\"").append(AbstractSchema.checkXMLContent(this.packageSourceExternalUrl)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</PackageSource>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

