/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.PackageLuFile;
import com.sygate.scm.common.configobject.schema.PackageLuInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PackageInfo
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Integer type;
    private String version;
    private Boolean securityFixPackage;
    private String productBuildNum;
    private Long size;
    private Long unZippedSize;
    private Long pkgSizeWithoutDefs;
    private Long creationTime;
    private Long lastModifiedTime;
    private String lanuage;
    private String checksum;
    private String platformType;
    private String packageName;
    private String releaseNotesUrl;

    public PackageInfo() {
        this(true);
    }

    public PackageInfo(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(3, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(177, new ChildGroup(0, 1));
        this.children.put(178, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "PackageInfo";
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.type = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.version = value;
    }

    public Boolean getOptSecurityFixPackage() {
        return this.securityFixPackage;
    }

    public void setOptSecurityFixPackage(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.securityFixPackage = value;
    }

    public String getOptProductBuildNum() {
        return this.productBuildNum;
    }

    public void setOptProductBuildNum(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.productBuildNum = value;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.size = value;
    }

    public Long getOptUnZippedSize() {
        return this.unZippedSize;
    }

    public void setOptUnZippedSize(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.unZippedSize = value;
    }

    public Long getOptPkgSizeWithoutDefs() {
        return this.pkgSizeWithoutDefs;
    }

    public void setOptPkgSizeWithoutDefs(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.pkgSizeWithoutDefs = value;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.creationTime = value;
    }

    public Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lastModifiedTime = value;
    }

    public String getOptLanuage() {
        return this.lanuage;
    }

    public void setOptLanuage(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.lanuage = value;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.checksum = value;
    }

    public String getDefPlatformType() {
        return "WIN32BIT";
    }

    public String getOptPlatformType() {
        return this.platformType;
    }

    public void setOptPlatformType(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.platformType = value;
    }

    public String getDefPackageName() {
        return "Symantec AntiVirus.msi";
    }

    public String getOptPackageName() {
        return this.packageName;
    }

    public void setOptPackageName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.packageName = value;
    }

    public String getOptReleaseNotesUrl() {
        return this.releaseNotesUrl;
    }

    public void setOptReleaseNotesUrl(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.releaseNotesUrl = value;
    }

    public void addObjReference(ObjReference value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addObjReference(int index, ObjReference value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<ObjReference> getObjReference() {
        Vector<ObjReference> v = new Vector<ObjReference>();
        for (Transportable child : (ChildGroup)this.children.get(3)) {
            v.add((ObjReference)child);
        }
        return v;
    }

    public int getObjReferenceCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        return childGroup.size();
    }

    public ObjReference getObjReference(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        return (ObjReference)childGroup.get(index);
    }

    public ObjReference getObjReferenceByType(String type) {
        if (type == null) {
            return null;
        }
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        for (int i = 0; i < childGroup.size(); ++i) {
            ObjReference reference = (ObjReference)childGroup.get(i);
            if (!type.equals(reference.getTargetType())) continue;
            return reference;
        }
        return null;
    }

    public ObjReference getObjReferenceByTypeAndName(String type, String name) {
        if (type == null || name == null) {
            return null;
        }
        ChildGroup childGroup = (ChildGroup)this.children.get(3);
        for (int i = 0; i < childGroup.size(); ++i) {
            ObjReference reference = (ObjReference)childGroup.get(i);
            if (!type.equals(reference.getTargetType()) || !name.equals(reference.getName())) continue;
            return reference;
        }
        return null;
    }

    public void setObjReference(int index, ObjReference value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeObjReference(ObjReference value) {
        this.removeChild(value);
    }

    public PackageLuInfo getOptPackageLuInfo() {
        ChildGroup childGroup = (ChildGroup)this.children.get(177);
        if (childGroup.size() > 0) {
            return (PackageLuInfo)childGroup.get(0);
        }
        return null;
    }

    public void setOptPackageLuInfo(PackageLuInfo value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            PackageLuInfo obj = this.getOptPackageLuInfo();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public void addPackageLuFile(PackageLuFile value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addPackageLuFile(int index, PackageLuFile value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<PackageLuFile> getPackageLuFile() {
        Vector<PackageLuFile> v = new Vector<PackageLuFile>();
        for (Transportable child : (ChildGroup)this.children.get(178)) {
            v.add((PackageLuFile)child);
        }
        return v;
    }

    public int getPackageLuFileCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(178);
        return childGroup.size();
    }

    public PackageLuFile getPackageLuFile(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(178);
        return (PackageLuFile)childGroup.get(index);
    }

    public void setPackageLuFile(int index, PackageLuFile value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removePackageLuFile(PackageLuFile value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 176;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.type == null) {
            throw new ValidationException("PackageInfo/Type: attribute is required!");
        }
        if (this.version == null) {
            throw new ValidationException("PackageInfo/Version: attribute is required!");
        }
        if (this.size == null) {
            throw new ValidationException("PackageInfo/Size: attribute is required!");
        }
        if (this.creationTime == null) {
            throw new ValidationException("PackageInfo/CreationTime: attribute is required!");
        }
        if (this.lastModifiedTime == null) {
            throw new ValidationException("PackageInfo/LastModifiedTime: attribute is required!");
        }
        if (this.checksum == null) {
            throw new ValidationException("PackageInfo/Checksum: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof ObjReference) {
            try {
                this.addObjReference((ObjReference)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof PackageLuInfo) {
            try {
                this.setOptPackageLuInfo((PackageLuInfo)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof PackageLuFile) {
            try {
                this.addPackageLuFile((PackageLuFile)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Type");
            if (value == null) {
                throw new ValidationException("PackageInfo/Type: attribute is required!");
            }
            try {
                this.type = Integer.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("PackageInfo/Type: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("PackageInfo/Type: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("Version");
            if (value == null) {
                throw new ValidationException("PackageInfo/Version: attribute is required!");
            }
            this.version = value;
            value = attris.getValue("SecurityFixPackage");
            if (value != null) {
                this.securityFixPackage = "1".equals(value);
            }
            if ((value = attris.getValue("ProductBuildNum")) != null) {
                this.productBuildNum = value;
            }
            if ((value = attris.getValue("Size")) == null) {
                throw new ValidationException("PackageInfo/Size: attribute is required!");
            }
            try {
                this.size = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("PackageInfo/Size: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("PackageInfo/Size: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("UnZippedSize");
            if (value != null) {
                try {
                    this.unZippedSize = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("PackageInfo/UnZippedSize: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("PackageInfo/UnZippedSize: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("PkgSizeWithoutDefs")) != null) {
                try {
                    this.pkgSizeWithoutDefs = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("PackageInfo/PkgSizeWithoutDefs: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("PackageInfo/PkgSizeWithoutDefs: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("CreationTime")) == null) {
                throw new ValidationException("PackageInfo/CreationTime: attribute is required!");
            }
            try {
                this.creationTime = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("PackageInfo/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("PackageInfo/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("LastModifiedTime");
            if (value == null) {
                throw new ValidationException("PackageInfo/LastModifiedTime: attribute is required!");
            }
            try {
                this.lastModifiedTime = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("PackageInfo/LastModifiedTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("PackageInfo/LastModifiedTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("Lanuage");
            if (value != null) {
                this.lanuage = value;
            }
            if ((value = attris.getValue("Checksum")) == null) {
                throw new ValidationException("PackageInfo/Checksum: attribute is required!");
            }
            this.checksum = value;
            value = attris.getValue("PlatformType");
            if (value != null) {
                this.platformType = value;
            }
            if ((value = attris.getValue("PackageName")) != null) {
                this.packageName = value;
            }
            if ((value = attris.getValue("ReleaseNotesUrl")) != null) {
                this.releaseNotesUrl = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getObjReferenceCount();
        for (i = 0; i < objCnt; ++i) {
            this.getObjReference(i).setReadonly();
        }
        if (this.getOptPackageLuInfo() != null) {
            this.getOptPackageLuInfo().setReadonly();
        }
        objCnt = this.getPackageLuFileCount();
        for (i = 0; i < objCnt; ++i) {
            this.getPackageLuFile(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        int i;
        if (!"PackageInfo".equals(element.getNodeName())) {
            throw new ValidationException("PackageInfo: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Type");
        if (value == null) {
            throw new ValidationException("PackageInfo/Type: attribute is required!");
        }
        try {
            this.type = Integer.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("PackageInfo/Type: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("PackageInfo/Type: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "Version");
        if (value == null) {
            throw new ValidationException("PackageInfo/Version: attribute is required!");
        }
        this.version = value;
        value = XMLHelper.getAttribute(element, "SecurityFixPackage");
        if (value != null) {
            this.securityFixPackage = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ProductBuildNum")) != null) {
            this.productBuildNum = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Size")) == null) {
            throw new ValidationException("PackageInfo/Size: attribute is required!");
        }
        try {
            this.size = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("PackageInfo/Size: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("PackageInfo/Size: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "UnZippedSize");
        if (value != null) {
            try {
                this.unZippedSize = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("PackageInfo/UnZippedSize: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "PkgSizeWithoutDefs")) != null) {
            try {
                this.pkgSizeWithoutDefs = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("PackageInfo/PkgSizeWithoutDefs: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "CreationTime")) == null) {
            throw new ValidationException("PackageInfo/CreationTime: attribute is required!");
        }
        try {
            this.creationTime = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("PackageInfo/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("PackageInfo/CreationTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "LastModifiedTime");
        if (value == null) {
            throw new ValidationException("PackageInfo/LastModifiedTime: attribute is required!");
        }
        try {
            this.lastModifiedTime = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("PackageInfo/LastModifiedTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("PackageInfo/LastModifiedTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "Lanuage");
        if (value != null) {
            this.lanuage = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Checksum")) == null) {
            throw new ValidationException("PackageInfo/Checksum: attribute is required!");
        }
        this.checksum = value;
        value = XMLHelper.getAttribute(element, "PlatformType");
        if (value != null) {
            this.platformType = value;
        }
        if ((value = XMLHelper.getAttribute(element, "PackageName")) != null) {
            this.packageName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ReleaseNotesUrl")) != null) {
            this.releaseNotesUrl = value;
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "ObjReference");
        for (i = 0; i < v.size(); ++i) {
            ObjReference objReferenceObj = new ObjReference();
            objReferenceObj.importFromElement(v.get(i));
            this.addObjReference(objReferenceObj);
        }
        v = XMLHelper.getChildElementByName(element, "PackageLuInfo");
        if (v.size() > 0) {
            PackageLuInfo packageLuInfoObj = new PackageLuInfo();
            packageLuInfoObj.importFromElement(v.get(0));
            this.setOptPackageLuInfo(packageLuInfoObj);
        }
        v = XMLHelper.getChildElementByName(element, "PackageLuFile");
        for (i = 0; i < v.size(); ++i) {
            PackageLuFile packageLuFileObj = new PackageLuFile();
            packageLuFileObj.importFromElement(v.get(i));
            this.addPackageLuFile(packageLuFileObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i2 = 0; i2 < obsoleteItems.size(); ++i2) {
            Element e = obsoleteItems.get(i2);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("PackageInfo/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("PackageInfo/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("PackageInfo");
        if (this.type != null) {
            element.setAttribute("Type", this.type.toString());
        }
        if (this.version != null) {
            element.setAttribute("Version", this.version);
        }
        if (this.securityFixPackage != null) {
            element.setAttribute("SecurityFixPackage", this.securityFixPackage != false ? "1" : "0");
        }
        if (this.productBuildNum != null) {
            element.setAttribute("ProductBuildNum", this.productBuildNum);
        }
        if (this.size != null) {
            element.setAttribute("Size", this.size.toString());
        }
        if (this.unZippedSize != null) {
            element.setAttribute("UnZippedSize", this.unZippedSize.toString());
        }
        if (this.pkgSizeWithoutDefs != null) {
            element.setAttribute("PkgSizeWithoutDefs", this.pkgSizeWithoutDefs.toString());
        }
        if (this.creationTime != null) {
            element.setAttribute("CreationTime", this.creationTime.toString());
        }
        if (this.lastModifiedTime != null) {
            element.setAttribute("LastModifiedTime", this.lastModifiedTime.toString());
        }
        if (this.lanuage != null) {
            element.setAttribute("Lanuage", this.lanuage);
        }
        if (this.checksum != null) {
            element.setAttribute("Checksum", this.checksum);
        }
        if (this.platformType != null) {
            element.setAttribute("PlatformType", this.platformType);
        }
        if (this.packageName != null) {
            element.setAttribute("PackageName", this.packageName);
        }
        if (this.releaseNotesUrl != null) {
            element.setAttribute("ReleaseNotesUrl", this.releaseNotesUrl);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<PackageInfo ");
            if (this.type != null) {
                strAttrs.append("Type=\"").append(this.type.toString()).append("\" ");
            }
            if (this.version != null) {
                strAttrs.append("Version=\"").append(AbstractSchema.checkXMLContent(this.version)).append("\" ");
            }
            if (this.securityFixPackage != null) {
                strAttrs.append("SecurityFixPackage=").append(this.securityFixPackage != false ? "\"1\" " : "\"0\" ");
            }
            if (this.productBuildNum != null) {
                strAttrs.append("ProductBuildNum=\"").append(AbstractSchema.checkXMLContent(this.productBuildNum)).append("\" ");
            }
            if (this.size != null) {
                strAttrs.append("Size=\"").append(this.size.toString()).append("\" ");
            }
            if (this.unZippedSize != null) {
                strAttrs.append("UnZippedSize=\"").append(this.unZippedSize.toString()).append("\" ");
            }
            if (this.pkgSizeWithoutDefs != null) {
                strAttrs.append("PkgSizeWithoutDefs=\"").append(this.pkgSizeWithoutDefs.toString()).append("\" ");
            }
            if (this.creationTime != null) {
                strAttrs.append("CreationTime=\"").append(this.creationTime.toString()).append("\" ");
            }
            if (this.lastModifiedTime != null) {
                strAttrs.append("LastModifiedTime=\"").append(this.lastModifiedTime.toString()).append("\" ");
            }
            if (this.lanuage != null) {
                strAttrs.append("Lanuage=\"").append(AbstractSchema.checkXMLContent(this.lanuage)).append("\" ");
            }
            if (this.checksum != null) {
                strAttrs.append("Checksum=\"").append(AbstractSchema.checkXMLContent(this.checksum)).append("\" ");
            }
            if (this.platformType != null) {
                strAttrs.append("PlatformType=\"").append(AbstractSchema.checkXMLContent(this.platformType)).append("\" ");
            }
            if (this.packageName != null) {
                strAttrs.append("PackageName=\"").append(AbstractSchema.checkXMLContent(this.packageName)).append("\" ");
            }
            if (this.releaseNotesUrl != null) {
                strAttrs.append("ReleaseNotesUrl=\"").append(AbstractSchema.checkXMLContent(this.releaseNotesUrl)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</PackageInfo>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

