/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PEPThreatRule
extends ConfigObject {
    public static final Integer ALLOW = 0;
    public static final Integer BLOCK = 1;
    public static final Integer DISABLE = 0;
    public static final Integer ENABLE = 1;
    private static final long serialVersionUID = 1L;
    private String signatureId;
    private String techniqueName;
    private Boolean enabledState;
    private Integer action;
    private Integer logAction;

    public PEPThreatRule() {
        this(true);
    }

    public PEPThreatRule(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "PEPThreatRule";
    }

    public String getSignatureId() {
        return this.signatureId;
    }

    public void setSignatureId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.signatureId = value;
    }

    public String getTechniqueName() {
        return this.techniqueName;
    }

    public void setTechniqueName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.techniqueName = value;
    }

    public Boolean getDefEnabledState() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnabledState() {
        return this.enabledState;
    }

    public void setOptEnabledState(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enabledState = value;
    }

    public Integer getDefAction() {
        return BLOCK;
    }

    public Integer getOptAction() {
        return this.action;
    }

    public String getOptActionValue() throws ValidationException {
        if (this.action == null) {
            return null;
        }
        String s = null;
        switch (this.action) {
            case 0: {
                s = "ALLOW";
                break;
            }
            case 1: {
                s = "BLOCK";
                break;
            }
            default: {
                throw new ValidationException("PEPThreatRule/Action: invalid attribute value:" + this.action + "!");
            }
        }
        return s;
    }

    public void setOptAction(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.action = value;
    }

    public void setOptActionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.action = null;
            return;
        }
        if ("ALLOW".equals(value)) {
            this.action = ALLOW;
        } else if ("BLOCK".equals(value)) {
            this.action = BLOCK;
        } else {
            throw new ValidationException("PEPThreatRule/Action: invalid attribute value:" + value + "!");
        }
    }

    public Integer getDefLogAction() {
        return ENABLE;
    }

    public Integer getOptLogAction() {
        return this.logAction;
    }

    public String getOptLogActionValue() throws ValidationException {
        if (this.logAction == null) {
            return null;
        }
        String s = null;
        switch (this.logAction) {
            case 0: {
                s = "DISABLE";
                break;
            }
            case 1: {
                s = "ENABLE";
                break;
            }
            default: {
                throw new ValidationException("PEPThreatRule/LogAction: invalid attribute value:" + this.logAction + "!");
            }
        }
        return s;
    }

    public void setOptLogAction(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.logAction = value;
    }

    public void setOptLogActionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.logAction = null;
            return;
        }
        if ("DISABLE".equals(value)) {
            this.logAction = DISABLE;
        } else if ("ENABLE".equals(value)) {
            this.logAction = ENABLE;
        } else {
            throw new ValidationException("PEPThreatRule/LogAction: invalid attribute value:" + value + "!");
        }
    }

    @Override
    public int getObjectType() {
        return 830;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.signatureId == null) {
            throw new ValidationException("PEPThreatRule/SignatureId: attribute is required!");
        }
        if (this.techniqueName == null) {
            throw new ValidationException("PEPThreatRule/TechniqueName: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("SignatureId");
            if (value == null) {
                throw new ValidationException("PEPThreatRule/SignatureId: attribute is required!");
            }
            this.signatureId = value;
            value = attris.getValue("TechniqueName");
            if (value == null) {
                throw new ValidationException("PEPThreatRule/TechniqueName: attribute is required!");
            }
            this.techniqueName = value;
            value = attris.getValue("EnabledState");
            if (value != null) {
                this.enabledState = "1".equals(value);
            }
            if ((value = attris.getValue("Action")) != null) {
                this.setOptActionValue(value);
            }
            if ((value = attris.getValue("LogAction")) != null) {
                this.setOptLogActionValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"PEPThreatRule".equals(element.getNodeName())) {
            throw new ValidationException("PEPThreatRule: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "SignatureId");
        if (value == null) {
            throw new ValidationException("PEPThreatRule/SignatureId: attribute is required!");
        }
        this.signatureId = value;
        value = XMLHelper.getAttribute(element, "TechniqueName");
        if (value == null) {
            throw new ValidationException("PEPThreatRule/TechniqueName: attribute is required!");
        }
        this.techniqueName = value;
        value = XMLHelper.getAttribute(element, "EnabledState");
        if (value != null) {
            this.enabledState = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Action")) != null) {
            this.setOptActionValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LogAction")) != null) {
            this.setOptLogActionValue(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("PEPThreatRule/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("PEPThreatRule/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("PEPThreatRule");
        if (this.signatureId != null) {
            element.setAttribute("SignatureId", this.signatureId);
        }
        if (this.techniqueName != null) {
            element.setAttribute("TechniqueName", this.techniqueName);
        }
        if (this.enabledState != null) {
            element.setAttribute("EnabledState", this.enabledState != false ? "1" : "0");
        }
        if (this.action != null) {
            element.setAttribute("Action", this.getOptActionValue());
        }
        if (this.logAction != null) {
            element.setAttribute("LogAction", this.getOptLogActionValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<PEPThreatRule ");
            if (this.signatureId != null) {
                strAttrs.append("SignatureId=\"").append(AbstractSchema.checkXMLContent(this.signatureId)).append("\" ");
            }
            if (this.techniqueName != null) {
                strAttrs.append("TechniqueName=\"").append(AbstractSchema.checkXMLContent(this.techniqueName)).append("\" ");
            }
            if (this.enabledState != null) {
                strAttrs.append("EnabledState=").append(this.enabledState != false ? "\"1\" " : "\"0\" ");
            }
            if (this.action != null) {
                strAttrs.append("Action=\"").append(this.getOptActionValue()).append("\" ");
            }
            if (this.logAction != null) {
                strAttrs.append("LogAction=\"").append(this.getOptLogActionValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</PEPThreatRule>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

