/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class P2PAuthParameter
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Integer authPacket;
    private Integer packetInterval;
    private Integer rejectTime;
    private Integer allowTime;

    public P2PAuthParameter() {
        this(true);
    }

    public P2PAuthParameter(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "P2PAuthParameter";
    }

    public Integer getAuthPacket() {
        return this.authPacket;
    }

    public void setAuthPacket(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.authPacket = value;
    }

    public Integer getPacketInterval() {
        return this.packetInterval;
    }

    public void setPacketInterval(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.packetInterval = value;
    }

    public Integer getRejectTime() {
        return this.rejectTime;
    }

    public void setRejectTime(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.rejectTime = value;
    }

    public Integer getAllowTime() {
        return this.allowTime;
    }

    public void setAllowTime(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.allowTime = value;
    }

    @Override
    public int getObjectType() {
        return 385;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.authPacket == null) {
            throw new ValidationException("P2PAuthParameter/AuthPacket: attribute is required!");
        }
        if (this.packetInterval == null) {
            throw new ValidationException("P2PAuthParameter/PacketInterval: attribute is required!");
        }
        if (this.rejectTime == null) {
            throw new ValidationException("P2PAuthParameter/RejectTime: attribute is required!");
        }
        if (this.allowTime == null) {
            throw new ValidationException("P2PAuthParameter/AllowTime: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("AuthPacket");
            if (value == null) {
                throw new ValidationException("P2PAuthParameter/AuthPacket: attribute is required!");
            }
            try {
                this.authPacket = Integer.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("P2PAuthParameter/AuthPacket: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("P2PAuthParameter/AuthPacket: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("PacketInterval");
            if (value == null) {
                throw new ValidationException("P2PAuthParameter/PacketInterval: attribute is required!");
            }
            try {
                this.packetInterval = Integer.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("P2PAuthParameter/PacketInterval: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("P2PAuthParameter/PacketInterval: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("RejectTime");
            if (value == null) {
                throw new ValidationException("P2PAuthParameter/RejectTime: attribute is required!");
            }
            try {
                this.rejectTime = Integer.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("P2PAuthParameter/RejectTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("P2PAuthParameter/RejectTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("AllowTime");
            if (value == null) {
                throw new ValidationException("P2PAuthParameter/AllowTime: attribute is required!");
            }
            try {
                this.allowTime = Integer.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("P2PAuthParameter/AllowTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("P2PAuthParameter/AllowTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"P2PAuthParameter".equals(element.getNodeName())) {
            throw new ValidationException("P2PAuthParameter: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "AuthPacket");
        if (value == null) {
            throw new ValidationException("P2PAuthParameter/AuthPacket: attribute is required!");
        }
        try {
            this.authPacket = Integer.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("P2PAuthParameter/AuthPacket: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("P2PAuthParameter/AuthPacket: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "PacketInterval");
        if (value == null) {
            throw new ValidationException("P2PAuthParameter/PacketInterval: attribute is required!");
        }
        try {
            this.packetInterval = Integer.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("P2PAuthParameter/PacketInterval: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("P2PAuthParameter/PacketInterval: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "RejectTime");
        if (value == null) {
            throw new ValidationException("P2PAuthParameter/RejectTime: attribute is required!");
        }
        try {
            this.rejectTime = Integer.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("P2PAuthParameter/RejectTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("P2PAuthParameter/RejectTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "AllowTime");
        if (value == null) {
            throw new ValidationException("P2PAuthParameter/AllowTime: attribute is required!");
        }
        try {
            this.allowTime = Integer.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("P2PAuthParameter/AllowTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("P2PAuthParameter/AllowTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("P2PAuthParameter/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("P2PAuthParameter/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("P2PAuthParameter");
        if (this.authPacket != null) {
            element.setAttribute("AuthPacket", this.authPacket.toString());
        }
        if (this.packetInterval != null) {
            element.setAttribute("PacketInterval", this.packetInterval.toString());
        }
        if (this.rejectTime != null) {
            element.setAttribute("RejectTime", this.rejectTime.toString());
        }
        if (this.allowTime != null) {
            element.setAttribute("AllowTime", this.allowTime.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<P2PAuthParameter ");
            if (this.authPacket != null) {
                strAttrs.append("AuthPacket=\"").append(this.authPacket.toString()).append("\" ");
            }
            if (this.packetInterval != null) {
                strAttrs.append("PacketInterval=\"").append(this.packetInterval.toString()).append("\" ");
            }
            if (this.rejectTime != null) {
                strAttrs.append("RejectTime=\"").append(this.rejectTime.toString()).append("\" ");
            }
            if (this.allowTime != null) {
                strAttrs.append("AllowTime=\"").append(this.allowTime.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</P2PAuthParameter>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

