/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.P2PAuthParameter;
import com.sygate.scm.common.configobject.schema.P2PExceptionList;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class P2P
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Boolean enableAuthentication;
    private Boolean enableClientActivityLog;
    private Integer sessionTimeout;

    public P2P() {
        this(true);
    }

    public P2P(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(385, new ChildGroup(0, 1));
        this.children.put(386, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "P2P";
    }

    public Boolean getEnableAuthentication() {
        return this.enableAuthentication;
    }

    public void setEnableAuthentication(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enableAuthentication = value;
    }

    public Boolean getDefEnableClientActivityLog() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnableClientActivityLog() {
        return this.enableClientActivityLog;
    }

    public void setOptEnableClientActivityLog(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enableClientActivityLog = value;
    }

    public Integer getDefSessionTimeout() {
        return 40;
    }

    public Integer getOptSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setOptSessionTimeout(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.sessionTimeout = value;
    }

    public P2PAuthParameter getOptP2PAuthParameter() {
        ChildGroup childGroup = (ChildGroup)this.children.get(385);
        if (childGroup.size() > 0) {
            return (P2PAuthParameter)childGroup.get(0);
        }
        return null;
    }

    public void setOptP2PAuthParameter(P2PAuthParameter value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            P2PAuthParameter obj = this.getOptP2PAuthParameter();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public P2PExceptionList getOptP2PExceptionList() {
        ChildGroup childGroup = (ChildGroup)this.children.get(386);
        if (childGroup.size() > 0) {
            return (P2PExceptionList)childGroup.get(0);
        }
        return null;
    }

    public void setOptP2PExceptionList(P2PExceptionList value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            P2PExceptionList obj = this.getOptP2PExceptionList();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 382;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.enableAuthentication == null) {
            throw new ValidationException("P2P/EnableAuthentication: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof P2PAuthParameter) {
            try {
                this.setOptP2PAuthParameter((P2PAuthParameter)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof P2PExceptionList) {
            try {
                this.setOptP2PExceptionList((P2PExceptionList)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("EnableAuthentication");
            if (value == null) {
                throw new ValidationException("P2P/EnableAuthentication: attribute is required!");
            }
            this.enableAuthentication = "1".equals(value);
            value = attris.getValue("EnableClientActivityLog");
            if (value != null) {
                this.enableClientActivityLog = "1".equals(value);
            }
            if ((value = attris.getValue("SessionTimeout")) != null) {
                try {
                    this.sessionTimeout = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("P2P/SessionTimeout: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("P2P/SessionTimeout: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptP2PAuthParameter() != null) {
            this.getOptP2PAuthParameter().setReadonly();
        }
        if (this.getOptP2PExceptionList() != null) {
            this.getOptP2PExceptionList().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"P2P".equals(element.getNodeName())) {
            throw new ValidationException("P2P: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "EnableAuthentication");
        if (value == null) {
            throw new ValidationException("P2P/EnableAuthentication: attribute is required!");
        }
        this.enableAuthentication = "1".equals(value);
        value = XMLHelper.getAttribute(element, "EnableClientActivityLog");
        if (value != null) {
            this.enableClientActivityLog = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "SessionTimeout")) != null) {
            try {
                this.sessionTimeout = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("P2P/SessionTimeout: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((v = XMLHelper.getChildElementByName(element, "P2PAuthParameter")).size() > 0) {
            P2PAuthParameter p2PAuthParameterObj = new P2PAuthParameter();
            p2PAuthParameterObj.importFromElement(v.get(0));
            this.setOptP2PAuthParameter(p2PAuthParameterObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "P2PExceptionList")).size() > 0) {
            P2PExceptionList p2PExceptionListObj = new P2PExceptionList();
            p2PExceptionListObj.importFromElement(v.get(0));
            this.setOptP2PExceptionList(p2PExceptionListObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("P2P/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("P2P/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("P2P");
        if (this.enableAuthentication != null) {
            element.setAttribute("EnableAuthentication", this.enableAuthentication != false ? "1" : "0");
        }
        if (this.enableClientActivityLog != null) {
            element.setAttribute("EnableClientActivityLog", this.enableClientActivityLog != false ? "1" : "0");
        }
        if (this.sessionTimeout != null) {
            element.setAttribute("SessionTimeout", this.sessionTimeout.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<P2P ");
            if (this.enableAuthentication != null) {
                strAttrs.append("EnableAuthentication=").append(this.enableAuthentication != false ? "\"1\" " : "\"0\" ");
            }
            if (this.enableClientActivityLog != null) {
                strAttrs.append("EnableClientActivityLog=").append(this.enableClientActivityLog != false ? "\"1\" " : "\"0\" ");
            }
            if (this.sessionTimeout != null) {
                strAttrs.append("SessionTimeout=\"").append(this.sessionTimeout.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</P2P>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

