/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.CertificateOverride;
import com.sygate.scm.common.configobject.schema.DnsHostFileOverride;
import com.sygate.scm.common.configobject.schema.HeuristicPolicyOverride;
import com.sygate.scm.common.configobject.schema.NonPEFileOverride;
import com.sygate.scm.common.configobject.schema.SecurityRiskOverride;
import com.sygate.scm.common.configobject.schema.SysferExclusionFileControlOverride;
import com.sygate.scm.common.configobject.schema.TamperProtectionOverride;
import com.sygate.scm.common.configobject.schema.URLDomainOverride;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class OverrideItem
extends ConfigObject {
    public static final Integer IGNORE = 0;
    public static final Integer BLOCK = 1;
    public static final Integer QUARANTINE = 2;
    public static final Integer LOG_ONLY = 3;
    public static final Integer REMOVE = 4;
    public static final Integer PROMPT = 5;
    public static final Integer TP_RELATED_ACTIONS = 6;
    public static final Integer LAST_ITEM = 7;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Integer action;
    private String source;

    public OverrideItem() {
        this(true);
    }

    public OverrideItem(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(680, new ChildGroup(0, 1));
        this.children.put(688, new ChildGroup(0, 1));
        this.children.put(691, new ChildGroup(0, 1));
        this.children.put(694, new ChildGroup(0, 1));
        this.children.put(686, new ChildGroup(0, 1));
        this.children.put(685, new ChildGroup(0, 1));
        this.children.put(684, new ChildGroup(0, 1));
        this.children.put(682, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "OverrideItem";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public Integer getAction() {
        return this.action;
    }

    public String getActionValue() throws ValidationException {
        if (this.action == null) {
            return null;
        }
        String s = null;
        switch (this.action) {
            case 0: {
                s = "IGNORE";
                break;
            }
            case 1: {
                s = "BLOCK";
                break;
            }
            case 2: {
                s = "QUARANTINE";
                break;
            }
            case 3: {
                s = "LOG_ONLY";
                break;
            }
            case 4: {
                s = "REMOVE";
                break;
            }
            case 5: {
                s = "PROMPT";
                break;
            }
            case 6: {
                s = "TP_RELATED_ACTIONS";
                break;
            }
            case 7: {
                s = "LAST_ITEM";
                break;
            }
            default: {
                throw new ValidationException("OverrideItem/Action: invalid attribute value:" + this.action + "!");
            }
        }
        return s;
    }

    public void setAction(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.action = value;
    }

    public void setActionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("IGNORE".equals(value)) {
            this.action = IGNORE;
        } else if ("BLOCK".equals(value)) {
            this.action = BLOCK;
        } else if ("QUARANTINE".equals(value)) {
            this.action = QUARANTINE;
        } else if ("LOG_ONLY".equals(value)) {
            this.action = LOG_ONLY;
        } else if ("REMOVE".equals(value)) {
            this.action = REMOVE;
        } else if ("PROMPT".equals(value)) {
            this.action = PROMPT;
        } else if ("TP_RELATED_ACTIONS".equals(value)) {
            this.action = TP_RELATED_ACTIONS;
        } else if ("LAST_ITEM".equals(value)) {
            this.action = LAST_ITEM;
        } else {
            throw new ValidationException("OverrideItem/Action: invalid attribute value:" + value + "!");
        }
    }

    public String getOptSource() {
        return this.source;
    }

    public void setOptSource(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.source = value;
    }

    public SecurityRiskOverride getOptSecurityRiskOverride() {
        ChildGroup childGroup = (ChildGroup)this.children.get(680);
        if (childGroup.size() > 0) {
            return (SecurityRiskOverride)childGroup.get(0);
        }
        return null;
    }

    public void setOptSecurityRiskOverride(SecurityRiskOverride value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            SecurityRiskOverride obj = this.getOptSecurityRiskOverride();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public HeuristicPolicyOverride getOptHeuristicPolicyOverride() {
        ChildGroup childGroup = (ChildGroup)this.children.get(688);
        if (childGroup.size() > 0) {
            return (HeuristicPolicyOverride)childGroup.get(0);
        }
        return null;
    }

    public void setOptHeuristicPolicyOverride(HeuristicPolicyOverride value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            HeuristicPolicyOverride obj = this.getOptHeuristicPolicyOverride();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public TamperProtectionOverride getOptTamperProtectionOverride() {
        ChildGroup childGroup = (ChildGroup)this.children.get(691);
        if (childGroup.size() > 0) {
            return (TamperProtectionOverride)childGroup.get(0);
        }
        return null;
    }

    public void setOptTamperProtectionOverride(TamperProtectionOverride value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            TamperProtectionOverride obj = this.getOptTamperProtectionOverride();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public URLDomainOverride getOptURLDomainOverride() {
        ChildGroup childGroup = (ChildGroup)this.children.get(694);
        if (childGroup.size() > 0) {
            return (URLDomainOverride)childGroup.get(0);
        }
        return null;
    }

    public void setOptURLDomainOverride(URLDomainOverride value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            URLDomainOverride obj = this.getOptURLDomainOverride();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public SysferExclusionFileControlOverride getOptSysferExclusionFileControlOverride() {
        ChildGroup childGroup = (ChildGroup)this.children.get(686);
        if (childGroup.size() > 0) {
            return (SysferExclusionFileControlOverride)childGroup.get(0);
        }
        return null;
    }

    public void setOptSysferExclusionFileControlOverride(SysferExclusionFileControlOverride value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            SysferExclusionFileControlOverride obj = this.getOptSysferExclusionFileControlOverride();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public DnsHostFileOverride getOptDnsHostFileOverride() {
        ChildGroup childGroup = (ChildGroup)this.children.get(685);
        if (childGroup.size() > 0) {
            return (DnsHostFileOverride)childGroup.get(0);
        }
        return null;
    }

    public void setOptDnsHostFileOverride(DnsHostFileOverride value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            DnsHostFileOverride obj = this.getOptDnsHostFileOverride();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public CertificateOverride getOptCertificateOverride() {
        ChildGroup childGroup = (ChildGroup)this.children.get(684);
        if (childGroup.size() > 0) {
            return (CertificateOverride)childGroup.get(0);
        }
        return null;
    }

    public void setOptCertificateOverride(CertificateOverride value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            CertificateOverride obj = this.getOptCertificateOverride();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public NonPEFileOverride getOptNonPEFileOverride() {
        ChildGroup childGroup = (ChildGroup)this.children.get(682);
        if (childGroup.size() > 0) {
            return (NonPEFileOverride)childGroup.get(0);
        }
        return null;
    }

    public void setOptNonPEFileOverride(NonPEFileOverride value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            NonPEFileOverride obj = this.getOptNonPEFileOverride();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 679;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.action == null) {
            throw new ValidationException("OverrideItem/Action: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof SecurityRiskOverride) {
            try {
                this.setOptSecurityRiskOverride((SecurityRiskOverride)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof HeuristicPolicyOverride) {
            try {
                this.setOptHeuristicPolicyOverride((HeuristicPolicyOverride)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof TamperProtectionOverride) {
            try {
                this.setOptTamperProtectionOverride((TamperProtectionOverride)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof URLDomainOverride) {
            try {
                this.setOptURLDomainOverride((URLDomainOverride)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof SysferExclusionFileControlOverride) {
            try {
                this.setOptSysferExclusionFileControlOverride((SysferExclusionFileControlOverride)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof DnsHostFileOverride) {
            try {
                this.setOptDnsHostFileOverride((DnsHostFileOverride)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof CertificateOverride) {
            try {
                this.setOptCertificateOverride((CertificateOverride)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof NonPEFileOverride) {
            try {
                this.setOptNonPEFileOverride((NonPEFileOverride)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("Action")) == null) {
                throw new ValidationException("OverrideItem/Action: attribute is required!");
            }
            this.setActionValue(value);
            value = attris.getValue("Source");
            if (value != null) {
                this.source = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptSecurityRiskOverride() != null) {
            this.getOptSecurityRiskOverride().setReadonly();
        }
        if (this.getOptHeuristicPolicyOverride() != null) {
            this.getOptHeuristicPolicyOverride().setReadonly();
        }
        if (this.getOptTamperProtectionOverride() != null) {
            this.getOptTamperProtectionOverride().setReadonly();
        }
        if (this.getOptURLDomainOverride() != null) {
            this.getOptURLDomainOverride().setReadonly();
        }
        if (this.getOptSysferExclusionFileControlOverride() != null) {
            this.getOptSysferExclusionFileControlOverride().setReadonly();
        }
        if (this.getOptDnsHostFileOverride() != null) {
            this.getOptDnsHostFileOverride().setReadonly();
        }
        if (this.getOptCertificateOverride() != null) {
            this.getOptCertificateOverride().setReadonly();
        }
        if (this.getOptNonPEFileOverride() != null) {
            this.getOptNonPEFileOverride().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"OverrideItem".equals(element.getNodeName())) {
            throw new ValidationException("OverrideItem: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Action")) == null) {
            throw new ValidationException("OverrideItem/Action: attribute is required!");
        }
        this.setActionValue(value);
        value = XMLHelper.getAttribute(element, "Source");
        if (value != null) {
            this.source = value;
        }
        if ((v = XMLHelper.getChildElementByName(element, "SecurityRiskOverride")).size() > 0) {
            SecurityRiskOverride securityRiskOverrideObj = new SecurityRiskOverride();
            securityRiskOverrideObj.importFromElement(v.get(0));
            this.setOptSecurityRiskOverride(securityRiskOverrideObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "HeuristicPolicyOverride")).size() > 0) {
            HeuristicPolicyOverride heuristicPolicyOverrideObj = new HeuristicPolicyOverride();
            heuristicPolicyOverrideObj.importFromElement(v.get(0));
            this.setOptHeuristicPolicyOverride(heuristicPolicyOverrideObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "TamperProtectionOverride")).size() > 0) {
            TamperProtectionOverride tamperProtectionOverrideObj = new TamperProtectionOverride();
            tamperProtectionOverrideObj.importFromElement(v.get(0));
            this.setOptTamperProtectionOverride(tamperProtectionOverrideObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "URLDomainOverride")).size() > 0) {
            URLDomainOverride uRLDomainOverrideObj = new URLDomainOverride();
            uRLDomainOverrideObj.importFromElement(v.get(0));
            this.setOptURLDomainOverride(uRLDomainOverrideObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "SysferExclusionFileControlOverride")).size() > 0) {
            SysferExclusionFileControlOverride sysferExclusionFileControlOverrideObj = new SysferExclusionFileControlOverride();
            sysferExclusionFileControlOverrideObj.importFromElement(v.get(0));
            this.setOptSysferExclusionFileControlOverride(sysferExclusionFileControlOverrideObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "DnsHostFileOverride")).size() > 0) {
            DnsHostFileOverride dnsHostFileOverrideObj = new DnsHostFileOverride();
            dnsHostFileOverrideObj.importFromElement(v.get(0));
            this.setOptDnsHostFileOverride(dnsHostFileOverrideObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "CertificateOverride")).size() > 0) {
            CertificateOverride certificateOverrideObj = new CertificateOverride();
            certificateOverrideObj.importFromElement(v.get(0));
            this.setOptCertificateOverride(certificateOverrideObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "NonPEFileOverride")).size() > 0) {
            NonPEFileOverride nonPEFileOverrideObj = new NonPEFileOverride();
            nonPEFileOverrideObj.importFromElement(v.get(0));
            this.setOptNonPEFileOverride(nonPEFileOverrideObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("OverrideItem/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("OverrideItem/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("OverrideItem");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.action != null) {
            element.setAttribute("Action", this.getActionValue());
        }
        if (this.source != null) {
            element.setAttribute("Source", this.source);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<OverrideItem ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.action != null) {
                strAttrs.append("Action=\"").append(this.getActionValue()).append("\" ");
            }
            if (this.source != null) {
                strAttrs.append("Source=\"").append(AbstractSchema.checkXMLContent(this.source)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</OverrideItem>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

