/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class OpRegistryMatchEntity
extends ConfigObject {
    public static final Integer NORMAL = 0;
    public static final Integer REG_EX = 1;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Integer method;
    private String regKey;
    private String regValueName;
    private String regValueData;
    private Boolean searchSubkeys;

    public OpRegistryMatchEntity() {
        this(true);
    }

    public OpRegistryMatchEntity(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "OpRegistryMatchEntity";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public Integer getDefMethod() {
        return NORMAL;
    }

    public Integer getOptMethod() {
        return this.method;
    }

    public String getOptMethodValue() throws ValidationException {
        if (this.method == null) {
            return null;
        }
        String s = null;
        switch (this.method) {
            case 0: {
                s = "NORMAL";
                break;
            }
            case 1: {
                s = "REG_EX";
                break;
            }
            default: {
                throw new ValidationException("OpRegistryMatchEntity/Method: invalid attribute value:" + this.method + "!");
            }
        }
        return s;
    }

    public void setOptMethod(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.method = value;
    }

    public void setOptMethodValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.method = null;
            return;
        }
        if ("NORMAL".equals(value)) {
            this.method = NORMAL;
        } else if ("REG_EX".equals(value)) {
            this.method = REG_EX;
        } else {
            throw new ValidationException("OpRegistryMatchEntity/Method: invalid attribute value:" + value + "!");
        }
    }

    public String getRegKey() {
        return this.regKey;
    }

    public void setRegKey(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.regKey = value;
    }

    public String getOptRegValueName() {
        return this.regValueName;
    }

    public void setOptRegValueName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.regValueName = value;
    }

    public String getOptRegValueData() {
        return this.regValueData;
    }

    public void setOptRegValueData(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.regValueData = value;
    }

    public Boolean getDefSearchSubkeys() {
        return Boolean.FALSE;
    }

    public Boolean getOptSearchSubkeys() {
        return this.searchSubkeys;
    }

    public void setOptSearchSubkeys(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.searchSubkeys = value;
    }

    @Override
    public int getObjectType() {
        return 453;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.regKey == null) {
            throw new ValidationException("OpRegistryMatchEntity/RegKey: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("Method")) != null) {
                this.setOptMethodValue(value);
            }
            if ((value = attris.getValue("RegKey")) == null) {
                throw new ValidationException("OpRegistryMatchEntity/RegKey: attribute is required!");
            }
            this.regKey = value;
            value = attris.getValue("RegValueName");
            if (value != null) {
                this.regValueName = value;
            }
            if ((value = attris.getValue("RegValueData")) != null) {
                this.regValueData = value;
            }
            if ((value = attris.getValue("SearchSubkeys")) != null) {
                this.searchSubkeys = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"OpRegistryMatchEntity".equals(element.getNodeName())) {
            throw new ValidationException("OpRegistryMatchEntity: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Method")) != null) {
            this.setOptMethodValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "RegKey")) == null) {
            throw new ValidationException("OpRegistryMatchEntity/RegKey: attribute is required!");
        }
        this.regKey = value;
        value = XMLHelper.getAttribute(element, "RegValueName");
        if (value != null) {
            this.regValueName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RegValueData")) != null) {
            this.regValueData = value;
        }
        if ((value = XMLHelper.getAttribute(element, "SearchSubkeys")) != null) {
            this.searchSubkeys = "1".equals(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("OpRegistryMatchEntity/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("OpRegistryMatchEntity/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("OpRegistryMatchEntity");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.method != null) {
            element.setAttribute("Method", this.getOptMethodValue());
        }
        if (this.regKey != null) {
            element.setAttribute("RegKey", this.regKey);
        }
        if (this.regValueName != null) {
            element.setAttribute("RegValueName", this.regValueName);
        }
        if (this.regValueData != null) {
            element.setAttribute("RegValueData", this.regValueData);
        }
        if (this.searchSubkeys != null) {
            element.setAttribute("SearchSubkeys", this.searchSubkeys != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<OpRegistryMatchEntity ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.method != null) {
                strAttrs.append("Method=\"").append(this.getOptMethodValue()).append("\" ");
            }
            if (this.regKey != null) {
                strAttrs.append("RegKey=\"").append(AbstractSchema.checkXMLContent(this.regKey)).append("\" ");
            }
            if (this.regValueName != null) {
                strAttrs.append("RegValueName=\"").append(AbstractSchema.checkXMLContent(this.regValueName)).append("\" ");
            }
            if (this.regValueData != null) {
                strAttrs.append("RegValueData=\"").append(AbstractSchema.checkXMLContent(this.regValueData)).append("\" ");
            }
            if (this.searchSubkeys != null) {
                strAttrs.append("SearchSubkeys=").append(this.searchSubkeys != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</OpRegistryMatchEntity>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

