/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class OpFileNameMatchEntity
extends ConfigObject {
    public static final Integer NORMAL = 0;
    public static final Integer REG_EX = 1;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Integer method;
    private String keyString;
    private Boolean searchSubdirectory;
    private Boolean enableDriveTypes;
    private String driveTypes;
    private Boolean enableDeviceClassTypes;
    private String deviceClassTypes;
    private Boolean enableDeviceInstanceTypes;
    private String deviceInstanceTypes;

    public OpFileNameMatchEntity() {
        this(true);
    }

    public OpFileNameMatchEntity(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "OpFileNameMatchEntity";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enable = value;
    }

    public Integer getDefMethod() {
        return NORMAL;
    }

    public Integer getOptMethod() {
        return this.method;
    }

    public String getOptMethodValue() throws ValidationException {
        if (this.method == null) {
            return null;
        }
        String s = null;
        switch (this.method) {
            case 0: {
                s = "NORMAL";
                break;
            }
            case 1: {
                s = "REG_EX";
                break;
            }
            default: {
                throw new ValidationException("OpFileNameMatchEntity/Method: invalid attribute value:" + this.method + "!");
            }
        }
        return s;
    }

    public void setOptMethod(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.method = value;
    }

    public void setOptMethodValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.method = null;
            return;
        }
        if ("NORMAL".equals(value)) {
            this.method = NORMAL;
        } else if ("REG_EX".equals(value)) {
            this.method = REG_EX;
        } else {
            throw new ValidationException("OpFileNameMatchEntity/Method: invalid attribute value:" + value + "!");
        }
    }

    public String getKeyString() {
        return this.keyString;
    }

    public void setKeyString(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.keyString = value;
    }

    public Boolean getDefSearchSubdirectory() {
        return Boolean.FALSE;
    }

    public Boolean getOptSearchSubdirectory() {
        return this.searchSubdirectory;
    }

    public void setOptSearchSubdirectory(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.searchSubdirectory = value;
    }

    public Boolean getDefEnableDriveTypes() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnableDriveTypes() {
        return this.enableDriveTypes;
    }

    public void setOptEnableDriveTypes(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enableDriveTypes = value;
    }

    public String getOptDriveTypes() {
        return this.driveTypes;
    }

    public void setOptDriveTypes(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.driveTypes = value;
    }

    public Boolean getDefEnableDeviceClassTypes() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnableDeviceClassTypes() {
        return this.enableDeviceClassTypes;
    }

    public void setOptEnableDeviceClassTypes(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enableDeviceClassTypes = value;
    }

    public String getOptDeviceClassTypes() {
        return this.deviceClassTypes;
    }

    public void setOptDeviceClassTypes(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.deviceClassTypes = value;
    }

    public Boolean getDefEnableDeviceInstanceTypes() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnableDeviceInstanceTypes() {
        return this.enableDeviceInstanceTypes;
    }

    public void setOptEnableDeviceInstanceTypes(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enableDeviceInstanceTypes = value;
    }

    public String getOptDeviceInstanceTypes() {
        return this.deviceInstanceTypes;
    }

    public void setOptDeviceInstanceTypes(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.deviceInstanceTypes = value;
    }

    @Override
    public int getObjectType() {
        return 434;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.keyString == null) {
            throw new ValidationException("OpFileNameMatchEntity/KeyString: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("Method")) != null) {
                this.setOptMethodValue(value);
            }
            if ((value = attris.getValue("KeyString")) == null) {
                throw new ValidationException("OpFileNameMatchEntity/KeyString: attribute is required!");
            }
            this.keyString = value;
            value = attris.getValue("SearchSubdirectory");
            if (value != null) {
                this.searchSubdirectory = "1".equals(value);
            }
            if ((value = attris.getValue("EnableDriveTypes")) != null) {
                this.enableDriveTypes = "1".equals(value);
            }
            if ((value = attris.getValue("DriveTypes")) != null) {
                this.driveTypes = value;
            }
            if ((value = attris.getValue("EnableDeviceClassTypes")) != null) {
                this.enableDeviceClassTypes = "1".equals(value);
            }
            if ((value = attris.getValue("DeviceClassTypes")) != null) {
                this.deviceClassTypes = value;
            }
            if ((value = attris.getValue("EnableDeviceInstanceTypes")) != null) {
                this.enableDeviceInstanceTypes = "1".equals(value);
            }
            if ((value = attris.getValue("DeviceInstanceTypes")) != null) {
                this.deviceInstanceTypes = value;
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"OpFileNameMatchEntity".equals(element.getNodeName())) {
            throw new ValidationException("OpFileNameMatchEntity: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Method")) != null) {
            this.setOptMethodValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "KeyString")) == null) {
            throw new ValidationException("OpFileNameMatchEntity/KeyString: attribute is required!");
        }
        this.keyString = value;
        value = XMLHelper.getAttribute(element, "SearchSubdirectory");
        if (value != null) {
            this.searchSubdirectory = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "EnableDriveTypes")) != null) {
            this.enableDriveTypes = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "DriveTypes")) != null) {
            this.driveTypes = value;
        }
        if ((value = XMLHelper.getAttribute(element, "EnableDeviceClassTypes")) != null) {
            this.enableDeviceClassTypes = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "DeviceClassTypes")) != null) {
            this.deviceClassTypes = value;
        }
        if ((value = XMLHelper.getAttribute(element, "EnableDeviceInstanceTypes")) != null) {
            this.enableDeviceInstanceTypes = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "DeviceInstanceTypes")) != null) {
            this.deviceInstanceTypes = value;
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("OpFileNameMatchEntity/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("OpFileNameMatchEntity/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("OpFileNameMatchEntity");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.method != null) {
            element.setAttribute("Method", this.getOptMethodValue());
        }
        if (this.keyString != null) {
            element.setAttribute("KeyString", this.keyString);
        }
        if (this.searchSubdirectory != null) {
            element.setAttribute("SearchSubdirectory", this.searchSubdirectory != false ? "1" : "0");
        }
        if (this.enableDriveTypes != null) {
            element.setAttribute("EnableDriveTypes", this.enableDriveTypes != false ? "1" : "0");
        }
        if (this.driveTypes != null) {
            element.setAttribute("DriveTypes", this.driveTypes);
        }
        if (this.enableDeviceClassTypes != null) {
            element.setAttribute("EnableDeviceClassTypes", this.enableDeviceClassTypes != false ? "1" : "0");
        }
        if (this.deviceClassTypes != null) {
            element.setAttribute("DeviceClassTypes", this.deviceClassTypes);
        }
        if (this.enableDeviceInstanceTypes != null) {
            element.setAttribute("EnableDeviceInstanceTypes", this.enableDeviceInstanceTypes != false ? "1" : "0");
        }
        if (this.deviceInstanceTypes != null) {
            element.setAttribute("DeviceInstanceTypes", this.deviceInstanceTypes);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<OpFileNameMatchEntity ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.method != null) {
                strAttrs.append("Method=\"").append(this.getOptMethodValue()).append("\" ");
            }
            if (this.keyString != null) {
                strAttrs.append("KeyString=\"").append(AbstractSchema.checkXMLContent(this.keyString)).append("\" ");
            }
            if (this.searchSubdirectory != null) {
                strAttrs.append("SearchSubdirectory=").append(this.searchSubdirectory != false ? "\"1\" " : "\"0\" ");
            }
            if (this.enableDriveTypes != null) {
                strAttrs.append("EnableDriveTypes=").append(this.enableDriveTypes != false ? "\"1\" " : "\"0\" ");
            }
            if (this.driveTypes != null) {
                strAttrs.append("DriveTypes=\"").append(AbstractSchema.checkXMLContent(this.driveTypes)).append("\" ");
            }
            if (this.enableDeviceClassTypes != null) {
                strAttrs.append("EnableDeviceClassTypes=").append(this.enableDeviceClassTypes != false ? "\"1\" " : "\"0\" ");
            }
            if (this.deviceClassTypes != null) {
                strAttrs.append("DeviceClassTypes=\"").append(AbstractSchema.checkXMLContent(this.deviceClassTypes)).append("\" ");
            }
            if (this.enableDeviceInstanceTypes != null) {
                strAttrs.append("EnableDeviceInstanceTypes=").append(this.enableDeviceInstanceTypes != false ? "\"1\" " : "\"0\" ");
            }
            if (this.deviceInstanceTypes != null) {
                strAttrs.append("DeviceInstanceTypes=\"").append(AbstractSchema.checkXMLContent(this.deviceInstanceTypes)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</OpFileNameMatchEntity>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

