/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.OpNotification;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class OpAction
extends ConfigObject {
    public static final Integer ALLOW = 0;
    public static final Integer BLOCK = 1;
    public static final Integer ASK = 2;
    public static final Integer DONOTHING = 3;
    public static final Integer TERMINATE = 4;
    private static final long serialVersionUID = 1L;
    private Integer action;
    private Boolean logEvent;
    private Long severity;
    private Boolean alert;
    private Boolean remediateTarget;

    public OpAction() {
        this(true);
    }

    public OpAction(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(448, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "OpAction";
    }

    public Integer getAction() {
        return this.action;
    }

    public String getActionValue() throws ValidationException {
        if (this.action == null) {
            return null;
        }
        String s = null;
        switch (this.action) {
            case 0: {
                s = "ALLOW";
                break;
            }
            case 1: {
                s = "BLOCK";
                break;
            }
            case 2: {
                s = "ASK";
                break;
            }
            case 3: {
                s = "DONOTHING";
                break;
            }
            case 4: {
                s = "TERMINATE";
                break;
            }
            default: {
                throw new ValidationException("OpAction/Action: invalid attribute value:" + this.action + "!");
            }
        }
        return s;
    }

    public void setAction(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.action = value;
    }

    public void setActionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("ALLOW".equals(value)) {
            this.action = ALLOW;
        } else if ("BLOCK".equals(value)) {
            this.action = BLOCK;
        } else if ("ASK".equals(value)) {
            this.action = ASK;
        } else if ("DONOTHING".equals(value)) {
            this.action = DONOTHING;
        } else if ("TERMINATE".equals(value)) {
            this.action = TERMINATE;
        } else {
            throw new ValidationException("OpAction/Action: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefLogEvent() {
        return Boolean.FALSE;
    }

    public Boolean getOptLogEvent() {
        return this.logEvent;
    }

    public void setOptLogEvent(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.logEvent = value;
    }

    public Long getSeverity() {
        return this.severity;
    }

    public void setSeverity(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.severity = value;
    }

    public Boolean getDefAlert() {
        return Boolean.FALSE;
    }

    public Boolean getOptAlert() {
        return this.alert;
    }

    public void setOptAlert(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.alert = value;
    }

    public Boolean getDefRemediateTarget() {
        return Boolean.FALSE;
    }

    public Boolean getOptRemediateTarget() {
        return this.remediateTarget;
    }

    public void setOptRemediateTarget(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.remediateTarget = value;
    }

    public OpNotification getOptOpNotification() {
        ChildGroup childGroup = (ChildGroup)this.children.get(448);
        if (childGroup.size() > 0) {
            return (OpNotification)childGroup.get(0);
        }
        return null;
    }

    public void setOptOpNotification(OpNotification value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            OpNotification obj = this.getOptOpNotification();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 447;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.action == null) {
            throw new ValidationException("OpAction/Action: attribute is required!");
        }
        if (this.severity == null) {
            throw new ValidationException("OpAction/Severity: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof OpNotification) {
            try {
                this.setOptOpNotification((OpNotification)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Action");
            if (value == null) {
                throw new ValidationException("OpAction/Action: attribute is required!");
            }
            this.setActionValue(value);
            value = attris.getValue("LogEvent");
            if (value != null) {
                this.logEvent = "1".equals(value);
            }
            if ((value = attris.getValue("Severity")) == null) {
                throw new ValidationException("OpAction/Severity: attribute is required!");
            }
            try {
                this.severity = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("OpAction/Severity: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("OpAction/Severity: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("Alert");
            if (value != null) {
                this.alert = "1".equals(value);
            }
            if ((value = attris.getValue("RemediateTarget")) != null) {
                this.remediateTarget = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptOpNotification() != null) {
            this.getOptOpNotification().setReadonly();
        }
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"OpAction".equals(element.getNodeName())) {
            throw new ValidationException("OpAction: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Action");
        if (value == null) {
            throw new ValidationException("OpAction/Action: attribute is required!");
        }
        this.setActionValue(value);
        value = XMLHelper.getAttribute(element, "LogEvent");
        if (value != null) {
            this.logEvent = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Severity")) == null) {
            throw new ValidationException("OpAction/Severity: attribute is required!");
        }
        try {
            this.severity = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("OpAction/Severity: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("OpAction/Severity: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "Alert");
        if (value != null) {
            this.alert = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "RemediateTarget")) != null) {
            this.remediateTarget = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "OpNotification")).size() > 0) {
            OpNotification opNotificationObj = new OpNotification();
            opNotificationObj.importFromElement(v.get(0));
            this.setOptOpNotification(opNotificationObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("OpAction/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("OpAction/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("OpAction");
        if (this.action != null) {
            element.setAttribute("Action", this.getActionValue());
        }
        if (this.logEvent != null) {
            element.setAttribute("LogEvent", this.logEvent != false ? "1" : "0");
        }
        if (this.severity != null) {
            element.setAttribute("Severity", this.severity.toString());
        }
        if (this.alert != null) {
            element.setAttribute("Alert", this.alert != false ? "1" : "0");
        }
        if (this.remediateTarget != null) {
            element.setAttribute("RemediateTarget", this.remediateTarget != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<OpAction ");
            if (this.action != null) {
                strAttrs.append("Action=\"").append(this.getActionValue()).append("\" ");
            }
            if (this.logEvent != null) {
                strAttrs.append("LogEvent=").append(this.logEvent != false ? "\"1\" " : "\"0\" ");
            }
            if (this.severity != null) {
                strAttrs.append("Severity=\"").append(this.severity.toString()).append("\" ");
            }
            if (this.alert != null) {
                strAttrs.append("Alert=").append(this.alert != false ? "\"1\" " : "\"0\" ");
            }
            if (this.remediateTarget != null) {
                strAttrs.append("RemediateTarget=").append(this.remediateTarget != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</OpAction>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

