/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class OSIntegration
extends ConfigObject {
    public static final Integer WINDOWS = 0;
    public static final Integer MAC = 1;
    public static final Integer NO_ACTION = 0;
    public static final Integer DISABLE_ONCE_ONLY = 1;
    public static final Integer DISABLE_ALWAYS = 2;
    public static final Integer RESTORE_IF_DISABLED = 3;
    private static final long serialVersionUID = 1L;
    private Integer oSPlatform;
    private Integer disableFW;
    private Boolean fWDisabledMessage;

    public OSIntegration() {
        this(true);
    }

    public OSIntegration(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "OSIntegration";
    }

    public Integer getDefOSPlatform() {
        return WINDOWS;
    }

    public Integer getOptOSPlatform() {
        return this.oSPlatform;
    }

    public String getOptOSPlatformValue() throws ValidationException {
        if (this.oSPlatform == null) {
            return null;
        }
        String s = null;
        switch (this.oSPlatform) {
            case 0: {
                s = "WINDOWS";
                break;
            }
            case 1: {
                s = "MAC";
                break;
            }
            default: {
                throw new ValidationException("OSIntegration/OSPlatform: invalid attribute value:" + this.oSPlatform + "!");
            }
        }
        return s;
    }

    public void setOptOSPlatform(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.oSPlatform = value;
    }

    public void setOptOSPlatformValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.oSPlatform = null;
            return;
        }
        if ("WINDOWS".equals(value)) {
            this.oSPlatform = WINDOWS;
        } else if ("MAC".equals(value)) {
            this.oSPlatform = MAC;
        } else {
            throw new ValidationException("OSIntegration/OSPlatform: invalid attribute value:" + value + "!");
        }
    }

    public Integer getDefDisableFW() {
        return NO_ACTION;
    }

    public Integer getOptDisableFW() {
        return this.disableFW;
    }

    public String getOptDisableFWValue() throws ValidationException {
        if (this.disableFW == null) {
            return null;
        }
        String s = null;
        switch (this.disableFW) {
            case 0: {
                s = "NO_ACTION";
                break;
            }
            case 1: {
                s = "DISABLE_ONCE_ONLY";
                break;
            }
            case 2: {
                s = "DISABLE_ALWAYS";
                break;
            }
            case 3: {
                s = "RESTORE_IF_DISABLED";
                break;
            }
            default: {
                throw new ValidationException("OSIntegration/DisableFW: invalid attribute value:" + this.disableFW + "!");
            }
        }
        return s;
    }

    public void setOptDisableFW(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.disableFW = value;
    }

    public void setOptDisableFWValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.disableFW = null;
            return;
        }
        if ("NO_ACTION".equals(value)) {
            this.disableFW = NO_ACTION;
        } else if ("DISABLE_ONCE_ONLY".equals(value)) {
            this.disableFW = DISABLE_ONCE_ONLY;
        } else if ("DISABLE_ALWAYS".equals(value)) {
            this.disableFW = DISABLE_ALWAYS;
        } else if ("RESTORE_IF_DISABLED".equals(value)) {
            this.disableFW = RESTORE_IF_DISABLED;
        } else {
            throw new ValidationException("OSIntegration/DisableFW: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefFWDisabledMessage() {
        return Boolean.FALSE;
    }

    public Boolean getOptFWDisabledMessage() {
        return this.fWDisabledMessage;
    }

    public void setOptFWDisabledMessage(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.fWDisabledMessage = value;
    }

    @Override
    public int getObjectType() {
        return 384;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("OSPlatform");
            if (value != null) {
                this.setOptOSPlatformValue(value);
            }
            if ((value = attris.getValue("DisableFW")) != null) {
                this.setOptDisableFWValue(value);
            }
            if ((value = attris.getValue("FWDisabledMessage")) != null) {
                this.fWDisabledMessage = "1".equals(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"OSIntegration".equals(element.getNodeName())) {
            throw new ValidationException("OSIntegration: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "OSPlatform");
        if (value != null) {
            this.setOptOSPlatformValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "DisableFW")) != null) {
            this.setOptDisableFWValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "FWDisabledMessage")) != null) {
            this.fWDisabledMessage = "1".equals(value);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("OSIntegration/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("OSIntegration/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("OSIntegration");
        if (this.oSPlatform != null) {
            element.setAttribute("OSPlatform", this.getOptOSPlatformValue());
        }
        if (this.disableFW != null) {
            element.setAttribute("DisableFW", this.getOptDisableFWValue());
        }
        if (this.fWDisabledMessage != null) {
            element.setAttribute("FWDisabledMessage", this.fWDisabledMessage != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<OSIntegration ");
            if (this.oSPlatform != null) {
                strAttrs.append("OSPlatform=\"").append(this.getOptOSPlatformValue()).append("\" ");
            }
            if (this.disableFW != null) {
                strAttrs.append("DisableFW=\"").append(this.getOptDisableFWValue()).append("\" ");
            }
            if (this.fWDisabledMessage != null) {
                strAttrs.append("FWDisabledMessage=").append(this.fWDisabledMessage != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</OSIntegration>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

