/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NonPEFileOverride
extends ConfigObject {
    public static final Integer NAME = 0;
    public static final Integer HASH = 1;
    private static final long serialVersionUID = 1L;
    private Integer actorType;
    private String actor;
    private String name;
    private String checkSum;
    private String description;
    private Long fileSize;

    public NonPEFileOverride() {
        this(true);
    }

    public NonPEFileOverride(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "NonPEFileOverride";
    }

    public Integer getDefActorType() {
        return NAME;
    }

    public Integer getOptActorType() {
        return this.actorType;
    }

    public String getOptActorTypeValue() throws ValidationException {
        if (this.actorType == null) {
            return null;
        }
        String s = null;
        switch (this.actorType) {
            case 0: {
                s = "NAME";
                break;
            }
            case 1: {
                s = "HASH";
                break;
            }
            default: {
                throw new ValidationException("NonPEFileOverride/ActorType: invalid attribute value:" + this.actorType + "!");
            }
        }
        return s;
    }

    public void setOptActorType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.actorType = value;
    }

    public void setOptActorTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.actorType = null;
            return;
        }
        if ("NAME".equals(value)) {
            this.actorType = NAME;
        } else if ("HASH".equals(value)) {
            this.actorType = HASH;
        } else {
            throw new ValidationException("NonPEFileOverride/ActorType: invalid attribute value:" + value + "!");
        }
    }

    public String getOptActor() {
        return this.actor;
    }

    public void setOptActor(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.actor = value;
    }

    public String getOptName() {
        return this.name;
    }

    public void setOptName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.name = value;
    }

    public String getOptCheckSum() {
        return this.checkSum;
    }

    public void setOptCheckSum(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.checkSum = value;
    }

    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.description = value;
    }

    public Long getOptFileSize() {
        return this.fileSize;
    }

    public void setOptFileSize(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.fileSize = value;
    }

    @Override
    public int getObjectType() {
        return 682;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("ActorType");
            if (value != null) {
                this.setOptActorTypeValue(value);
            }
            if ((value = attris.getValue("Actor")) != null) {
                this.actor = value;
            }
            if ((value = attris.getValue("Name")) != null) {
                this.name = value;
            }
            if ((value = attris.getValue("CheckSum")) != null) {
                this.checkSum = value;
            }
            if ((value = attris.getValue("Description")) != null) {
                this.description = value;
            }
            if ((value = attris.getValue("FileSize")) != null) {
                try {
                    this.fileSize = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("NonPEFileOverride/FileSize: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("NonPEFileOverride/FileSize: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"NonPEFileOverride".equals(element.getNodeName())) {
            throw new ValidationException("NonPEFileOverride: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "ActorType");
        if (value != null) {
            this.setOptActorTypeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Actor")) != null) {
            this.actor = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Name")) != null) {
            this.name = value;
        }
        if ((value = XMLHelper.getAttribute(element, "CheckSum")) != null) {
            this.checkSum = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Description")) != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "FileSize")) != null) {
            try {
                this.fileSize = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("NonPEFileOverride/FileSize: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("NonPEFileOverride/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("NonPEFileOverride/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("NonPEFileOverride");
        if (this.actorType != null) {
            element.setAttribute("ActorType", this.getOptActorTypeValue());
        }
        if (this.actor != null) {
            element.setAttribute("Actor", this.actor);
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.checkSum != null) {
            element.setAttribute("CheckSum", this.checkSum);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.fileSize != null) {
            element.setAttribute("FileSize", this.fileSize.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<NonPEFileOverride ");
            if (this.actorType != null) {
                strAttrs.append("ActorType=\"").append(this.getOptActorTypeValue()).append("\" ");
            }
            if (this.actor != null) {
                strAttrs.append("Actor=\"").append(AbstractSchema.checkXMLContent(this.actor)).append("\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.checkSum != null) {
                strAttrs.append("CheckSum=\"").append(AbstractSchema.checkXMLContent(this.checkSum)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.fileSize != null) {
                strAttrs.append("FileSize=\"").append(this.fileSize.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</NonPEFileOverride>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

