/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NetworkSettings
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private Boolean trustRemoteFiles;
    private Boolean enableNetworkCache;
    private Integer cacheEntries;
    private Integer deleteCacheAfterSeconds;

    public NetworkSettings() {
        this(true);
    }

    public NetworkSettings(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "NetworkSettings";
    }

    public Boolean getDefTrustRemoteFiles() {
        return Boolean.TRUE;
    }

    public Boolean getOptTrustRemoteFiles() {
        return this.trustRemoteFiles;
    }

    public void setOptTrustRemoteFiles(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.trustRemoteFiles = value;
    }

    public Boolean getDefEnableNetworkCache() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnableNetworkCache() {
        return this.enableNetworkCache;
    }

    public void setOptEnableNetworkCache(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.enableNetworkCache = value;
    }

    public Integer getDefCacheEntries() {
        return 30;
    }

    public Integer getOptCacheEntries() {
        return this.cacheEntries;
    }

    public void setOptCacheEntries(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.cacheEntries = value;
    }

    public Integer getDefDeleteCacheAfterSeconds() {
        return 600;
    }

    public Integer getOptDeleteCacheAfterSeconds() {
        return this.deleteCacheAfterSeconds;
    }

    public void setOptDeleteCacheAfterSeconds(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.deleteCacheAfterSeconds = value;
    }

    @Override
    public int getObjectType() {
        return 615;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("TrustRemoteFiles");
            if (value != null) {
                this.trustRemoteFiles = "1".equals(value);
            }
            if ((value = attris.getValue("EnableNetworkCache")) != null) {
                this.enableNetworkCache = "1".equals(value);
            }
            if ((value = attris.getValue("CacheEntries")) != null) {
                try {
                    this.cacheEntries = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("NetworkSettings/CacheEntries: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("NetworkSettings/CacheEntries: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("DeleteCacheAfterSeconds")) != null) {
                try {
                    this.deleteCacheAfterSeconds = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("NetworkSettings/DeleteCacheAfterSeconds: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("NetworkSettings/DeleteCacheAfterSeconds: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        for (int i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"NetworkSettings".equals(element.getNodeName())) {
            throw new ValidationException("NetworkSettings: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "TrustRemoteFiles");
        if (value != null) {
            this.trustRemoteFiles = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "EnableNetworkCache")) != null) {
            this.enableNetworkCache = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "CacheEntries")) != null) {
            try {
                this.cacheEntries = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("NetworkSettings/CacheEntries: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "DeleteCacheAfterSeconds")) != null) {
            try {
                this.deleteCacheAfterSeconds = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("NetworkSettings/DeleteCacheAfterSeconds: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("NetworkSettings/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("NetworkSettings/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("NetworkSettings");
        if (this.trustRemoteFiles != null) {
            element.setAttribute("TrustRemoteFiles", this.trustRemoteFiles != false ? "1" : "0");
        }
        if (this.enableNetworkCache != null) {
            element.setAttribute("EnableNetworkCache", this.enableNetworkCache != false ? "1" : "0");
        }
        if (this.cacheEntries != null) {
            element.setAttribute("CacheEntries", this.cacheEntries.toString());
        }
        if (this.deleteCacheAfterSeconds != null) {
            element.setAttribute("DeleteCacheAfterSeconds", this.deleteCacheAfterSeconds.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<NetworkSettings ");
            if (this.trustRemoteFiles != null) {
                strAttrs.append("TrustRemoteFiles=").append(this.trustRemoteFiles != false ? "\"1\" " : "\"0\" ");
            }
            if (this.enableNetworkCache != null) {
                strAttrs.append("EnableNetworkCache=").append(this.enableNetworkCache != false ? "\"1\" " : "\"0\" ");
            }
            if (this.cacheEntries != null) {
                strAttrs.append("CacheEntries=\"").append(this.cacheEntries.toString()).append("\" ");
            }
            if (this.deleteCacheAfterSeconds != null) {
                strAttrs.append("DeleteCacheAfterSeconds=\"").append(this.deleteCacheAfterSeconds.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</NetworkSettings>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

