/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.schema;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.EthernetExclusionCondition;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NetworkConnection
extends ConfigObject {
    public static final Integer EQUAL = 0;
    public static final Integer NOT_EQUAL = 1;
    public static final Integer PPTP = 0;
    public static final Integer VPN = 1;
    public static final Integer ALL = 2;
    public static final Integer ETHERNET = 3;
    public static final Integer DUN = 4;
    public static final Integer WLAN = 5;
    public static final Integer VP_CISCO3000 = 6;
    public static final Integer VP_SAFENET = 7;
    public static final Integer VP_CHECKPOINT = 8;
    public static final Integer VP_NETSCREEN = 9;
    public static final Integer VP_ENTERASYS_AURO = 10;
    public static final Integer VP_NORTEL = 11;
    public static final Integer VP_AVENTAIL_SSLVPN = 12;
    public static final Integer VP_ALCATEL = 13;
    public static final Integer VP_JUNIPER_SSL = 14;
    private static final long serialVersionUID = 1L;
    private Integer operator;
    private Long connectionStatus;
    private Integer networkInterfaceType;

    public NetworkConnection() {
        this(true);
    }

    public NetworkConnection(boolean needInit) {
        this.nameSpace = "schema";
        if (needInit) {
            this.init();
        }
        this.children.put(258, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "NetworkConnection";
    }

    public Integer getDefOperator() {
        return EQUAL;
    }

    public Integer getOptOperator() {
        return this.operator;
    }

    public String getOptOperatorValue() throws ValidationException {
        if (this.operator == null) {
            return null;
        }
        String s = null;
        switch (this.operator) {
            case 0: {
                s = "EQUAL";
                break;
            }
            case 1: {
                s = "NOT_EQUAL";
                break;
            }
            default: {
                throw new ValidationException("NetworkConnection/Operator: invalid attribute value:" + this.operator + "!");
            }
        }
        return s;
    }

    public void setOptOperator(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.operator = value;
    }

    public void setOptOperatorValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.operator = null;
            return;
        }
        if ("EQUAL".equals(value)) {
            this.operator = EQUAL;
        } else if ("NOT_EQUAL".equals(value)) {
            this.operator = NOT_EQUAL;
        } else {
            throw new ValidationException("NetworkConnection/Operator: invalid attribute value:" + value + "!");
        }
    }

    public Long getOptConnectionStatus() {
        return this.connectionStatus;
    }

    public void setOptConnectionStatus(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.connectionStatus = value;
    }

    public Integer getOptNetworkInterfaceType() {
        return this.networkInterfaceType;
    }

    public String getOptNetworkInterfaceTypeValue() throws ValidationException {
        if (this.networkInterfaceType == null) {
            return null;
        }
        String s = null;
        switch (this.networkInterfaceType) {
            case 0: {
                s = "PPTP";
                break;
            }
            case 1: {
                s = "VPN";
                break;
            }
            case 2: {
                s = "ALL";
                break;
            }
            case 3: {
                s = "ETHERNET";
                break;
            }
            case 4: {
                s = "DUN";
                break;
            }
            case 5: {
                s = "WLAN";
                break;
            }
            case 6: {
                s = "VP_CISCO3000";
                break;
            }
            case 7: {
                s = "VP_SAFENET";
                break;
            }
            case 8: {
                s = "VP_CHECKPOINT";
                break;
            }
            case 9: {
                s = "VP_NETSCREEN";
                break;
            }
            case 10: {
                s = "VP_ENTERASYS_AURO";
                break;
            }
            case 11: {
                s = "VP_NORTEL";
                break;
            }
            case 12: {
                s = "VP_AVENTAIL_SSLVPN";
                break;
            }
            case 13: {
                s = "VP_ALCATEL";
                break;
            }
            case 14: {
                s = "VP_JUNIPER_SSL";
                break;
            }
            default: {
                throw new ValidationException("NetworkConnection/NetworkInterfaceType: invalid attribute value:" + this.networkInterfaceType + "!");
            }
        }
        return s;
    }

    public void setOptNetworkInterfaceType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setDirty();
        this.networkInterfaceType = value;
    }

    public void setOptNetworkInterfaceTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.networkInterfaceType = null;
            return;
        }
        if ("PPTP".equals(value)) {
            this.networkInterfaceType = PPTP;
        } else if ("VPN".equals(value)) {
            this.networkInterfaceType = VPN;
        } else if ("ALL".equals(value)) {
            this.networkInterfaceType = ALL;
        } else if ("ETHERNET".equals(value)) {
            this.networkInterfaceType = ETHERNET;
        } else if ("DUN".equals(value)) {
            this.networkInterfaceType = DUN;
        } else if ("WLAN".equals(value)) {
            this.networkInterfaceType = WLAN;
        } else if ("VP_CISCO3000".equals(value)) {
            this.networkInterfaceType = VP_CISCO3000;
        } else if ("VP_SAFENET".equals(value)) {
            this.networkInterfaceType = VP_SAFENET;
        } else if ("VP_CHECKPOINT".equals(value)) {
            this.networkInterfaceType = VP_CHECKPOINT;
        } else if ("VP_NETSCREEN".equals(value)) {
            this.networkInterfaceType = VP_NETSCREEN;
        } else if ("VP_ENTERASYS_AURO".equals(value)) {
            this.networkInterfaceType = VP_ENTERASYS_AURO;
        } else if ("VP_NORTEL".equals(value)) {
            this.networkInterfaceType = VP_NORTEL;
        } else if ("VP_AVENTAIL_SSLVPN".equals(value)) {
            this.networkInterfaceType = VP_AVENTAIL_SSLVPN;
        } else if ("VP_ALCATEL".equals(value)) {
            this.networkInterfaceType = VP_ALCATEL;
        } else if ("VP_JUNIPER_SSL".equals(value)) {
            this.networkInterfaceType = VP_JUNIPER_SSL;
        } else {
            throw new ValidationException("NetworkConnection/NetworkInterfaceType: invalid attribute value:" + value + "!");
        }
    }

    public void addEthernetExclusionCondition(EthernetExclusionCondition value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addEthernetExclusionCondition(int index, EthernetExclusionCondition value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<EthernetExclusionCondition> getEthernetExclusionCondition() {
        Vector<EthernetExclusionCondition> v = new Vector<EthernetExclusionCondition>();
        for (Transportable child : (ChildGroup)this.children.get(258)) {
            v.add((EthernetExclusionCondition)child);
        }
        return v;
    }

    public int getEthernetExclusionConditionCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(258);
        return childGroup.size();
    }

    public EthernetExclusionCondition getEthernetExclusionCondition(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(258);
        return (EthernetExclusionCondition)childGroup.get(index);
    }

    public void setEthernetExclusionCondition(int index, EthernetExclusionCondition value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeEthernetExclusionCondition(EthernetExclusionCondition value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 257;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ObsoleteItem) {
            this.addObsoleteItem((ObsoleteItem)sonObject);
            this.setClean(false);
            return;
        }
        if (sonObject instanceof EthernetExclusionCondition) {
            try {
                this.addEthernetExclusionCondition((EthernetExclusionCondition)sonObject);
                this.setClean(false);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Operator");
            if (value != null) {
                this.setOptOperatorValue(value);
            }
            if ((value = attris.getValue("ConnectionStatus")) != null) {
                try {
                    this.connectionStatus = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("NetworkConnection/ConnectionStatus: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("NetworkConnection/ConnectionStatus: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("NetworkInterfaceType")) != null) {
                this.setOptNetworkInterfaceTypeValue(value);
            }
            this.readElement(attris);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getEthernetExclusionConditionCount();
        for (i = 0; i < objCnt; ++i) {
            this.getEthernetExclusionCondition(i).setReadonly();
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            o.setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"NetworkConnection".equals(element.getNodeName())) {
            throw new ValidationException("NetworkConnection: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Operator");
        if (value != null) {
            this.setOptOperatorValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ConnectionStatus")) != null) {
            try {
                this.connectionStatus = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("NetworkConnection/ConnectionStatus: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "NetworkInterfaceType")) != null) {
            this.setOptNetworkInterfaceTypeValue(value);
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "EthernetExclusionCondition");
        for (int i = 0; i < v.size(); ++i) {
            EthernetExclusionCondition ethernetExclusionConditionObj = new EthernetExclusionCondition();
            ethernetExclusionConditionObj.importFromElement(v.get(i));
            this.addEthernetExclusionCondition(ethernetExclusionConditionObj);
        }
        ArrayList<Element> obsoleteItems = XMLHelper.getChildElementByName(element, "ObsoleteItem");
        for (int i = 0; i < obsoleteItems.size(); ++i) {
            Element e = obsoleteItems.get(i);
            String deletedI = XMLHelper.getAttribute(e, "DeletedI");
            if (deletedI == null) {
                throw new ValidationException("NetworkConnection/ObsoleteItem/DeletedI: element is require!");
            }
            ObsoleteItem obItem = new ObsoleteItem(deletedI);
            String deletedT = XMLHelper.getAttribute(e, "DeletedT");
            if (deletedT != null) {
                try {
                    obItem.setDeletedT(Long.parseLong(deletedT));
                }
                catch (Exception ex) {
                    throw new ValidationException("NetworkConnection/ObsoleteItem/DeletedT: invalid attribute value! " + ex.getMessage());
                }
            }
            this.addObsoleteItem(obItem);
        }
        this.readElement(element);
        this.setClean(false);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        int i;
        this.validate();
        Element element = doc.createElement("NetworkConnection");
        if (this.operator != null) {
            element.setAttribute("Operator", this.getOptOperatorValue());
        }
        if (this.connectionStatus != null) {
            element.setAttribute("ConnectionStatus", this.connectionStatus.toString());
        }
        if (this.networkInterfaceType != null) {
            element.setAttribute("NetworkInterfaceType", this.getOptNetworkInterfaceTypeValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        for (i = 0; i < this.getObsoleteItemCount(); ++i) {
            ObsoleteItem o = this.getObsoleteItem(i);
            Element e = doc.createElement("ObsoleteItem");
            e.setAttribute("DeletedI", o.getDeletedI());
            if (o.getDeletedT() != -1L) {
                e.setAttribute("DeletedT", String.valueOf(o.getDeletedT()));
            }
            element.appendChild(e);
        }
        this.updateElement(element);
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        this.doSerialize(os_for_xml_generating, false);
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating, boolean appendMetadata) throws ValidationException {
        try {
            MetadataAttributes metadata;
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<NetworkConnection ");
            if (this.operator != null) {
                strAttrs.append("Operator=\"").append(this.getOptOperatorValue()).append("\" ");
            }
            if (this.connectionStatus != null) {
                strAttrs.append("ConnectionStatus=\"").append(this.connectionStatus.toString()).append("\" ");
            }
            if (this.networkInterfaceType != null) {
                strAttrs.append("NetworkInterfaceType=\"").append(this.getOptNetworkInterfaceTypeValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            strAttrs.append("_i=\"").append(this.getI()).append("\" ");
            strAttrs.append("_t=\"").append(this.getT()).append("\" ");
            strAttrs.append("_d=\"").append(this.getD()).append("\" ");
            strAttrs.append("_v=\"").append(this.getV()).append("\" ");
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            int oNum = this.getObsoleteItemCount();
            if (cNum > 0 || oNum > 0) {
                int i;
                os_for_xml_generating.write(62);
                closed = true;
                for (i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
                for (i = 0; i < this.getObsoleteItemCount(); ++i) {
                    ObsoleteItem o = this.getObsoleteItem(i);
                    o.doSerialize(os_for_xml_generating);
                }
            }
            if (appendMetadata && (metadata = this.getMetadataAttributes()) != null) {
                if (!closed) {
                    os_for_xml_generating.write(62);
                    closed = true;
                }
                StringBuffer metaStr = new StringBuffer("<Metadata ChechSum=\"");
                metaStr.append(metadata.getChecksum()).append("\"");
                if (metadata.getOwner() != null) {
                    metaStr.append(" Owner=\"").append(metadata.getOwner()).append("\"");
                }
                metaStr.append("/>");
                os_for_xml_generating.write(metaStr.toString().getBytes("UTF-8"));
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</NetworkConnection>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

